/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareContentViewerSwitchingPane;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.control.R4ECompareAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.control.R4ESingleAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.UIElementsProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IParticipantInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IParticipantUnassignDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditorProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtils {
    private static final String COMPARE_EDITOR_TEXT_CLASS_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewer";
    private static final String COMPARE_EDITOR_TEXT_FIELD_LEFT = "fLeft";
    private static final String COMPARE_EDITOR_TEXT_FIELD_RIGHT = "fRight";
    private static final String DEFAULT_OBJECT_CLASS_NAME = "Object";
    public static final boolean TEST_MODE;
    private static final String COMPATIBILITY_ERROR_MESSAGE = "Cannot use older version of R4E to open newer element version";
    private static final String COMPATIBILITY_WARNING_DIALOG_TITLE = "Version Mismatch Detected";
    private static final String COMPATIBILITY_WARNING_MESSAGE;
    private static final String[] COMPATIBILITY_WARNING_DIALOG_BUTTONS;
    private static final String MEETING_DATA_MISMATCH_DIALOG_TITLE = "Meeting Data Mismatch Detected";
    private static final String MEETING_DATA_MISMATCH_MESSAGE;
    private static final String[] MEETING_DATA_MISMATCH_DIALOG_BUTTONS;
    public static final Color DISABLED_FONT_COLOR;
    public static final Color ENABLED_FONT_COLOR;
    private static final String SINGLE_KEY_ANNOTATION_SUPPORT = "singleEditorAnnotationSupport";
    private static final String COMPARE_KEY_ANNOTATION_SUPPORT = "compareEditorAnnotationSupport";
    private static final ReentrantLock fLock;

    static {
        String application = System.getProperty("eclipse.application", "");
        if (application.length() > 0) {
            TEST_MODE = application.endsWith("testapplication") || application.endsWith("uitest");
        } else {
            String commands = System.getProperty("eclipse.commands", "");
            TEST_MODE = commands.contains("testapplication\n");
        }
        ErrorDialog.AUTOMATED_MODE = TEST_MODE;
        COMPATIBILITY_WARNING_MESSAGE = "You are trying to open an older version of the element than the one currently handled by this version of R4E." + R4EUIConstants.LINE_FEED + "You can open the element normally, which will convert its version to the current application meta-data, or in Read-only mode, which will preserve its version.";
        COMPATIBILITY_WARNING_DIALOG_BUTTONS = new String[]{"Open (Convert Version)", "Open in Read-Only Mode (Preserve Version)", "Cancel"};
        MEETING_DATA_MISMATCH_MESSAGE = "R4E Meeting Data is different than the Remote Mail Server Meeting Data." + R4EUIConstants.LINE_FEED + "Which one should we keep?";
        MEETING_DATA_MISMATCH_DIALOG_BUTTONS = new String[]{"Use Local data", "Use Remote Data", "Cancel"};
        DISABLED_FONT_COLOR = Display.getCurrent().getSystemColor(16);
        ENABLED_FONT_COLOR = Display.getCurrent().getSystemColor(2);
        fLock = new ReentrantLock();
    }

    public static Image loadIcon(String aUrl) {
        R4EUIPlugin plugin = R4EUIPlugin.getDefault();
        fLock.lock();
        Image icon = plugin.getImageRegistry().get(aUrl);
        try {
            if (icon == null) {
                URL imageURL = plugin.getBundle().getEntry(aUrl);
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
                icon = descriptor.createImage();
                plugin.getImageRegistry().put(aUrl, icon);
            }
        }
        finally {
            fLock.unlock();
        }
        return icon;
    }

    public static Image loadDisabledIcon(final String aUrl) {
        final R4EUIPlugin plugin = R4EUIPlugin.getDefault();
        fLock.lock();
        Image icon = plugin.getImageRegistry().get(String.valueOf(aUrl) + "_disabled");
        try {
            if (icon == null) {
                URL imageURL = plugin.getBundle().getEntry(aUrl);
                ImageDescriptor originalDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                final ImageDescriptor disabledDescriptor = ImageDescriptor.createWithFlags((ImageDescriptor)originalDescriptor, (int)1);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Image newIcon = disabledDescriptor.createImage();
                        plugin.getImageRegistry().put(String.valueOf(aUrl) + "_disabled", newIcon);
                    }
                });
            }
        }
        finally {
            fLock.unlock();
        }
        return icon;
    }

    public static void displayResourceErrorDialog(ResourceHandlingException e) {
        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Resource Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayCompatibilityErrorDialog(CompatibilityException e) {
        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Compatibility problem Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayCompatibilityErrorDialog() {
        R4EUIPlugin.Ftracer.traceError(COMPATIBILITY_ERROR_MESSAGE);
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Compatibility problem Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, COMPATIBILITY_ERROR_MESSAGE, null), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static int displayCompatibilityWarningDialog(final String aDataVersion, final String aApplVersionl) {
        R4EUIPlugin.Ftracer.traceWarning(COMPATIBILITY_WARNING_MESSAGE);
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(null, UIUtils.COMPATIBILITY_WARNING_DIALOG_TITLE, null, String.valueOf(COMPATIBILITY_WARNING_MESSAGE) + R4EUIConstants.LINE_FEED + "Element meta-data Version: " + aDataVersion + R4EUIConstants.LINE_FEED + "Application meta-data Version: " + aApplVersionl, 6, COMPATIBILITY_WARNING_DIALOG_BUTTONS, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public static void displaySyncErrorDialog(OutOfSyncException e) {
        R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Synchronization Error DetectedPlease refresh the review navigator view and try the command again", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayReviewsFileStorageErrorDialog(ReviewsFileStorageException e) {
        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Local Review Storage Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayCoreErrorDialog(CoreException e) {
        UIUtils.displayCoreErrorDialog(e, true);
    }

    public static void displayCoreErrorDialog(CoreException aEx, Boolean aBol) {
        if (aBol.booleanValue()) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + aEx.toString() + " (" + aEx.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + aEx.toString(), (Exception)((Object)aEx));
        }
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Eclipse Runtime Core Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, aEx.getMessage(), (Throwable)aEx), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static void displayFailedLoadDialog(List<String> aLoadErrors) {
        StringBuilder errorMsgs = new StringBuilder();
        errorMsgs.append("The following errors were reported:" + R4EUIConstants.LINE_FEED);
        for (String msg : aLoadErrors) {
            errorMsgs.append(msg);
        }
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Some elements failed to load", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, errorMsgs.toString(), null), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static int displayMeetingDataMismatchDialog(final IMeetingData aLocalData, final IMeetingData aRemoteData) {
        R4EUIPlugin.Ftracer.traceWarning(MEETING_DATA_MISMATCH_MESSAGE);
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SimpleDateFormat dueDateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm");
                String localStartTime = dueDateFormat.format(new Date(aLocalData.getStartTime()));
                String remoteStartTime = "";
                String remoteLocation = "";
                String remoteDuration = "";
                if (aRemoteData != null) {
                    remoteStartTime = dueDateFormat.format(new Date(aRemoteData.getStartTime()));
                    remoteLocation = aRemoteData.getLocation();
                    remoteDuration = aRemoteData.getDuration().toString();
                }
                MessageDialog dialog = new MessageDialog(null, UIUtils.MEETING_DATA_MISMATCH_DIALOG_TITLE, null, String.valueOf(MEETING_DATA_MISMATCH_MESSAGE) + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED + "Local Data:" + R4EUIConstants.LINE_FEED + "\t" + "Start time = " + localStartTime + R4EUIConstants.LINE_FEED + "\t" + "Duration = " + aLocalData.getDuration() + R4EUIConstants.LINE_FEED + "\t" + "Location = " + aLocalData.getLocation() + R4EUIConstants.LINE_FEED + "Remote Data:" + R4EUIConstants.LINE_FEED + "\t" + "Start time = " + remoteStartTime + R4EUIConstants.LINE_FEED + "\t" + "Duration = " + remoteDuration + R4EUIConstants.LINE_FEED + "\t" + "Location = " + remoteLocation, 6, MEETING_DATA_MISMATCH_DIALOG_BUTTONS, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public static void displayPastDateError(Date aPastDate, String aPastDateStr) {
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Date Passed Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "You cannot specify a date (" + aPastDateStr + ") that occured in the past", null), 4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public static boolean isFilterPreferenceSet(Object aFilterSet) {
        return aFilterSet != null && aFilterSet.toString().equals("true");
    }

    public static List<String> parseStringList(String aStringList) {
        ArrayList<String> stringArray = new ArrayList<String>();
        if (aStringList != null) {
            StringTokenizer st = new StringTokenizer(aStringList, String.valueOf(File.pathSeparator) + R4EUIConstants.LINE_FEED);
            while (st.hasMoreElements()) {
                stringArray.add((String)st.nextElement());
            }
        }
        return stringArray;
    }

    public static void addTabbedPropertiesTextResizeListener(final Text aText) {
        aText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point newSize = aText.computeSize(-1, -1);
                Point oldSize = aText.getSize();
                int heightDiff = newSize.y - oldSize.y;
                if (heightDiff != 0 && oldSize.y != 0) {
                    aText.setSize(newSize);
                    aText.getParent().layout();
                    Composite scrolledParent = aText.getParent();
                    while (!(scrolledParent instanceof ScrolledComposite)) {
                        if ((scrolledParent = scrolledParent.getParent()) != null) continue;
                        return;
                    }
                    ((ScrolledComposite)scrolledParent).setMinSize(aText.getParent().computeSize(-1, -1));
                    if (aText.getLocation().y + aText.getCaretLocation().y + aText.getLineHeight() > scrolledParent.getClientArea().y + scrolledParent.getClientArea().height) {
                        Point origin = ((ScrolledComposite)scrolledParent).getOrigin();
                        origin.y += heightDiff;
                        ((ScrolledComposite)scrolledParent).setOrigin(origin);
                    }
                }
            }
        });
    }

    public static int mapParticipantToIndex(String aParticipant) {
        if (R4EUIModelController.getActiveReview() == null) {
            return 0;
        }
        List<R4EParticipant> participants = R4EUIModelController.getActiveReview().getParticipants(false);
        int numParticipants = participants.size();
        int index = 0;
        int i = 0;
        while (i < numParticipants) {
            if (participants.get(i).isEnabled()) {
                if (participants.get(i).getId().equals(aParticipant)) {
                    return index;
                }
                ++index;
            }
            ++i;
        }
        return -1;
    }

    public static R4EDesignRuleClass getClassFromString(String aClass) {
        if (aClass.equals("Erroneous")) {
            return R4EDesignRuleClass.R4E_CLASS_ERRONEOUS;
        }
        if (aClass.equals("Superfluous")) {
            return R4EDesignRuleClass.R4E_CLASS_SUPERFLUOUS;
        }
        if (aClass.equals("Improvement")) {
            return R4EDesignRuleClass.R4E_CLASS_IMPROVEMENT;
        }
        if (aClass.equals("Comment")) {
            return R4EDesignRuleClass.R4E_CLASS_COMMENT;
        }
        if (aClass.equals("Question")) {
            return R4EDesignRuleClass.R4E_CLASS_QUESTION;
        }
        if (aClass.equals("Missing")) {
            return R4EDesignRuleClass.R4E_CLASS_MISSING;
        }
        return null;
    }

    public static String getClassStr(R4EDesignRuleClass aClass) {
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_ERRONEOUS)) {
            return "Erroneous";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_SUPERFLUOUS)) {
            return "Superfluous";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_IMPROVEMENT)) {
            return "Improvement";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_QUESTION)) {
            return "Question";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_COMMENT)) {
            return "Comment";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_MISSING)) {
            return "Missing";
        }
        return null;
    }

    public static R4EDesignRuleRank getRankFromString(String aRank) {
        if (aRank.equals("NONE")) {
            return R4EDesignRuleRank.R4E_RANK_NONE;
        }
        if (aRank.equals("MINOR")) {
            return R4EDesignRuleRank.R4E_RANK_MINOR;
        }
        if (aRank.equals("MAJOR")) {
            return R4EDesignRuleRank.R4E_RANK_MAJOR;
        }
        return null;
    }

    public static String getRankStr(R4EDesignRuleRank aRank) {
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_NONE)) {
            return "NONE";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_MINOR)) {
            return "MINOR";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_MAJOR)) {
            return "MAJOR";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_DEPRECATED)) {
            return "MINOR";
        }
        return null;
    }

    public static String[] getClasses() {
        return R4EUIConstants.CLASS_VALUES;
    }

    public static String[] getRanks() {
        return R4EUIConstants.RANK_VALUES;
    }

    public static String buildUserDetailsString(IUserInfo aUserInfo) {
        StringBuffer tempStr = new StringBuffer(100);
        int numAttributeTypes = aUserInfo.getAttributeTypes().length;
        int i = 0;
        while (i < numAttributeTypes) {
            tempStr.append(String.valueOf(aUserInfo.getAttributeTypes()[i]) + " = " + aUserInfo.getAttributeValues()[i] + R4EUIConstants.LINE_FEED);
            ++i;
        }
        return tempStr.toString();
    }

    public static boolean selectElementInEditor(R4ECompareEditorInput aInput) {
        if (R4EUIModelController.getNavigatorView() != null) {
            ISelection selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
            IR4EUIModelElement element = (IR4EUIModelElement)((IStructuredSelection)selection).getFirstElement();
            IR4EUIPosition position = null;
            boolean isLeftPane = true;
            if (element instanceof R4EUIAnomalyBasic) {
                position = ((R4EUIAnomalyBasic)element).getPosition();
                if (element instanceof R4EUIPostponedAnomaly) {
                    isLeftPane = false;
                }
            } else if (element instanceof R4EUIComment) {
                position = ((R4EUIAnomalyBasic)element.getParent()).getPosition();
            } else if (element instanceof R4EUIContent) {
                position = ((R4EUIContent)element).getPosition();
            }
            if (position != null) {
                return UIUtils.selectElementInEditorPane(aInput.getNavigator(), position, isLeftPane);
            }
        }
        return true;
    }

    public static boolean selectElementInEditorPane(ICompareNavigator aNavigator, IR4EUIPosition aPosition, boolean aIsLeftPane) {
        if (aNavigator instanceof CompareEditorInputNavigator) {
            Object[] panes;
            Object[] objectArray = panes = ((CompareEditorInputNavigator)aNavigator).getPanes();
            int n = panes.length;
            int n2 = 0;
            while (n2 < n) {
                Viewer viewer;
                Object pane = objectArray[n2];
                if (pane instanceof CompareContentViewerSwitchingPane && (viewer = ((CompareContentViewerSwitchingPane)pane).getViewer()) instanceof TextMergeViewer) {
                    MergeSourceViewer sourceViewer;
                    block11: {
                        TextMergeViewer textViewer = (TextMergeViewer)viewer;
                        Class<?> textViewerClass = textViewer.getClass();
                        if (!textViewerClass.getName().equals(COMPARE_EDITOR_TEXT_CLASS_NAME)) {
                            while (!(textViewerClass = textViewerClass.getSuperclass()).getName().equals(DEFAULT_OBJECT_CLASS_NAME) && !textViewerClass.getName().equals(COMPARE_EDITOR_TEXT_CLASS_NAME)) {
                            }
                        }
                        Field field = aIsLeftPane ? textViewerClass.getDeclaredField(COMPARE_EDITOR_TEXT_FIELD_LEFT) : textViewerClass.getDeclaredField(COMPARE_EDITOR_TEXT_FIELD_RIGHT);
                        field.setAccessible(true);
                        sourceViewer = (MergeSourceViewer)field.get(textViewer);
                        int visibleOffset = sourceViewer.getSourceViewer().getVisibleRegion().getOffset();
                        int visibleLength = sourceViewer.getSourceViewer().getVisibleRegion().getLength();
                        int elementOffset = ((R4EUITextPosition)aPosition).getOffset();
                        int elementLength = ((R4EUITextPosition)aPosition).getLength();
                        if (elementOffset >= visibleOffset && elementOffset + elementLength <= visibleOffset + visibleLength) break block11;
                        return false;
                    }
                    try {
                        ITextEditor adapter = (ITextEditor)sourceViewer.getAdapter(ITextEditor.class);
                        adapter.selectAndReveal(((R4EUITextPosition)aPosition).getOffset(), ((R4EUITextPosition)aPosition).getLength());
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                ++n2;
            }
        }
        return true;
    }

    public static void openUrl(String aLocation) {
        URL url = null;
        if (aLocation != null) {
            try {
                url = new URL(aLocation);
            }
            catch (MalformedURLException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Invalid location", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(generatedId);
            browser.openURL(url);
        }
        catch (PartInitException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Error opening Browser", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
    }

    public static void changeReviewPhase(IR4EUIModelElement aReview, R4EReviewPhase aNewPhase) {
        block10: {
            AtomicReference<Object> aResultMsg = new AtomicReference<Object>(null);
            if (((R4EUIReviewBasic)aReview).validatePhaseChange(aNewPhase, aResultMsg)) {
                if (aResultMsg.get() != null) {
                    final ErrorDialog dialog = new ErrorDialog(null, "Warning", (String)aResultMsg.get(), (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, null, null), 2);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            dialog.open();
                        }
                    });
                }
                try {
                    if (aReview instanceof R4EUIReviewExtended) {
                        R4EFormalReview review = (R4EFormalReview)((R4EUIReviewExtended)aReview).getReview();
                        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION) && review.getActiveMeeting() == null) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        MailServicesProxy.sendMeetingRequest();
                                    }
                                    catch (ResourceHandlingException e) {
                                        UIUtils.displayResourceErrorDialog(e);
                                    }
                                    catch (OutOfSyncException e) {
                                        UIUtils.displaySyncErrorDialog(e);
                                    }
                                }
                            });
                        }
                        if (review.getActiveMeeting() != null) {
                            ((R4EUIReviewExtended)aReview).updatePhase(aNewPhase);
                        } else {
                            final ErrorDialog dialog = new ErrorDialog(null, "Error", "No Meeting Data present", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Please allow sending out a Meeting Request", null), 4);
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    dialog.open();
                                }
                            });
                        }
                        break block10;
                    }
                    ((R4EUIReviewBasic)aReview).updatePhase(aNewPhase);
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
            } else {
                final ErrorDialog dialog = new ErrorDialog(null, "Review Error", "Review phase cannot be changed", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, (String)aResultMsg.get(), null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
    }

    public static void changeAnomalyState(final IR4EUIModelElement aAnomaly, R4EAnomalyState aNewState) {
        try {
            ((R4EUIAnomalyExtended)aAnomaly).updateState(aNewState);
            if (aAnomaly instanceof R4EUIPostponedAnomaly) {
                ((R4EUIPostponedAnomaly)aAnomaly).updateOriginalAnomaly();
            }
            if (aAnomaly.getParent().getParent() instanceof R4EUIFileContext) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        UIUtils.updateAnnotation(aAnomaly, (R4EUIFileContext)aAnomaly.getParent().getParent());
                    }
                });
            }
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
        catch (CompatibilityException e) {
            UIUtils.displayCompatibilityErrorDialog(e);
        }
    }

    public static void setNavigatorViewFocus(IR4EUIModelElement aElement, int aExpandLevel) {
        if (aElement != null) {
            R4EUIModelController.getNavigatorView().updateView(aElement, aExpandLevel, true);
        }
    }

    public static String formatAssignedParticipants(EList<String> aParticipants) {
        if (aParticipants.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            for (String participants : aParticipants) {
                buffer.append(String.valueOf(participants) + ";" + " ");
            }
            return buffer.toString().substring(0, buffer.length() - 2);
        }
        return "";
    }

    public static String getParticipantFilterInputDialog() {
        InputDialog dlg = R4EUIDialogFactory.getInstance().getParticipantFilterInputDialog();
        if (dlg.open() == 0) {
            return dlg.getValue();
        }
        return "";
    }

    public static List<R4EParticipant> getAssignParticipants() {
        final IParticipantInputDialog dialog = R4EUIDialogFactory.getInstance().getParticipantInputDialog(false);
        final int[] result = new int[1];
        final ArrayList<R4EParticipant> resultParticipants = new ArrayList<R4EParticipant>();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.create();
                result[0] = dialog.open();
                for (R4EParticipant participant : dialog.getParticipants()) {
                    resultParticipants.add(participant);
                }
                R4EUIDialogFactory.getInstance().removeParticipantInputDialog();
            }
        });
        if (result[0] == 0) {
            return resultParticipants;
        }
        return new ArrayList<R4EParticipant>(0);
    }

    public static List<R4EParticipant> getUnassignParticipants(IR4EUIModelElement aElement) {
        final IParticipantUnassignDialog dialog = R4EUIDialogFactory.getInstance().getParticipantUnassignDialog(aElement);
        final int[] result = new int[1];
        final ArrayList<R4EParticipant> resultParticipants = new ArrayList<R4EParticipant>();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.create();
                result[0] = dialog.open();
                for (R4EParticipant participant : dialog.getParticipants()) {
                    resultParticipants.add(participant);
                }
            }
        });
        if (result[0] == 0) {
            return resultParticipants;
        }
        return new ArrayList<R4EParticipant>(0);
    }

    public static String getProjectPath(R4EFileVersion aFileVersion) {
        String path = "";
        try {
            URI uri;
            String uriPath;
            if (aFileVersion.getPlatformURI() != null && (uriPath = (uri = new URI(aFileVersion.getPlatformURI())).getPath()) != null) {
                path = uriPath.substring(uriPath.indexOf("/", 1) + 1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return path;
    }

    public static String formatNumChanges(int aNumChanges, int aNumReviewedChanges) {
        return String.valueOf(Integer.toString(aNumReviewedChanges)) + "/" + Integer.toString(aNumChanges);
    }

    public static void refreshAnnotations(R4EUIFileContext aFile) {
        IReviewAnnotationSupport support = UIUtils.getAnnotationSupport(aFile);
        if (support != null) {
            support.refreshAnnotations((Object)aFile);
        }
    }

    public static void addAnnotation(IR4EUIModelElement aSource, R4EUIFileContext aFile) {
        IReviewAnnotationSupport support = UIUtils.getAnnotationSupport(aFile);
        if (support != null) {
            support.addAnnotation((Object)aSource);
        }
    }

    public static void updateAnnotation(IR4EUIModelElement aSource, R4EUIFileContext aFile) {
        IReviewAnnotationSupport support = UIUtils.getAnnotationSupport(aFile);
        if (support != null) {
            support.updateAnnotation((Object)aSource);
        }
    }

    public static void removeAnnotation(IR4EUIModelElement aSource, R4EUIFileContext aFile) {
        IReviewAnnotationSupport support = UIUtils.getAnnotationSupport(aFile);
        if (support != null) {
            support.removeAnnotation((Object)aSource);
        }
    }

    public static IReviewAnnotationSupport getAnnotationSupport(R4EUIFileContext aFile) {
        IReviewAnnotationSupport support = null;
        IEditorPart editor = EditorProxy.findReusableCompareEditor(R4EUIModelController.getNavigatorView().getSite().getPage(), aFile.getBaseFileVersion(), aFile.getTargetFileVersion());
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Viewer viewer = ((R4ECompareEditorInput)input).getContentViewer();
            if (viewer != null) {
                support = UIUtils.getCompareAnnotationSupport(viewer, aFile);
            }
        } else {
            ITextOperationTarget target;
            editor = EditorProxy.findReusableEditor(R4EUIModelController.getNavigatorView().getSite().getPage(), aFile.getTargetFileVersion());
            if (editor != null && (target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class)) instanceof SourceViewer) {
                SourceViewer sourceViewer = (SourceViewer)target;
                support = UIUtils.getSingleAnnotationSupport(sourceViewer, aFile);
            }
        }
        return support;
    }

    public static IReviewAnnotationSupport getSingleAnnotationSupport(SourceViewer aSourceViewer, Object aFileContext) {
        Object support = (IReviewAnnotationSupport)aSourceViewer.getData(SINGLE_KEY_ANNOTATION_SUPPORT);
        if (support == null) {
            support = new R4ESingleAnnotationSupport((ISourceViewer)aSourceViewer, aFileContext);
            aSourceViewer.setData(SINGLE_KEY_ANNOTATION_SUPPORT, support);
        }
        return support;
    }

    public static IReviewAnnotationSupport getCompareAnnotationSupport(Viewer aViewer, Object aFileContext) {
        Object support = (IReviewAnnotationSupport)aViewer.getData(COMPARE_KEY_ANNOTATION_SUPPORT);
        if (support == null) {
            support = new R4ECompareAnnotationSupport(aViewer, aFileContext);
            aViewer.setData(COMPARE_KEY_ANNOTATION_SUPPORT, support);
        }
        return support;
    }

    public static Color updateAnnotationColor(AnnotationPreference aPref, IPreferenceStore aStore) {
        if (aPref != null) {
            RGB rgb = UIUtils.getColorFromAnnotationPreference(aStore, aPref);
            return EditorsUI.getSharedTextColors().getColor(rgb);
        }
        return null;
    }

    public static RGB getColorFromAnnotationPreference(IPreferenceStore aStore, AnnotationPreference aPref) {
        String key = aPref.getColorPreferenceKey();
        RGB rgb = null;
        if (aStore.contains(key)) {
            rgb = aStore.isDefault(key) ? aPref.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)aStore, (String)key);
        }
        if (rgb == null) {
            rgb = aPref.getColorPreferenceValue();
        }
        return rgb;
    }

    public static List<IR4EUIModelElement> getCommandUIElements() {
        UIElementsProvider uiElementProvider = UIUtils.getSourceProvider();
        if (uiElementProvider != null) {
            return uiElementProvider.getSelectedElements();
        }
        ArrayList<IR4EUIModelElement> uiElements = new ArrayList<IR4EUIModelElement>(1);
        return uiElements;
    }

    public static void setCommandUIElements(List<IR4EUIModelElement> uiElements) {
        UIElementsProvider uiElementProvider = UIUtils.getSourceProvider();
        if (uiElementProvider != null) {
            uiElementProvider.setSelectedElements(uiElements);
        }
    }

    public static void clearCommandUIElements() {
        UIElementsProvider uiElementProvider = UIUtils.getSourceProvider();
        if (uiElementProvider != null) {
            uiElementProvider.setSelectedElements(null);
        }
    }

    private static UIElementsProvider getSourceProvider() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
            return (UIElementsProvider)service.getSourceProvider("org.eclipse.mylyn.reviews.r4e.ui.commands.selectedElements");
        }
        return null;
    }
}

