/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.progress.UIJob;

public class LinkPropertiesHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String COMMAND_MESSAGE = "Changing Properties Link Status...";

    public Object execute(final ExecutionEvent aEvent) {
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean oldValue;
                monitor.beginTask(LinkPropertiesHandler.COMMAND_MESSAGE, 1);
                Object[] elements = R4EUIModelController.getNavigatorView().getTreeViewer().getExpandedElements();
                try {
                    Command command = aEvent.getCommand();
                    oldValue = HandlerUtil.toggleCommandState((Command)command);
                }
                catch (ExecutionException executionException) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (!oldValue) {
                    R4EUIPlugin.Ftracer.traceInfo("Linking Properties view with ReviewNavigator");
                } else {
                    R4EUIPlugin.Ftracer.traceInfo("Unlinking Properties view with ReviewNavigator");
                }
                R4EUIModelController.getNavigatorView().setPropertiesLinked(!oldValue);
                R4EUIModelController.getNavigatorView().getTreeViewer().setExpandedElements(elements);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.LinkProperties");
        element.setChecked(((Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue()).booleanValue());
    }
}

