/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;

public class R4EUIReview
extends R4EUIModelElement {
    public static final String REVIEW_UNKNOWN_ICON_FILE = "icons/obj16/review_obj.gif";
    private static final String OPEN_ELEMENT_COMMAND_NAME = "Open Review";
    private static final String OPEN_ELEMENT_COMMAND_TOOLTIP = "Open and Load Data for this Review";
    private static final String UNKNOWN_REVIEW_TYPE_TOOLTIP = "Review Version Data is not Compatible with the current R4E Version." + R4EUIConstants.LINE_FEED + "Open Review to Upgrade.";
    protected R4EReview fReview;
    protected final String fReviewName;

    public R4EUIReview(R4EUIReviewGroup aParent, R4EReview aReview, boolean aResolved) {
        super(aParent, "Unknown: " + aReview.getName());
        this.fResolved = aResolved;
        this.fReview = aReview;
        this.fReviewName = aReview.getName();
        this.fOpen = false;
    }

    protected R4EUIReview(R4EUIReviewGroup aParent, R4EReview aReview, String aName) {
        super(aParent, aName);
        this.fReview = aReview;
        this.fReviewName = aReview.getName();
    }

    public R4EReview getReview() {
        return this.fReview;
    }

    public String getReviewName() {
        return this.fReviewName;
    }

    public String getImageLocation() {
        return REVIEW_UNKNOWN_ICON_FILE;
    }

    public boolean hasChildren() {
        return false;
    }

    public IR4EUIModelElement[] getChildren() {
        return new IR4EUIModelElement[0];
    }

    public boolean isEnabled() {
        return this.fReview.isEnabled();
    }

    public String getToolTip() {
        return UNKNOWN_REVIEW_TYPE_TOOLTIP;
    }

    public boolean isOpenElementCmd() {
        return this.isEnabled() && !this.isOpen();
    }

    public String getOpenElementCmdName() {
        return OPEN_ELEMENT_COMMAND_NAME;
    }

    public String getOpenElementCmdTooltip() {
        return OPEN_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isShowPropertiesCmd() {
        return false;
    }
}

