/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;

public class R4EUIPostponedAnomalyContainer
extends R4EUIAnomalyContainer {
    private final List<R4EUIPostponedAnomaly> fPostponedAnomalies;

    public R4EUIPostponedAnomalyContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
        this.fReadOnly = aParent.isReadOnly();
        this.fPostponedAnomalies = new ArrayList<R4EUIPostponedAnomaly>();
        this.setImage("icons/obj16/anmlycont_obj.gif");
    }

    public IR4EUIModelElement[] getChildren() {
        return this.fPostponedAnomalies.toArray(new R4EUIPostponedAnomaly[this.fPostponedAnomalies.size()]);
    }

    public boolean hasChildren() {
        return this.fPostponedAnomalies.size() > 0;
    }

    public void close() {
        R4EUIPostponedAnomaly anomaly = null;
        int anomaliesSize = this.fPostponedAnomalies.size();
        int i = 0;
        while (i < anomaliesSize) {
            anomaly = this.fPostponedAnomalies.get(i);
            anomaly.close();
            ++i;
        }
        this.fPostponedAnomalies.clear();
        this.fOpen = false;
    }

    public void open() {
        R4EUIPostponedAnomaly uiAnomaly = null;
        IR4EUIModelElement parentElement = this.getParent();
        EList anomalies = ((R4EUIReviewBasic)parentElement.getParent()).getReview().getTopics();
        if (anomalies != null) {
            int anomaliesSize = anomalies.size();
            R4EAnomaly anomaly = null;
            int i = 0;
            while (i < anomaliesSize) {
                anomaly = (R4EAnomaly)anomalies.get(i);
                if (anomaly.getInfoAtt().get((Object)"originalAnomalyId") != null && (anomaly.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) && anomaly.getLocation().size() == 0) {
                    uiAnomaly = new R4EUIPostponedAnomaly(this, anomaly, null);
                    uiAnomaly.setName(String.valueOf(R4EUIAnomalyExtended.getStateString(anomaly.getState())) + ": " + uiAnomaly.getName());
                    this.addChildren(uiAnomaly);
                    if (uiAnomaly.isEnabled()) {
                        uiAnomaly.open();
                    }
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    public boolean isEnabled() {
        if (this.getParent().isEnabled()) {
            if (this.fPostponedAnomalies.size() == 0) {
                return true;
            }
            for (R4EUIPostponedAnomaly anomaly : this.fPostponedAnomalies) {
                if (!anomaly.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fPostponedAnomalies.add((R4EUIPostponedAnomaly)aChildToAdd);
    }

    public R4EUIPostponedAnomaly createAnomaly(R4EUIReviewBasic aUiReview, R4EAnomaly aPostponedAnomaly) throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        R4EParticipant participant = uiReview.getParticipant(aPostponedAnomaly.getUser().getId(), false);
        boolean isParticipant = true;
        if (participant == null) {
            participant = uiReview.getParticipant(aPostponedAnomaly.getUser().getId(), true);
            isParticipant = false;
        }
        EList savedGlobalAnomalies = ((R4EUIReviewBasic)this.getParent().getParent()).getReview().getTopics();
        R4EAnomaly anomaly = null;
        for (Topic savedAnomaly : savedGlobalAnomalies) {
            String postponedAnomalyId;
            if (((R4EAnomaly)savedAnomaly).getInfoAtt().get((Object)"originalAnomalyId") == null || CommandUtils.getAnomalyParentFile((R4EAnomaly)savedAnomaly) != null || !(postponedAnomalyId = CommandUtils.buildOriginalAnomalyID(aPostponedAnomaly)).equals(((R4EAnomaly)savedAnomaly).getInfoAtt().get((Object)"originalAnomalyId"))) continue;
            anomaly = (R4EAnomaly)savedAnomaly;
        }
        if (anomaly == null) {
            anomaly = R4EUIModelController.FModelExt.createR4EAnomaly(participant);
            CommandUtils.copyAnomalyData(anomaly, aPostponedAnomaly);
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomaly, R4EUIModelController.getReviewer());
            EMap info = anomaly.getInfoAtt();
            info.put((Object)"originalAnomalyId", (Object)CommandUtils.buildOriginalAnomalyID(aPostponedAnomaly));
            info.put((Object)"originalReviewName", (Object)aUiReview.getReview().getName());
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        R4EUIPostponedAnomaly uiAnomaly = new R4EUIPostponedAnomaly(this, anomaly, null);
        uiAnomaly.updateState(aPostponedAnomaly.getState());
        uiAnomaly.setEnabled(true);
        this.addChildren(uiAnomaly);
        if (!isParticipant) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)participant, R4EUIModelController.getReviewer());
            participant.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        return uiAnomaly;
    }

    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIPostponedAnomaly removedElement = this.fPostponedAnomalies.get(this.fPostponedAnomalies.indexOf(aChildToRemove));
        removedElement.removeAllChildren(aFileRemove);
        R4EAnomaly modelAnomaly = removedElement.getAnomaly();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, R4EUIModelController.getReviewer());
        modelAnomaly.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fPostponedAnomalies.remove(removedElement);
        }
    }

    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIPostponedAnomaly anomaly : this.fPostponedAnomalies) {
            this.removeChildren(anomaly, aFileRemove);
        }
    }
}

