/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.notifications.internal.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;

public class MeetingData
implements IMeetingData {
    private String fCcustomID;
    private String fSubject;
    private String fBody;
    private String fLocation;
    private Long fSartTime;
    private Integer fDuration;
    private int fSentCounter = 0;
    private String fSender;
    private final Set<String> fReceivers = new HashSet<String>();

    public static String[] getAttributeTypes() {
        String[] types = new String[]{"Subject", "Location", "Start Time", "Duration", "Body"};
        return types;
    }

    public MeetingData(String aCustomId, String aSubject, String aBody, String aLocation, Long aStartTimeMilli, Integer aDuration, String aSender, String[] aReceivers) throws CoreException {
        this.fCcustomID = aCustomId;
        this.fSubject = aSubject;
        this.fBody = aBody;
        this.fLocation = aLocation;
        this.fSartTime = aStartTimeMilli;
        this.fDuration = aDuration;
        this.fSender = aSender;
        if (aReceivers != null) {
            int i = 0;
            while (i < aReceivers.length) {
                String receiver = aReceivers[i];
                this.fReceivers.add(receiver);
                ++i;
            }
        }
    }

    public String getCustomID() {
        return this.fCcustomID;
    }

    public String getSubject() {
        return this.fSubject;
    }

    public String getBody() {
        return this.fBody;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public Long getStartTime() {
        return this.fSartTime;
    }

    public Integer getDuration() {
        return this.fDuration;
    }

    public int getSentCounter() {
        return this.fSentCounter;
    }

    public String getSender() {
        return this.fSender;
    }

    public String[] getReceivers() {
        String[] receivers = this.fReceivers.toArray(new String[this.fReceivers.size()]);
        return receivers;
    }

    public void incrementSentCounter() {
        ++this.fSentCounter;
    }

    public String toString() {
        return String.valueOf(this.fSubject) + ", " + this.fLocation + ", " + this.fSartTime + ", " + this.fDuration + ", " + this.fBody;
    }

    public void setCustomID(String aId) {
        this.fCcustomID = aId;
    }

    public void setSubject(String aSubject) {
        this.fSubject = aSubject;
    }

    public void setBody(String aBody) {
        this.fBody = aBody;
    }

    public void setLocation(String aLocation) {
        this.fLocation = aLocation;
    }

    public void setStartTime(Long aStartTime) {
        this.fSartTime = aStartTime;
    }

    public void setDuration(Integer aDuration) {
        this.fDuration = aDuration;
    }

    public void setSender(String aSender) {
        this.fSender = aSender;
    }

    public void clearReceivers() {
        this.fReceivers.clear();
    }

    public void addReceiver(String aReceiver) {
        if (aReceiver != null) {
            this.fReceivers.add(aReceiver);
        }
    }

    public void removeReceiver(String aReceiver) {
        if (aReceiver != null) {
            this.fReceivers.remove(aReceiver);
        }
    }

    public void clearSentCounter() {
        this.fSentCounter = 0;
    }
}

