/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.emf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.emf.i18n.EmfMessages;

public abstract class EObjectFromStream<T extends EObject> {
    private final Class<T> expected;

    public EObjectFromStream(Class<T> expected) {
        Objects.requireNonNull(expected, String.valueOf(this.getClass().getSimpleName()) + "::expected");
        this.expected = expected;
    }

    public T get() throws LicensingException {
        return this.get(Collections.emptyMap());
    }

    public T get(Map<?, ?> options) throws LicensingException {
        return this.from(this.only(this.content(options)));
    }

    protected abstract InputStream stream() throws IOException;

    private List<EObject> content(Map<?, ?> options) throws LicensingException {
        XMIResourceImpl resource = new XMIResourceImpl();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream input = this.stream();){
                resource.load(input, options);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(EmfMessages.XmiToEObject_failed_xmi_read, (Throwable)e);
        }
        return resource.getContents();
    }

    private EObject only(List<EObject> contents) throws LicensingException {
        if (contents.size() != 1) {
            throw new LicensingException(String.format(EmfMessages.XmiToEObject_unexpected_amount, contents.size()));
        }
        return contents.get(0);
    }

    private T from(EObject only) throws LicensingException {
        if (!this.expected.isInstance(only)) {
            throw new LicensingException(String.format(EmfMessages.XmiToEObject_unexpected_type, only.eClass().getName()));
        }
        return (T)((EObject)this.expected.cast(only));
    }
}

