/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.agreements.ResolvedAgreement;
import org.eclipse.passage.lic.equinox.io.FileFromBundle;
import org.osgi.framework.Bundle;

public final class BundleResidentAgreement
implements ResolvedAgreement {
    private final Bundle bundle;
    private final String path;

    public BundleResidentAgreement(Bundle bundle, String path) {
        this.bundle = bundle;
        this.path = path;
    }

    public InputStream content() throws IOException {
        return new FileFromBundle(this.bundle, this.path).get();
    }

    public String path() {
        return this.path;
    }

    static final class Pack
    implements Supplier<List<ResolvedAgreement>> {
        private final Bundle bundle;
        private final List<String> paths;

        Pack(Bundle bundle, List<String> paths) {
            this.bundle = bundle;
            this.paths = paths;
        }

        @Override
        public List<ResolvedAgreement> get() {
            return this.paths.stream().map(path -> new BundleResidentAgreement(this.bundle, (String)path)).collect(Collectors.toList());
        }
    }
}

