/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializationException;
import org.apache.http.client.cache.HttpCacheEntrySerializer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpCacheEntrySerializer
implements HttpCacheEntrySerializer {
    private static final List<Pattern> ALLOWED_CLASS_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("^(\\[L)?org\\.apache\\.http\\.(.*)"), Pattern.compile("^(\\[L)?java\\.util\\.(.*)"), Pattern.compile("^(\\[L)?java\\.lang\\.(.*)$"), Pattern.compile("^\\[B$")));
    private final List<Pattern> allowedClassPatterns;

    DefaultHttpCacheEntrySerializer(Pattern ... allowedClassPatterns) {
        this.allowedClassPatterns = Collections.unmodifiableList(Arrays.asList(allowedClassPatterns));
    }

    public DefaultHttpCacheEntrySerializer() {
        this.allowedClassPatterns = ALLOWED_CLASS_PATTERNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(HttpCacheEntry cacheEntry, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(cacheEntry);
        }
        finally {
            oos.close();
        }
    }

    @Override
    public HttpCacheEntry readFrom(InputStream is) throws IOException {
        RestrictedObjectInputStream ois = new RestrictedObjectInputStream(is, this.allowedClassPatterns);
        try {
            HttpCacheEntry httpCacheEntry = (HttpCacheEntry)ois.readObject();
            return httpCacheEntry;
        }
        catch (ClassNotFoundException ex) {
            throw new HttpCacheEntrySerializationException("Class not found: " + ex.getMessage(), ex);
        }
        finally {
            ois.close();
        }
    }

    private static class RestrictedObjectInputStream
    extends ObjectInputStream {
        private final List<Pattern> allowedClassPatterns;

        private RestrictedObjectInputStream(InputStream in, List<Pattern> patterns) throws IOException {
            super(in);
            this.allowedClassPatterns = patterns;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.isProhibited(desc)) {
                throw new HttpCacheEntrySerializationException(String.format("Class %s is not allowed for deserialization", desc.getName()));
            }
            return super.resolveClass(desc);
        }

        private boolean isProhibited(ObjectStreamClass desc) {
            for (Pattern pattern : this.allowedClassPatterns) {
                if (!pattern.matcher(desc.getName()).matches()) continue;
                return false;
            }
            return true;
        }
    }
}

