/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.Restriction;

public final class AcquiredExaminationCertificate
implements ExaminationCertificate {
    private final ZonedDateTime stamp;
    private final Map<Requirement, Permission> permissions;
    private final Collection<Restriction> restrictions;

    public AcquiredExaminationCertificate(Map<Requirement, Permission> permissions, Collection<Restriction> restrictions, ZonedDateTime stamp) {
        Objects.requireNonNull(restrictions, "AcquiredExaminationCertificate::restrictions");
        Objects.requireNonNull(permissions, "AcquiredExaminationCertificate::permissions");
        Objects.requireNonNull(stamp, "AcquiredExaminationCertificate::stamp");
        this.permissions = permissions;
        this.restrictions = restrictions;
        this.stamp = stamp;
    }

    public Collection<Restriction> restrictions() {
        return this.restrictions;
    }

    public ZonedDateTime stamp() {
        return this.stamp;
    }

    public Collection<Requirement> satisfied() {
        return new HashSet<Requirement>(this.permissions.keySet());
    }

    public Permission satisfaction(Requirement satisfied) {
        if (!this.permissions.containsKey(satisfied)) {
            throw new IllegalArgumentException("The requirement has not been satisifed");
        }
        return this.permissions.get(satisfied);
    }
}

