/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.osgi.util.NLS;

public class PartServiceSaveHandler
implements ISaveHandler {
    public Logger logger;

    private void log(String unidentifiedMessage, String identifiedMessage, String id, Exception e) {
        if (this.logger == null) {
            return;
        }
        if (id == null || id.length() == 0) {
            this.logger.error((Throwable)e, unidentifiedMessage);
        } else {
            this.logger.error((Throwable)e, NLS.bind((String)identifiedMessage, (Object)id));
        }
    }

    @Override
    public boolean save(MPart dirtyPart, boolean confirm) {
        Object client = dirtyPart.getObject();
        IEclipseContext context = dirtyPart.getContext();
        if (client == null || context == null) {
            this.log("Failed to persist contents of part", "Failed to persist contents of part ({0}) because the part was not rendered", dirtyPart.getElementId(), new RuntimeException());
            return false;
        }
        if (confirm) {
            switch (this.promptToSave(dirtyPart)) {
                case NO: {
                    return true;
                }
                case CANCEL: {
                    return false;
                }
            }
        }
        try {
            ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)context);
        }
        catch (InjectionException e) {
            this.log("Failed to persist contents of part", "Failed to persist contents of part ({0})", dirtyPart.getElementId(), (Exception)((Object)e));
            return false;
        }
        catch (RuntimeException e) {
            this.log("Failed to persist contents of part via DI", "Failed to persist contents of part ({0}) via DI", dirtyPart.getElementId(), e);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveParts(Collection<MPart> dirtyParts, boolean confirm) {
        if (confirm) {
            ISaveHandler.Save[] decisions;
            List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
            ISaveHandler.Save[] saveArray = decisions = this.promptToSave(dirtyPartsList);
            int n = decisions.length;
            int n2 = 0;
            while (n2 < n) {
                ISaveHandler.Save decision = saveArray[n2];
                if (decision == ISaveHandler.Save.CANCEL) {
                    return false;
                }
                ++n2;
            }
            int i = 0;
            while (i < decisions.length) {
                if (decisions[i] == ISaveHandler.Save.YES && !this.save(dirtyPartsList.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        for (MPart dirtyPart : dirtyParts) {
            if (this.save(dirtyPart, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ISaveHandler.Save promptToSave(MPart dirtyPart) {
        return ISaveHandler.Save.YES;
    }

    @Override
    public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
        ISaveHandler.Save[] rc = new ISaveHandler.Save[dirtyParts.size()];
        int i = 0;
        while (i < rc.length) {
            rc[i] = ISaveHandler.Save.YES;
            ++i;
        }
        return rc;
    }
}

