/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.Framework;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.access.Conditions;
import org.eclipse.passage.lic.internal.base.access.CycleFilter;
import org.eclipse.passage.lic.internal.base.access.Permissions;
import org.eclipse.passage.lic.internal.base.access.Requirements;
import org.eclipse.passage.lic.internal.base.access.Restrictions;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.SumOfDiagnostics;

abstract class Cycle<T> {
    private final Framework framework;
    private final CycleFilter filter;
    private final List<Diagnostic> diagnostics;

    Cycle(Framework framework) {
        this(framework, new CycleFilter());
    }

    Cycle(Framework framework, String feature) {
        this(framework, new CycleFilter(feature));
    }

    private Cycle(Framework framework, CycleFilter filter) {
        Objects.requireNonNull(framework, "Cycle::framework");
        Objects.requireNonNull(filter, "Cycle::filter");
        this.framework = framework;
        this.filter = filter;
        this.diagnostics = new ArrayList<Diagnostic>();
    }

    T apply() {
        return this.examine(this::requirements, this::permissions);
    }

    private T examine(Supplier<ServiceInvocationResult<Collection<Requirement>>> requirements, Supplier<ServiceInvocationResult<Collection<Permission>>> permissions) {
        ServiceInvocationResult<Collection<Requirement>> reqs = requirements.get();
        if (this.failed(reqs)) {
            return this.stop();
        }
        if (this.empty(reqs)) {
            return this.freeWayOut();
        }
        ServiceInvocationResult<Collection<Permission>> perms = permissions.get();
        if (this.failed(perms)) {
            return this.stop();
        }
        ServiceInvocationResult<ExaminationCertificate> examination = this.restrictions((Collection)reqs.data().get(), (Collection)perms.data().get());
        if (this.failed(examination)) {
            return this.stop();
        }
        return this.stop((ExaminationCertificate)examination.data().get());
    }

    private T stop() {
        return this.stopOnError(this.diagnostic());
    }

    private T stop(ExaminationCertificate certificate) {
        return this.stopOnCertificate(certificate, this.diagnostic());
    }

    protected abstract T stopOnError(Diagnostic var1);

    protected abstract T stopOnCertificate(ExaminationCertificate var1, Diagnostic var2);

    protected abstract T freeWayOut();

    private Diagnostic diagnostic() {
        return this.diagnostics.stream().reduce(new BaseDiagnostic(), new SumOfDiagnostics());
    }

    private boolean failed(ServiceInvocationResult<?> result) {
        return !result.diagnostic().severe().isEmpty();
    }

    private <U> boolean empty(ServiceInvocationResult<Collection<U>> collection) {
        return collection.data().map(Collection::isEmpty).orElse(true);
    }

    private <U> ServiceInvocationResult<U> scan(ServiceInvocationResult<U> result) {
        this.diagnostics.add(result.diagnostic());
        return result;
    }

    private ServiceInvocationResult<Collection<Requirement>> requirements() {
        return this.scan(new Requirements((Registry<StringServiceId, ResolvedRequirements>)((Registry)this.framework.accessCycleConfiguration().requirementResolvers().get()), this.filter.requiremental()).get());
    }

    private ServiceInvocationResult<Collection<ConditionPack>> conditions() {
        return this.scan(new Conditions((Registry<StringServiceId, MinedConditions>)((Registry)this.framework.accessCycleConfiguration().conditionMiners().get()), this.framework.product(), this.filter.conditional()).get());
    }

    private ServiceInvocationResult<Collection<Permission>> permissions() {
        ServiceInvocationResult<Collection<ConditionPack>> conditions = this.conditions();
        if (this.failed(conditions) || this.empty(conditions)) {
            return new BaseServiceInvocationResult<Collection<Permission>>(conditions.diagnostic(), Collections.emptyList());
        }
        return this.scan(new Permissions((Registry<StringServiceId, PermissionEmittingService>)((Registry)this.framework.accessCycleConfiguration().permissionEmitters().get()), (Collection)conditions.data().get(), this.framework.product()).get());
    }

    private ServiceInvocationResult<ExaminationCertificate> restrictions(Collection<Requirement> requirements, Collection<Permission> permissions) {
        return this.scan(new Restrictions((Registry<StringServiceId, PermissionsExaminationService>)((Registry)this.framework.accessCycleConfiguration().examinators().get()), requirements, permissions, this.framework.product()).get());
    }
}

