/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.ecore.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.passage.lic.emf.ecore.LicensingEcore;

public class DelegatingEFactory
extends EFactoryImpl {
    public final Map<String, EClass> eClassMap = new HashMap<String, EClass>();
    public final Map<String, EDataType> eDataTypeMap = new HashMap<String, EDataType>();
    public final Map<String, EFactory> eClassFactories = new HashMap<String, EFactory>();
    public final Map<String, EFactory> eDataTypeFactories = new HashMap<String, EFactory>();

    public void addEClassDelegate(EFactory factory, Map<EClass, EClass> eClasses) {
        Set<Map.Entry<EClass, EClass>> entrySet = eClasses.entrySet();
        for (Map.Entry<EClass, EClass> entry : entrySet) {
            String key = LicensingEcore.composeFullQualifiedName(entry.getKey());
            this.eClassFactories.put(key, factory);
            this.eClassMap.put(key, entry.getValue());
        }
    }

    public void addEDataTypeDelegate(EFactory factory, Map<EDataType, EDataType> eDataTypes) {
        Set<Map.Entry<EDataType, EDataType>> entrySet = eDataTypes.entrySet();
        for (Map.Entry<EDataType, EDataType> entry : entrySet) {
            String key = LicensingEcore.composeFullQualifiedName(entry.getKey());
            this.eDataTypeFactories.put(key, factory);
            this.eDataTypeMap.put(key, entry.getValue());
        }
    }

    public EObject create(EClass eClass) {
        EFactory factory = this.resolveDelegate(eClass);
        EClass resolved = this.resolveEClass(eClass);
        if (factory != null && resolved != null) {
            return factory.create(resolved);
        }
        return super.create(eClass);
    }

    public Object createFromString(EDataType eDataType, String stringValue) {
        EFactory factory = this.resolveDelegate(eDataType);
        EDataType resolved = this.resolveEDataType(eDataType);
        if (factory != null && resolved != null) {
            return factory.createFromString(resolved, stringValue);
        }
        return super.createFromString(eDataType, stringValue);
    }

    public String convertToString(EDataType eDataType, Object objectValue) {
        EFactory factory = this.resolveDelegate(eDataType);
        EDataType resolved = this.resolveEDataType(eDataType);
        if (factory != null && resolved != null) {
            return factory.convertToString(resolved, objectValue);
        }
        return super.convertToString(eDataType, objectValue);
    }

    protected EFactory resolveDelegate(EClass eClass) {
        String key = LicensingEcore.composeFullQualifiedName(eClass);
        return this.eClassFactories.get(key);
    }

    protected EFactory resolveDelegate(EDataType eDataType) {
        String key = LicensingEcore.composeFullQualifiedName(eDataType);
        return this.eDataTypeFactories.get(key);
    }

    protected EClass resolveEClass(EClass eClass) {
        String key = LicensingEcore.composeFullQualifiedName(eClass);
        return this.eClassMap.get(key);
    }

    protected EDataType resolveEDataType(EDataType eDataType) {
        String key = LicensingEcore.composeFullQualifiedName(eDataType);
        return this.eDataTypeMap.get(key);
    }
}

