/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.ConditionMiner;
import org.eclipse.passage.lic.api.conditions.ConditionMinerRegistry;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.conditions.BaseConditionMiner;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.eclipse.passage.lic.base.io.NullStreamCodec;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public class BaseConditionMinerRegistry
implements ConditionMinerRegistry {
    private final List<ConditionMiner> conditionMiners = new ArrayList<ConditionMiner>();

    public Iterable<ConditionMiner> getConditionMiners() {
        return Collections.unmodifiableList(this.conditionMiners);
    }

    public void registerConditionMiner(ConditionMiner conditionMiner, Map<String, Object> properties) {
        this.conditionMiners.add(conditionMiner);
    }

    public void unregisterConditionMiner(ConditionMiner conditionMiner, Map<String, Object> properties) {
        this.conditionMiners.remove(conditionMiner);
    }

    /*
     * Loose catch block
     */
    public LicensingResult importConditions(String source, LicensingConfiguration configuration) {
        boolean mkdirs22222222;
        SimpleDateFormat dateFormat;
        String fileName;
        String property = System.getProperty("user.home");
        String value = new File(property).getAbsolutePath();
        Path from = Paths.get(value, ".passage");
        Path configurationPath = LicensingPaths.resolveConfigurationPath(from, configuration);
        File dest = configurationPath.resolve(fileName = String.valueOf((dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS", Locale.ENGLISH)).format(new Date())) + ".licen").toFile();
        File destParent = dest.getParentFile();
        if (!destParent.exists() && !(mkdirs22222222 = destParent.mkdirs())) {
            String message3222 = String.format(BaseMessages.getString("BaseConditionMinerRegistry.e_dest_create_failed"), destParent);
            return LicensingResults.createError(message3222, this.getClass().getName());
        }
        try {
            Throwable mkdirs22222222 = null;
            Object message3222 = null;
            try {
                LicensingResult licensingResult;
                FileOutputStream fos;
                FileInputStream fis;
                block19: {
                    block18: {
                        fis = new FileInputStream(source);
                        fos = new FileOutputStream(dest);
                        NullStreamCodec.transfer(fis, fos);
                        String message2 = String.format(BaseMessages.getString("BaseConditionMinerRegistry.ok_import"), dest);
                        licensingResult = LicensingResults.createOK(message2);
                        if (fos == null) break block18;
                        fos.close();
                    }
                    if (fis == null) break block19;
                    fis.close();
                }
                return licensingResult;
                {
                    catch (Throwable mkdirs22222222) {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            throw mkdirs22222222;
                        }
                        catch (Throwable message3222) {
                            if (mkdirs22222222 == null) {
                                mkdirs22222222 = message3222;
                            } else if (mkdirs22222222 != message3222) {
                                mkdirs22222222.addSuppressed(message3222);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw mkdirs22222222;
                        }
                    }
                }
            }
            catch (Throwable message3222) {
                if (mkdirs22222222 == null) {
                    mkdirs22222222 = message3222;
                } else if (mkdirs22222222 != message3222) {
                    mkdirs22222222.addSuppressed(message3222);
                }
                throw mkdirs22222222;
            }
        }
        catch (Exception e) {
            String message = String.format(BaseMessages.getString("BaseConditionMinerRegistry_lic_conditions_import_failed"), source);
            return LicensingResults.createError(message, this.getClass().getName(), (Throwable)e);
        }
    }

    public String getConditionMinerTarget(ConditionMiner miner) {
        if (miner instanceof BaseConditionMiner) {
            BaseConditionMiner basePathMiner = (BaseConditionMiner)miner;
            return basePathMiner.getBaseLocation();
        }
        return null;
    }
}

