/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.adapter;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.adapter.AdapterFactoryProxy;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;

public final class AdapterManagerListener
implements IRegistryEventListener,
IAdapterManagerProvider {
    public static final String ADAPTER_POINT_ID = "org.eclipse.core.runtime.adapters";
    private final AdapterManager theAdapterManager = AdapterManager.getDefault();

    public AdapterManagerListener() {
        this.theAdapterManager.registerLazyFactoryProvider((IAdapterManagerProvider)this);
    }

    public boolean addFactories(AdapterManager adapterManager) {
        IExtension[] extensions;
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(ADAPTER_POINT_ID);
        if (point == null) {
            return false;
        }
        boolean factoriesAdded = false;
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(element);
                if (proxy != null) {
                    adapterManager.registerFactory((IAdapterFactory)proxy, proxy.getAdaptableType());
                    factoriesAdded = true;
                }
                ++n4;
            }
            ++n2;
        }
        RegistryFactory.getRegistry().addListener(this, ADAPTER_POINT_ID);
        return factoriesAdded;
    }

    private void registerExtension(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(element);
            if (proxy != null) {
                this.theAdapterManager.registerFactory((IAdapterFactory)proxy, proxy.getAdaptableType());
            }
            ++n2;
        }
    }

    @Override
    public synchronized void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.registerExtension(extension);
            ++n2;
        }
        this.theAdapterManager.flushLookup();
    }

    @Override
    public synchronized void removed(IExtension[] extensions) {
        this.theAdapterManager.flushLookup();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            for (List adapterFactories : this.theAdapterManager.getFactories().values()) {
                Iterator it2 = adapterFactories.iterator();
                while (it2.hasNext()) {
                    IAdapterFactory factory = (IAdapterFactory)it2.next();
                    if (!(factory instanceof AdapterFactoryProxy) || !((AdapterFactoryProxy)factory).originatesFrom(extension)) continue;
                    it2.remove();
                }
            }
            ++n2;
        }
    }

    @Override
    public synchronized void added(IExtensionPoint[] extensionPoints) {
    }

    @Override
    public synchronized void removed(IExtensionPoint[] extensionPoints) {
    }

    public synchronized void stop() {
        RegistryFactory.getRegistry().removeListener(this);
    }
}

