/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.eclipse.passage.lic.base.io.NullStreamCodec;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.ConditionMinerRegistry;

public class BaseConditionMinerRegistry
implements ConditionMinerRegistry {
    private final List<ConditionMiner> conditionMiners = new ArrayList<ConditionMiner>();

    public Iterable<ConditionMiner> getConditionMiners() {
        return Collections.unmodifiableList(this.conditionMiners);
    }

    public void registerConditionMiner(ConditionMiner conditionMiner, Map<String, Object> properties) {
        this.conditionMiners.add(conditionMiner);
    }

    public void unregisterConditionMiner(ConditionMiner conditionMiner, Map<String, Object> properties) {
        this.conditionMiners.remove(conditionMiner);
    }

    /*
     * Loose catch block
     */
    public LicensingResult importConditions(String source, LicensingConfiguration configuration) {
        String property = System.getProperty("user.home");
        String value = new File(property).getAbsolutePath();
        Path from = Paths.get(value, LicensingPaths.FOLDER_LICENSING_BASE);
        Path configurationPath = LicensingPaths.resolveConfigurationPath(from, configuration);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS", Locale.ENGLISH);
        String fileName = String.valueOf(dateFormat.format(new Date())) + LicensingPaths.EXTENSION_LICENSE_ENCRYPTED;
        File dest = configurationPath.resolve(fileName).toFile();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try {
                LicensingResult licensingResult;
                FileOutputStream fos;
                FileInputStream fis;
                block18: {
                    block17: {
                        fis = new FileInputStream(source);
                        fos = new FileOutputStream(dest);
                        NullStreamCodec.transfer(fis, fos);
                        licensingResult = LicensingResults.createOK();
                        if (fos == null) break block17;
                        fos.close();
                    }
                    if (fis == null) break block18;
                    fis.close();
                }
                return licensingResult;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = String.format("Failed to import licensing condition from %s", source);
            return LicensingResults.createError(message, source, (Throwable)e);
        }
    }
}

