/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl.acquire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.hc.internal.remote.Client;
import org.eclipse.passage.lic.hc.internal.remote.ResponseHandler;
import org.eclipse.passage.lic.hc.remote.Configuration;
import org.eclipse.passage.lic.hc.remote.Connection;
import org.eclipse.passage.lic.hc.remote.RequestContext;
import org.eclipse.passage.lic.hc.remote.impl.BaseConfiguration;
import org.eclipse.passage.lic.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.hc.remote.impl.RequestParameters;
import org.eclipse.passage.lic.hc.remote.impl.ResultsTransfered;
import org.eclipse.passage.lic.hc.remote.impl.ServiceAny;
import org.eclipse.passage.lic.hc.remote.impl.acquire.ReleaseRequestParameters;
import org.eclipse.passage.lic.internal.emf.EObjectToBytes;
import org.eclipse.passage.lic.internal.licenses.convert.EGrantAcquisition;
import org.eclipse.passage.lic.internal.net.io.SafePayload;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;

final class RemoteRelease<C extends Connection>
extends ServiceAny<C, Boolean, RemoteServiceData.WithPayload<GrantAcquisition>> {
    RemoteRelease(Equipment equipment, Supplier<Client<C, Boolean>> client, Supplier<Path> source) {
        super(equipment, client, source);
    }

    @Override
    protected RemoteRequest<C> request(RemoteServiceData.WithPayload<GrantAcquisition> params, FloatingLicenseAccess access) {
        return new Request(params, access, this.equipment.hashes());
    }

    @Override
    protected ResponseHandler<Boolean> handler(FloatingLicenseAccess access) {
        return new ReleaseResponseHandler();
    }

    private static final class ReleaseResponseHandler
    implements ResponseHandler<Boolean> {
        private ReleaseResponseHandler() {
        }

        @Override
        public Boolean read(ResultsTransfered results, RequestContext context) throws LicensingException {
            return results.successful();
        }
    }

    private final class Request
    extends RemoteRequest<C> {
        private final RemoteServiceData.WithPayload<GrantAcquisition> data;

        Request(RemoteServiceData.WithPayload<GrantAcquisition> data, FloatingLicenseAccess access, HashesRegistry hashes) {
            super(data.product(), access, hashes);
            this.data = data;
        }

        @Override
        public Configuration<C> config() throws LicensingException {
            return new BaseConfiguration.Post(this.encoded(this.payload()));
        }

        private byte[] encoded(byte[] payload) throws LicensingException {
            return new SafePayload(RemoteRelease.this.equipment.keeper(this.data.product()), RemoteRelease.this.equipment.hash(this.hash)).encode(payload);
        }

        @Override
        public RequestParameters parameters() {
            return new ReleaseRequestParameters(this.product, this.data.payload().feature(), this.access, this.hash);
        }

        private byte[] payload() throws LicensingException {
            return new EObjectToBytes((EObject)new EGrantAcquisition(this.data.payload()).get()).get();
        }
    }
}

