/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.passage.lic.agreements.AgreementDescriptor;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.Hashes;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.api.AgreementData;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.api.workspace.Agreements;
import org.eclipse.passage.loc.internal.equinox.AgreementsService;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;

final class LicenseAgreements {
    private final AgreementRegistry registry;

    LicenseAgreements(AgreementRegistry registry) {
        this.registry = registry;
    }

    void install(LicensePlanDescriptor plan, LicenseRequisites license) throws LicensingException {
        Agreements service = new AgreementsService().get();
        Hashes hashes = this.hashes();
        for (String identifier : plan.getAgreements()) {
            this.installAgreement(license, this.registry.agreement(identifier), service, hashes);
        }
    }

    private void installAgreement(LicenseRequisites license, AgreementDescriptor agreement, Agreements service, Hashes hashes) throws LicensingException {
        if (!service.exists(agreement.getFile())) {
            throw new LicensingException(String.format(LicensesCoreMessages.LicenseOperatorServiceImpl_failed_to_find_agreement_file, service.located(agreement.getFile()).info(), agreement.getName()));
        }
        license.getAgreements().add((Object)this.data(agreement, service, hashes));
    }

    private AgreementData data(AgreementDescriptor agreement, Agreements service, Hashes hashes) throws LicensingException {
        AgreementData data = LicensesFactory.eINSTANCE.createAgreementData();
        data.setIdentifier(agreement.getIdentifier());
        data.setName(agreement.getName());
        data.setFile(agreement.getFile());
        data.setContentType(agreement.getMime());
        byte[] content = this.content(agreement, service);
        data.setContent(content);
        data.setHashAlgo(((StringServiceId)hashes.id()).toString());
        data.setHash(hashes.get(content));
        return data;
    }

    private byte[] content(AgreementDescriptor agreement, Agreements service) throws LicensingException {
        try {
            return service.located(agreement.getFile()).content();
        }
        catch (Exception e) {
            throw new LicensingException(String.format(LicensesCoreMessages.LicenseOperatorServiceImpl_failed_to_attach_agreement, agreement.getName(), service.located(agreement.getFile()).info(), e));
        }
    }

    private Hashes hashes() throws LicensingException {
        Optional service = new OperatorGearAware().withGear(gear -> Optional.of(gear.hashes()));
        if (!service.isPresent()) {
            throw new LicensingException("There is no HashesRegistry service supplied by Operator Gear");
        }
        Collection all = ((Registry)((HashesRegistry)service.get()).get()).services();
        if (all.isEmpty()) {
            throw new LicensingException("There is no Hashes service supplied by Operator Gear");
        }
        return (Hashes)all.iterator().next();
    }
}

