/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.passage.lic.floating.model.api.EvaluationInstructions;
import org.eclipse.passage.lic.floating.model.api.FeatureGrant;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.floating.model.api.FloatingServer;
import org.eclipse.passage.lic.floating.model.api.LicenseRequisites;
import org.eclipse.passage.lic.floating.model.api.ProductRef;
import org.eclipse.passage.lic.floating.model.api.UserGrant;
import org.eclipse.passage.lic.floating.model.api.ValidityPeriod;
import org.eclipse.passage.lic.floating.model.api.ValidityPeriodClosed;
import org.eclipse.passage.lic.floating.model.api.VersionMatch;
import org.eclipse.passage.lic.floating.model.meta.FloatingFactory;
import org.eclipse.passage.lic.internal.api.EvaluationType;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleForIdentifier;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Disk;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.internal.api.FloatingLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;

final class FloatingLicensePackFromRequest
implements Supplier<FloatingLicensePack> {
    private final FloatingLicenseRequest request;
    private final LicenseRegistry licenses;
    private final UserRegistry users;
    private final Optional<FloatingLicensePack> template;

    FloatingLicensePackFromRequest(FloatingLicenseRequest request, Optional<FloatingLicensePack> template, LicenseRegistry licenses, UserRegistry users) {
        this.request = request;
        this.template = template;
        this.licenses = licenses;
        this.users = users;
    }

    @Override
    public FloatingLicensePack get() {
        FloatingLicensePack pack = FloatingFactory.eINSTANCE.createFloatingLicensePack();
        pack.setLicense(this.license());
        pack.setHost(this.floatingServer());
        this.userGrants().forEach(arg_0 -> pack.getUsers().add(arg_0));
        this.featureGrants(pack).forEach(arg_0 -> pack.getFeatures().add(arg_0));
        return pack;
    }

    private LicenseRequisites license() {
        LicenseRequisites license = FloatingFactory.eINSTANCE.createLicenseRequisites();
        license.setCompany(this.company());
        license.setIdentifier(this.request.identifier());
        license.setIssueDate(new Date());
        license.setPlan(this.request.plan());
        license.setProduct(this.product());
        license.setValid(this.period());
        return license;
    }

    private FloatingServer floatingServer() {
        FloatingServer server = FloatingFactory.eINSTANCE.createFloatingServer();
        server.setIdentifier(this.serverId());
        server.setAuthentication(this.serverAuthentication());
        return server;
    }

    private String serverId() {
        return this.template.map(l -> l.getHost().getIdentifier()).orElse("Floating-Server-A");
    }

    private EvaluationInstructions serverAuthentication() {
        EvaluationInstructions auth = FloatingFactory.eINSTANCE.createEvaluationInstructions();
        auth.setType(this.serverAuthenticationType());
        auth.setExpression(this.serverAuthenticationExpression());
        return auth;
    }

    private String serverAuthenticationType() {
        return this.template.map(l -> l.getHost().getAuthentication().getType()).orElseGet(this::defaultEvaluationType);
    }

    private String serverAuthenticationExpression() {
        return this.template.map(l -> l.getHost().getAuthentication().getExpression()).orElse(String.format("%s=%s", new Disk.Serial().toString(), "?"));
    }

    private String company() {
        return this.users.getUser((String)this.request.users().iterator().next()).getUserOrigin().getIdentifier();
    }

    private ValidityPeriod period() {
        ValidityPeriodClosed period = FloatingFactory.eINSTANCE.createValidityPeriodClosed();
        period.setFrom(this.request.validFrom());
        period.setUntil(this.request.validUntil());
        return period;
    }

    private ProductRef product() {
        ProductRef product = FloatingFactory.eINSTANCE.createProductRef();
        product.setProduct(this.request.productIdentifier());
        product.setVersion(this.request.productVersion());
        return product;
    }

    private Collection<UserGrant> userGrants() {
        return this.request.users().stream().map(arg_0 -> ((UserRegistry)this.users).getUser(arg_0)).map(this::userGrant).collect(Collectors.toSet());
    }

    private UserGrant userGrant(UserDescriptor user) {
        UserGrant grant = FloatingFactory.eINSTANCE.createUserGrant();
        grant.setAuthentication(this.userAuthentication(user));
        grant.setUser(user.getEmail());
        return grant;
    }

    private EvaluationInstructions userAuthentication(UserDescriptor user) {
        EvaluationInstructions auth = FloatingFactory.eINSTANCE.createEvaluationInstructions();
        auth.setExpression(this.userAuthenticationExpression(user));
        auth.setType(this.userAuthenticationType(user));
        return auth;
    }

    private String userAuthenticationType(UserDescriptor user) {
        return this.template.flatMap(l -> this.forUser((List<UserGrant>)l.getUsers(), user)).map(UserGrant::getAuthentication).map(EvaluationInstructions::getType).orElseGet(() -> ((UserDescriptor)user).getPreferredConditionType());
    }

    private String userAuthenticationExpression(UserDescriptor user) {
        return this.template.flatMap(l -> this.forUser((List<UserGrant>)l.getUsers(), user)).map(UserGrant::getAuthentication).map(EvaluationInstructions::getExpression).orElseGet(() -> ((UserDescriptor)user).getPreferredConditionExpression());
    }

    private Optional<UserGrant> forUser(List<UserGrant> all, UserDescriptor user) {
        return all.stream().filter(u -> user.getEmail().equals(u.getUser())).findFirst();
    }

    private Collection<FeatureGrant> featureGrants(FloatingLicensePack pack) {
        LicensePlanDescriptor plan = this.licenses.getLicensePlan(this.request.plan());
        AtomicInteger counter = new AtomicInteger(0);
        return StreamSupport.stream(plan.getLicensePlanFeatures().spliterator(), false).map(feature -> this.featureGrant((LicensePlanFeatureDescriptor)feature, pack, counter.getAndIncrement())).collect(Collectors.toSet());
    }

    private FeatureGrant featureGrant(LicensePlanFeatureDescriptor feature, FloatingLicensePack pack, int no) {
        FeatureGrant grant = FloatingFactory.eINSTANCE.createFeatureGrant();
        String fid = feature.getFeatureIdentifier();
        grant.setFeature(fid);
        grant.setCapacity(this.request.defaultCapacity());
        grant.setIdentifier(String.format("%s#%d", this.request.identifier(), no));
        grant.setPack(pack);
        grant.setValid(this.featureGrantPeriod(fid));
        grant.setVivid(this.featureGrantVivid(fid));
        grant.setVersion(this.version(feature));
        return grant;
    }

    private ValidityPeriod featureGrantPeriod(String feature) {
        return this.template.flatMap(l -> this.forFeature((List<FeatureGrant>)l.getFeatures(), feature)).map(g -> (ValidityPeriod)EcoreUtil.copy((EObject)g.getValid())).orElseGet(this::period);
    }

    private long featureGrantVivid(String feature) {
        return this.template.flatMap(l -> this.forFeature((List<FeatureGrant>)l.getFeatures(), feature)).map(FeatureGrant::getVivid).orElse(60L);
    }

    private Optional<FeatureGrant> forFeature(List<FeatureGrant> all, String feature) {
        return all.stream().filter(g -> feature.equals(g.getFeature())).findFirst();
    }

    private VersionMatch version(LicensePlanFeatureDescriptor feature) {
        VersionMatch version = FloatingFactory.eINSTANCE.createVersionMatch();
        version.setVersion(feature.getMatchVersion());
        version.setRule(new MatchingRuleForIdentifier(Optional.ofNullable(feature.getMatchRule())).get().identifier());
        return version;
    }

    private String defaultEvaluationType() {
        return new EvaluationType.Hardware().identifier();
    }
}

