/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl.mine;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.internal.hc.remote.impl.HttpClient;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.internal.hc.remote.impl.ServiceEvery;
import org.eclipse.passage.lic.internal.hc.remote.impl.mine.DecryptedConditions;
import org.eclipse.passage.lic.internal.hc.remote.impl.mine.RemoteConditionsRequest;

public final class RemoteConditions<C extends Connection>
extends ServiceEvery<C, Collection<ConditionPack>, RemoteServiceData.Bulk>
implements MinedConditions {
    private final ConditionMiningTarget target = new ConditionMiningTarget.Remote();

    public RemoteConditions(Equipment equipment, Supplier<Client<C, Collection<ConditionPack>>> client, Supplier<Path> source) {
        super(equipment, client, source);
    }

    public RemoteConditions(Equipment equipment) {
        this(equipment, HttpClient::new, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    public ConditionMiningTarget id() {
        return this.target;
    }

    public ServiceInvocationResult<Collection<ConditionPack>> all(LicensedProduct product) {
        return this.request(new RemoteServiceData.Bulk(product));
    }

    @Override
    protected RemoteRequest<C> request(RemoteServiceData.Bulk params, FloatingLicenseAccess access) {
        return new RemoteConditionsRequest(params.product(), access, this.equipment.hashes());
    }

    @Override
    protected ResponseHandler<Collection<ConditionPack>> handler(FloatingLicenseAccess access) {
        return new DecryptedConditions(this.equipment, access.getServer(), this.target);
    }

    @Override
    protected BinaryOperator<Collection<ConditionPack>> sum() {
        return new SumOfCollections();
    }

    @Override
    protected Collection<ConditionPack> noResult() {
        return Collections.emptyList();
    }
}

