/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.passage.loc.report.internal.core.Csv;
import org.eclipse.passage.loc.report.internal.core.ExistingFileStream;
import org.eclipse.passage.loc.report.internal.core.i18n.LicensesReportMessages;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReport;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReportParameters;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReportQuery;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.yars.internal.api.DefaultDosHandler;
import org.eclipse.passage.loc.yars.internal.api.DosHandleMedia;
import org.eclipse.passage.loc.yars.internal.api.Progress;
import org.eclipse.passage.loc.yars.internal.api.ReportException;
import org.eclipse.passage.loc.yars.internal.api.SingleSwoopExport;

public final class LicenseReportToCsv {
    private final LicenseStorage source;

    public LicenseReportToCsv(LicenseStorage source) {
        this.source = source;
    }

    public void export(LicensePlanReportParameters parameters, Path target, Progress<LicensePlanReport> progress) throws ReportException {
        new SingleSwoopExport(new LicensePlanReportQuery().fetch(this.source, parameters)).write(new DosHandleMedia(new Csv(new ExistingFileStream(target), this.header(parameters)), (Consumer)new DefaultDosHandler()), progress);
    }

    private String[] header(LicensePlanReportParameters parameters) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.YYYY");
        ArrayList<String> header = new ArrayList<String>(Arrays.asList(LicensesReportMessages.getString("LicenseReportToCsv_header_planName"), LicensesReportMessages.getString("LicenseReportToCsv_header_planId"), LicensesReportMessages.getString("LicenseReportToCsv_header_amountOfLicenses")));
        if (parameters.explain()) {
            header.add(String.format(LicensesReportMessages.getString("LicenseReportToCsv_details"), format.format(parameters.from()), format.format(parameters.to())));
        }
        return header.toArray(new String[header.size()]);
    }
}

