/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Licenses
implements LicenseStorage {
    private LicenseRegistry licenses;
    private UserRegistry users;

    @Override
    public List<LicensePlanDescriptor> plans() {
        return StreamSupport.stream(this.licenses.getLicensePlans().spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public List<UserLicenseDescriptor> licenses(String plan) {
        return StreamSupport.stream(this.users.getUserLicenses().spliterator(), false).filter(lic -> plan.equals(lic.getPlanIdentifier())).collect(Collectors.toList());
    }

    @Override
    public Optional<LicensePlanDescriptor> plan(String plan) {
        return Optional.ofNullable(this.licenses.getLicensePlan(plan));
    }

    @Reference
    public void installLicenseRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }

    @Reference
    public void installUserRegistry(UserRegistry registry) {
        this.users = registry;
    }
}

