/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportCustomersWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PreviewPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class TargetPage
extends WizardPage {
    private final PreviewPage preview;
    private Text path;
    private Button open;

    protected TargetPage(PreviewPage preview) {
        super("target");
        this.preview = preview;
        this.setTitle(ExportCustomersWizardMessages.TargetPage_title);
        this.setDescription(ExportCustomersWizardMessages.TargetPage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.createPath(content);
        this.createBrowseForPath(content);
        this.createOpen(content);
        new Label(content, 0).setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.setControl((Control)content);
    }

    void installInitial() {
        this.path.setText(System.getProperty("user.home"));
        this.open.setSelection(true);
    }

    Path path() {
        return Paths.get(this.path.getText(), new String[0]);
    }

    boolean open() {
        return this.open.getSelection();
    }

    private void createPath(Composite content) {
        this.path = new Text(content, 2056);
        this.path.setLayoutData((Object)new GridData(4, 128, true, false));
        this.path.addModifyListener(e -> this.updateControls());
    }

    private void updateControls() {
        this.preview.updateTargetPath();
    }

    private void createOpen(Composite content) {
        this.open = new Button(content, 32);
        this.open.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.open.setText(ExportCustomersWizardMessages.TargetPage_open);
    }

    private void createBrowseForPath(Composite content) {
        Button browse = new Button(content, 8);
        browse.setLayoutData((Object)new GridData(131072, 128, false, false));
        browse.setText(ExportCustomersWizardMessages.TargetPage_browse);
        browse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setFilterPath(this.path.getText());
            Optional.ofNullable(dialog.open()).ifPresent(arg_0 -> ((Text)this.path).setText(arg_0));
        }));
    }
}

