/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.internal.users.core.UserDomainRegistry;

public class UsersDomainRegistryTracker
extends DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> {
    public UsersDomainRegistryTracker(UserDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof UserOrigin) {
            UserOrigin userOrigin = (UserOrigin)notifier;
            switch (notification.getFeatureID(UserOrigin.class)) {
                case 0: {
                    this.processUserOriginIdentifier(userOrigin, notification);
                    break;
                }
                case 3: {
                    this.processUserOriginUsers(userOrigin, notification);
                    break;
                }
            }
        } else if (notifier instanceof User) {
            User user = (User)notifier;
            switch (notification.getFeatureID(User.class)) {
                case 1: {
                    this.processUserEmail(user, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processUserOriginIdentifier(UserOrigin userOrigin, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUserOrigin(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUserOrigin((UserOriginDescriptor)userOrigin);
                break;
            }
        }
    }

    protected void processUserOriginUsers(UserOrigin userOrigin, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                User user;
                String email;
                if (!(newValue instanceof User) || (email = (user = (User)newValue).getEmail()) == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
            case 4: {
                User user;
                String email;
                if (!(oldValue instanceof User) || (email = (user = (User)oldValue).getEmail()) == null) break;
                ((UserDomainRegistry)this.registry).unregisterUser(email);
                break;
            }
        }
    }

    protected void processUserEmail(User user, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUser(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
        }
    }
}

