/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;
import org.eclipse.passage.loc.internal.licenses.core.LicenseDomainRegistry;

public class LicensesDomainRegistryTracker
extends DomainContentAdapter<LicensePackDescriptor, LicenseDomainRegistry> {
    public LicensesDomainRegistryTracker(LicenseDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof LicensePack) {
            LicensePack licensePack = (LicensePack)notifier;
            switch (notification.getFeatureID(LicensePack.class)) {
                case 0: {
                    this.processLicensePackIdentifier(licensePack, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processLicensePackIdentifier(LicensePack licensePack, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((LicenseDomainRegistry)this.registry).unregisterLicensePack(oldValue);
                }
                if (newValue == null) break;
                ((LicenseDomainRegistry)this.registry).registerLicensePack((LicensePackDescriptor)licensePack);
            }
        }
    }
}

