/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.internal.transfer.bundle.OM;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransferType
implements Comparable<CDOTransferType> {
    private static final Map<String, CDOTransferType> MAP = new HashMap<String, CDOTransferType>();
    public static final CDOTransferType FOLDER = new CDOTransferType(){

        public String toString() {
            return "<Folder>";
        }
    };
    public static final CDOTransferType MODEL = new CDOTransferType(){

        public String toString() {
            return "<Model>";
        }
    };
    public static final CDOTransferType BINARY = new CDOTransferType(){

        public String toString() {
            return "<Binary>";
        }
    };
    public static final Text UTF8 = CDOTransferType.text("UTF-8");
    public static final Map<String, CDOTransferType> REGISTRY = Collections.unmodifiableMap(MAP);

    static {
        try {
            for (Charset charset : Charset.availableCharsets().values()) {
                try {
                    CDOTransferType.text(charset.toString());
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private CDOTransferType() {
        this(true);
    }

    private CDOTransferType(boolean register) {
        if (register) {
            MAP.put(this.toString(), this);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return ObjectUtil.equals((Object)this.toString(), (Object)obj.toString());
    }

    @Override
    public int compareTo(CDOTransferType o) {
        return this.toString().compareTo(o.toString());
    }

    public static Text text(String encoding) {
        CDOTransferType type = MAP.get(encoding);
        if (type instanceof Text) {
            return (Text)type;
        }
        if (type == null) {
            Text text = new Text(encoding);
            MAP.put(encoding, text);
            return text;
        }
        throw new IllegalArgumentException("Illegal encoding: " + encoding);
    }

    /* synthetic */ CDOTransferType(CDOTransferType cDOTransferType) {
        this();
    }

    /* synthetic */ CDOTransferType(boolean bl, CDOTransferType cDOTransferType) {
        this(bl);
    }

    public static final class Text
    extends CDOTransferType {
        private String encoding;

        private Text(String encoding) {
            super(false, null);
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String toString() {
            return this.encoding;
        }
    }
}

