/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers.OpaqueBehaviorViewUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;

public abstract class AbstractStateBehaviorsParser
implements ISemanticParser {
    private static final String ONE_SPACE_STRING = " ";
    private static final String EMPTY_STRING = "";

    protected abstract BehaviorType getParserType();

    public String getEditString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(Behavior.class);
        if (obj instanceof Behavior) {
            Behavior behavior = (Behavior)obj;
            return behavior.getName();
        }
        return EMPTY_STRING;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.statemachine", 0, EMPTY_STRING);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        AbstractTransactionalCommand cmd;
        final Behavior behavior = (Behavior)((EObjectAdapter)element).getRealObject();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)behavior);
        final String newStringResult = newString;
        if (editingDomain != null && editingDomain instanceof TransactionalEditingDomain && (cmd = new AbstractTransactionalCommand((TransactionalEditingDomain)editingDomain, "Set new name in " + behavior.getName(), null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                behavior.setName(newStringResult);
                return CommandResult.newOKCommandResult();
            }
        }) != null && cmd.canExecute()) {
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        View view = null;
        if (obj instanceof View) {
            view = (View)obj;
            obj = view.getElement();
        }
        if (obj instanceof Behavior) {
            OpaqueBehavior ob;
            Behavior behavior = (Behavior)obj;
            StringBuilder result = new StringBuilder();
            String keyWord = this.getParserType().getKeyWord();
            result.append(keyWord);
            this.addExtraSpace(result, keyWord);
            String body = null;
            if (behavior instanceof OpaqueBehavior && (ob = (OpaqueBehavior)obj).getBodies().size() > 0) {
                body = OpaqueBehaviorViewUtil.retrieveBody(view, ob);
            }
            if (body != null && !body.equals("...")) {
                result.append(body);
            } else {
                String kind = behavior.eClass().getName();
                result.append(kind);
                this.addExtraSpace(result, kind);
                result.append(behavior.getName());
            }
            return result.toString();
        }
        return EMPTY_STRING;
    }

    private void addExtraSpace(StringBuilder result, String keyWord) {
        if (!keyWord.endsWith(ONE_SPACE_STRING)) {
            result.append(ONE_SPACE_STRING);
        }
    }

    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        int notificationType;
        if (event instanceof Notification && (3 == (notificationType = ((Notification)event).getEventType()) || 1 == notificationType || 4 == notificationType) && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature eStrucFeature = (EStructuralFeature)feature;
            if (this.getParserType().getEStructuralFeature().equals(eStrucFeature)) {
                return true;
            }
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<Behavior> getSemanticElementsBeingParsed(EObject element) {
        if (element instanceof Behavior) {
            Behavior behavior = (Behavior)element;
            return Collections.singletonList(behavior);
        }
        return Collections.emptyList();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    public static interface BehaviorType {
        public String getKeyWord();

        public EStructuralFeature getEStructuralFeature();
    }
}

