/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.spi.server.IAppExtension2;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityExtension
implements IAppExtension2 {
    public static final String DEFAULT_REALM_PATH = "security";

    public void start(File configFile) throws Exception {
        this.start(this.getDocument(configFile));
    }

    public void startDynamic(Reader xmlConfigReader) throws Exception {
        this.start(this.getDocument(xmlConfigReader));
    }

    protected void start(Document document) throws Exception {
        OM.LOG.info("Security extension starting");
        NodeList repositoryConfigs = document.getElementsByTagName("repository");
        int i = 0;
        while (i < repositoryConfigs.getLength()) {
            Element repositoryConfig = (Element)repositoryConfigs.item(i);
            this.configureRepository(repositoryConfig);
            ++i;
        }
        OM.LOG.info("Security extension started");
    }

    public void stop() throws Exception {
        OM.LOG.info("Security extension stopping");
        OM.LOG.info("Security extension stopped");
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected Document getDocument(Reader configReader) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(configReader));
    }

    protected void configureRepository(Element repositoryConfig) {
        String name;
        IManagedContainer container = SecurityExtension.getContainer();
        InternalRepository repository = (InternalRepository)RepositoryFactory.get((IManagedContainer)container, (String)(name = repositoryConfig.getAttribute("name")));
        if (repository == null) {
            throw new IllegalStateException("Repository not registered with container: " + name);
        }
        NodeList securityManagers = repositoryConfig.getElementsByTagName("securityManager");
        if (securityManagers.getLength() > 1) {
            throw new IllegalStateException("A maximum of one security manager can be configured for repository " + repository);
        }
        if (securityManagers.getLength() == 1) {
            Element securityManagerElement = (Element)securityManagers.item(0);
            String type = securityManagerElement.getAttribute("type");
            if (type == null || type.length() == 0) {
                throw new IllegalStateException("Security manager type not specified for repository " + repository);
            }
            String description = securityManagerElement.getAttribute("description");
            if (description == null || description.length() == 0) {
                description = securityManagerElement.getAttribute("realmPath");
            }
            if (description == null || description.length() == 0) {
                description = DEFAULT_REALM_PATH;
            }
            String qualifiedDescription = String.format("%s:%s", name, description);
            container.getElement("org.eclipse.emf.cdo.server.security.managers", type, qualifiedDescription);
        }
    }

    public static IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

