/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.papyrus.customization.nattableconfiguration.helper.TableConfigurationHelper;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.AbstractAxisConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NameSimplifier;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NattableConfigurationEditingSupport;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class ColumnConfigurationWizardPage
extends AbstractAxisConfigurationWizardPage {
    protected static final List<String> requiredProposedAxisManagers = new ArrayList<String>();
    protected static final List<String> requiredProposedLabelProviderContexts = new ArrayList<String>();

    static {
        requiredProposedAxisManagers.add("EMF Feature (org.eclipse.papyrus.infra.emf.nattable.feature.axis.manager)");
        requiredProposedAxisManagers.add("EMF Operation (org.eclipse.papyrus.infra.emf.nattable.operation.axis.manager)");
        requiredProposedAxisManagers.add("UML Element (org.eclipse.papyrus.uml.nattable.element.axis.manager)");
        requiredProposedAxisManagers.add("UML Feature (org.eclipse.papyrus.uml.nattable.feature.axis.manager)");
        requiredProposedAxisManagers.add("UML Operation (org.eclipse.papyrus.uml.nattable.operation.axis.manager)");
        requiredProposedLabelProviderContexts.add("Header");
        requiredProposedLabelProviderContexts.add("Header Feature");
        requiredProposedLabelProviderContexts.add("Header Operation");
    }

    public ColumnConfigurationWizardPage(TableConfigurationHelper helper) {
        super(Messages.ColumnConfigurationWizardPage_pageName, helper);
    }

    @Override
    public TableHeaderAxisConfiguration getHeaderAxisConfiguration() {
        return this.helper.getTableConfiguration().getColumnHeaderAxisConfiguration();
    }

    @Override
    public AxisManagerRepresentation createAxisManagerRepresentation() {
        AxisManagerRepresentation createdRepresentation = super.createAxisManagerRepresentation();
        createdRepresentation.setAxisManagerId("org.eclipse.papyrus.uml.nattable.element.axis.manager");
        this.manageLabelProviderConfiguration(createdRepresentation);
        this.manageCorrespondenceAxisManagerAndContext(createdRepresentation);
        return createdRepresentation;
    }

    @Override
    protected void createAxisManagersColumns(final TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        final Set knownAxis = AxisManagerFactory.INSTANCE.getAllRegisteredAxisManager().keySet();
        int[] bounds = new int[]{500, 500};
        String[] titles = new String[]{Messages.ConfigurationWizardPage_axisManagerIdColumnName, Messages.ConfigurationWizardPage_labelProviderContextColumnName};
        TableViewerColumn axisManagerIdColumn = this.createTableViewerColumn(tableViewer, titles[0], bounds[0]);
        ColumnLabelProvider axisManagerIdLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder value = new StringBuilder();
                if (element instanceof AxisManagerRepresentation) {
                    String axisManagerId = ((AxisManagerRepresentation)element).getAxisManagerId();
                    boolean existSimpleName = NameSimplifier.axisManagerNames.containsKey(axisManagerId);
                    if (existSimpleName) {
                        value.append(NameSimplifier.axisManagerNames.get(axisManagerId));
                        value.append(" (");
                    }
                    value.append(axisManagerId);
                    if (existSimpleName) {
                        value.append(")");
                    }
                }
                return value.toString();
            }
        };
        axisManagerIdColumn.setLabelProvider((CellLabelProvider)axisManagerIdLabelProvider);
        axisManagerIdColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)axisManagerIdLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof AxisManagerRepresentation) {
                    if (NameSimplifier.axisManagerNames.containsValue(value)) {
                        for (Map.Entry<String, String> entry : NameSimplifier.axisManagerNames.entrySet()) {
                            if (!((String)value).contains(entry.getValue()) || !((String)value).contains(entry.getKey())) continue;
                            ((AxisManagerRepresentation)element).setAxisManagerId(entry.getKey());
                        }
                    } else {
                        ((AxisManagerRepresentation)element).setAxisManagerId((String)value);
                    }
                    ColumnConfigurationWizardPage.this.manageLabelProviderConfiguration((AxisManagerRepresentation)element);
                    ColumnConfigurationWizardPage.this.manageCorrespondenceAxisManagerAndContext((AxisManagerRepresentation)element);
                    tableViewer.refresh();
                    ColumnConfigurationWizardPage.this.setPageComplete(ColumnConfigurationWizardPage.this.isPageComplete());
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)table, ColumnConfigurationWizardPage.this.createAxisManagerIdItems(requiredProposedAxisManagers, knownAxis), (ILabelProvider)new LabelProvider(), 0){

                    public Object doGetValue() {
                        if (this.getControl() instanceof CCombo) {
                            return ((CCombo)this.getControl()).getText();
                        }
                        return super.doGetValue();
                    }
                };
            }
        });
        TableViewerColumn labelProviderContextColumn = this.createTableViewerColumn(tableViewer, titles[1], bounds[1]);
        ColumnLabelProvider labelProviderContextLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof AxisManagerRepresentation) {
                    result = NameSimplifier.labelProviderContextNames.containsKey(((AxisManagerRepresentation)element).getLabelProviderContext()) ? NameSimplifier.labelProviderContextNames.get(((AxisManagerRepresentation)element).getLabelProviderContext()) : ((AxisManagerRepresentation)element).getLabelProviderContext();
                }
                return result;
            }
        };
        labelProviderContextColumn.setLabelProvider((CellLabelProvider)labelProviderContextLabelProvider);
        labelProviderContextColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)labelProviderContextLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof AxisManagerRepresentation && NameSimplifier.labelProviderContextNames.containsValue(value)) {
                    for (Map.Entry<String, String> entry : NameSimplifier.labelProviderContextNames.entrySet()) {
                        if (!entry.getValue().equals(value)) continue;
                        ((AxisManagerRepresentation)element).setLabelProviderContext(entry.getKey());
                    }
                    tableViewer.refresh();
                    ColumnConfigurationWizardPage.this.setPageComplete(ColumnConfigurationWizardPage.this.isPageComplete());
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)table, requiredProposedLabelProviderContexts, (ILabelProvider)new LabelProvider(), 0);
            }
        });
    }

    protected void manageCorrespondenceAxisManagerAndContext(AxisManagerRepresentation element) {
        if (NameSimplifier.correspondenceAxisManagerAndContext.containsKey(element.getAxisManagerId())) {
            element.setLabelProviderContext(NameSimplifier.correspondenceAxisManagerAndContext.get(element.getAxisManagerId()));
        }
    }
}

