/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.views;

import java.util.List;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.dawn.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.ui.helper.EditorDescriptionHelper;
import org.eclipse.emf.cdo.dawn.ui.views.DawnItemProvider;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DawnExplorer
extends CDOSessionsView {
    private static final String OPENCERT_REPO = "cdo://opencert";
    private static final String EXTENSION_DIAGRAM = "_diagram";
    private static final String PLEASE_DELETE_MANUALLY_THE_DIAGRAMS = "";
    private static final String DELETE_MODEL = "DELETE Model";
    private static final String DELETE_FOLDER = "DELETE Folder";
    private static final String PROBLEM_DELETING_THE_MODEL = "Problem deleting the model";
    private static final String PROBLEM_DELETING_THE_FOLDER = "Problem deleting the folder";
    private static final int DEFAULT_SLEEP_INTERVAL = 5000;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnExplorer.class);
    public static final String ID = "org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer";
    private CDOView view;
    private CDOResource selectedModel;
    private CDOResourceFolder selectedFolder;
    private String messageAboutDiagrams = "Please Delete Manually the diagrams:\n";
    private boolean hasDiagrams = false;

    public CDOView getView() {
        return this.view;
    }

    public DawnExplorer() {
        boolean initialize = this.initialize();
        if (!initialize) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DawnExplorer.this.initialize()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            thread.start();
        }
    }

    private boolean initialize() {
        try {
            CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
            CDOSession session = CDOConnectionUtil.instance.openSession();
            this.view = CDOConnectionUtil.instance.openView(session);
        }
        catch (ConnectorException ex) {
            return false;
        }
        return true;
    }

    public void dispose() {
        this.view.close();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new DawnItemProvider(this.getSite().getPage(), this, new IElementFilter(){

            public boolean filter(Object element) {
                return element instanceof CDOSession;
            }
        });
    }

    protected void hookDoubleClick() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (obj instanceof CDOResource) {
                    String editorID;
                    CDOResource resource = (CDOResource)obj;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Opening CDOResource {0} ", new Object[]{resource});
                    }
                    if ((editorID = EditorDescriptionHelper.getEditorIdForDawnEditor(resource.getName())) != null && !editorID.equals(DawnExplorer.PLEASE_DELETE_MANUALLY_THE_DIAGRAMS)) {
                        try {
                            DawnEditorInput editorInput = new DawnEditorInput(resource.getURI());
                            DawnExplorer.this.getSite().getPage().openEditor((IEditorInput)editorInput, editorID);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    } else {
                        CDOTransaction transaction = DawnExplorer.this.view.getSession().openTransaction();
                        CDOEditorInput editorInput = CDOEditorUtil.createCDOEditorInput((CDOView)transaction, (String)((CDOResource)obj).getPath(), (boolean)true);
                        try {
                            DawnExplorer.this.getSite().getPage().openEditor((IEditorInput)editorInput, CDOEditorUtil.getEditorID());
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private boolean deleteModel() {
        try {
            IEditorReference[] edi;
            IEditorReference[] iEditorReferenceArray = edi = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = edi.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                IEditorInput input = editor.getEditorInput();
                if (input != null) {
                    String path = PLEASE_DELETE_MANUALLY_THE_DIAGRAMS;
                    if ((input instanceof DawnEditorInput || input instanceof URIEditorInput) && (path = input instanceof DawnEditorInput ? ((DawnEditorInput)input).getURI().toString() : ((URIEditorInput)input).getURI().toString()).equals(OPENCERT_REPO + this.selectedModel.getPath())) {
                        IEditorReference[] editorReferencesClose = new IEditorReference[]{editor};
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editorReferencesClose, false);
                        break;
                    }
                }
                ++n2;
            }
            CDOTransaction transaction = this.view.getSession().openTransaction();
            CDOResource modelToDelete = transaction.getResource(this.selectedModel.getPath());
            if (!modelToDelete.getPath().contains(EXTENSION_DIAGRAM)) {
                for (EObject aEObject : modelToDelete.getContents()) {
                    List rc = transaction.queryXRefs(CDOUtil.getCDOObject((EObject)aEObject), new EReference[0]);
                    for (CDOObjectReference oneRef : rc) {
                        EcoreUtil.remove((EObject)((EObject)oneRef.getSourceObject()), (EStructuralFeature)oneRef.getSourceFeature(), (Object)oneRef.getTargetObject());
                    }
                    if (aEObject.eContents().size() == 0) continue;
                    this.deleteSubContents(aEObject, transaction);
                }
                modelToDelete.save(null);
            }
            modelToDelete.delete(null);
            transaction.commit();
            transaction.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage("Problem deleting the model cdo://opencert" + this.selectedModel.getPath());
            return false;
        }
    }

    private void deleteSubContents(EObject aEObject, CDOTransaction transaction) {
        try {
            while (aEObject.eContents().size() > 0) {
                EObject bEObject = (EObject)aEObject.eContents().get(0);
                List rc = transaction.queryXRefs(CDOUtil.getCDOObject((EObject)bEObject), new EReference[0]);
                for (CDOObjectReference oneRef : rc) {
                    EcoreUtil.remove((EObject)((EObject)oneRef.getSourceObject()), (EStructuralFeature)oneRef.getSourceFeature(), (Object)oneRef.getTargetObject());
                }
                if (bEObject.eContents().size() != 0) {
                    this.deleteSubContents(bEObject, transaction);
                }
                EcoreUtil.delete((EObject)bEObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

