/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.propertytab;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.ConstraintBlockEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ComponentEditPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.contracts.profile.chesscontract.Contract;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class BlockEditPartSection
extends AbstractPropertySection {
    public static final String CONTRACT = "CHESSContract::Contract";
    public static final String CONTRACT_PROP = "CHESSContract::ContractProperty";
    private Text contractText;
    private Text assumeText;
    private Text guaranteeText;
    private Class contract;
    private Class selectedClass;
    private FocusListener assumeFocusListener;
    private FocusListener guaranteeFocusListener;
    private SelectionListener contractListListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String selection = BlockEditPartSection.this.contractList.getItem(BlockEditPartSection.this.contractList.getSelectionIndex());
            BlockEditPartSection.this.contract = BlockEditPartSection.this.getContract(BlockEditPartSection.this.selectedClass, selection);
            if (BlockEditPartSection.this.contract != null) {
                BlockEditPartSection.this.setContractPropertyTab(BlockEditPartSection.this.contract);
            }
            BlockEditPartSection.this.contractLabel.setText("Selected Class");
            BlockEditPartSection.this.contractText.setText(BlockEditPartSection.this.selectedClass.getQualifiedName());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private Label contractLabel;
    private CCombo contractList;
    private Label contractListLabel;

    public BlockEditPartSection() {
        this.assumeFocusListener = new FocusListener(){
            private String oldAssume;

            public void focusLost(FocusEvent e) {
                if (BlockEditPartSection.this.assumeText.getText().equals(this.oldAssume)) {
                    return;
                }
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor != null) {
                    TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)editor.getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            Stereotype stereo = BlockEditPartSection.this.contract.getAppliedStereotype(BlockEditPartSection.CONTRACT);
                            FormalProperty assumefp = (FormalProperty)BlockEditPartSection.this.contract.getValue(stereo, "Assume");
                            Constraint assumeConstr = assumefp.getBase_Constraint();
                            LiteralString assumeSpec = (LiteralString)assumeConstr.getSpecification();
                            assumeSpec.setValue(BlockEditPartSection.this.assumeText.getText());
                            assumeConstr.setSpecification((ValueSpecification)assumeSpec);
                        }
                    });
                }
            }

            public void focusGained(FocusEvent e) {
                this.oldAssume = BlockEditPartSection.this.assumeText.getText();
            }
        };
        this.guaranteeFocusListener = new FocusListener(){
            private String oldGuarantee;

            public void focusLost(FocusEvent e) {
                if (BlockEditPartSection.this.assumeText.getText().equals(this.oldGuarantee)) {
                    return;
                }
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor != null) {
                    TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)editor.getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            Stereotype stereo = BlockEditPartSection.this.contract.getAppliedStereotype(BlockEditPartSection.CONTRACT);
                            FormalProperty guaranteefp = (FormalProperty)BlockEditPartSection.this.contract.getValue(stereo, "Guarantee");
                            Constraint guaranteeConstr = guaranteefp.getBase_Constraint();
                            LiteralString guaranteeSpec = (LiteralString)guaranteeConstr.getSpecification();
                            guaranteeSpec.setValue(BlockEditPartSection.this.guaranteeText.getText());
                            guaranteeConstr.setSpecification((ValueSpecification)guaranteeSpec);
                        }
                    });
                }
            }

            public void focusGained(FocusEvent e) {
                this.oldGuarantee = BlockEditPartSection.this.guaranteeText.getText();
            }
        };
    }

    private Class getContract(Class selectedClass, String selection) {
        String[] splitted = selection.split(":");
        String propName = splitted[0].trim();
        EList attributes = selectedClass.getAttributes();
        Iterator it = attributes.iterator();
        Property property = null;
        boolean found = false;
        while (it.hasNext() && !found) {
            Property attr = (Property)it.next();
            if (!attr.getName().equals(propName) || attr.getAppliedStereotype(CONTRACT_PROP) == null) continue;
            found = true;
            property = attr;
        }
        if (property == null) {
            return null;
        }
        Class contract = (Class)property.getType();
        return contract;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.contractText = this.getWidgetFactory().createText(composite, "no Contract selected");
        this.contractText.setEditable(false);
        this.contractText.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        this.contractLabel = this.getWidgetFactory().createLabel(composite, "Selected Contract", 0);
        this.contractLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        this.contractList = this.getWidgetFactory().createCCombo(composite, 2056);
        this.contractList.setVisible(false);
        gd.horizontalSpan = 3;
        this.contractList.addSelectionListener(this.contractListListener);
        this.contractList.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        this.contractListLabel = this.getWidgetFactory().createLabel(composite, "Contract List", 0);
        this.contractListLabel.setVisible(false);
        this.contractListLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        Label assumeLabel = this.getWidgetFactory().createLabel(composite, "Assume", 0);
        assumeLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        Label guaranteeLabel = this.getWidgetFactory().createLabel(composite, "Guarantee", 0);
        guaranteeLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.assumeText = this.getWidgetFactory().createText(composite, "", 770);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 25;
        this.assumeText.addFocusListener(this.assumeFocusListener);
        this.assumeText.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.guaranteeText = this.getWidgetFactory().createText(composite, "", 770);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 25;
        this.guaranteeText.addFocusListener(this.guaranteeFocusListener);
        this.guaranteeText.setLayoutData((Object)gd);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Stereotype stereo;
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            this.cleanPropertyTab();
            return;
        }
        List selectionList = ((IStructuredSelection)selection).toList();
        if (selectionList.size() == 1) {
            Object selected = selectionList.get(0);
            EObject selectedEObject = EMFHelper.getEObject(selected);
            if (selected instanceof ConstraintBlockEditPart) {
                Class clazz = (Class)((ConstraintBlockEditPart)selected).resolveSemanticElement();
                if (clazz.getAppliedStereotype(CONTRACT) != null) {
                    this.cleanPropertyTab();
                    this.setContractPropertyTab(clazz);
                }
            } else if (selected instanceof BlockEditPart) {
                Class clazz = (Class)((BlockEditPart)selected).resolveSemanticElement();
                this.initContractList(clazz);
            } else if (selected instanceof ClassEditPart) {
                Class clazz = (Class)((ClassEditPart)selected).resolveSemanticElement();
                if (clazz.getAppliedStereotype(CONTRACT) != null) {
                    this.cleanPropertyTab();
                    this.setContractPropertyTab(clazz);
                } else {
                    this.initContractList(clazz);
                }
            } else if (selected instanceof ComponentEditPart) {
                Class clazz = (Class)((ComponentEditPart)selected).resolveSemanticElement();
                this.initContractList(clazz);
            } else if (selectedEObject instanceof Class) {
                Class clazz = (Class)selectedEObject;
                if (clazz.getAppliedStereotype(CONTRACT) != null) {
                    this.cleanPropertyTab();
                    this.setContractPropertyTab(clazz);
                } else {
                    this.initContractList(clazz);
                }
            } else {
                this.cleanPropertyTab();
            }
        } else {
            this.cleanPropertyTab();
        }
        if (this.contract != null) {
            stereo = this.contract.getAppliedStereotype(CONTRACT);
            Contract cfr_ignored_0 = (Contract)this.contract.getStereotypeApplication(stereo);
        }
        if (this.contract != null) {
            stereo = this.contract.getAppliedStereotype(CONTRACT);
            Contract cfr_ignored_1 = (Contract)this.contract.getStereotypeApplication(stereo);
        }
    }

    private void initContractList(Class clazz) {
        this.cleanPropertyTab();
        this.selectedClass = clazz;
        this.contractText.setText(this.selectedClass.getQualifiedName());
        this.contractLabel.setText("Selected Class");
        this.contractList.setVisible(true);
        this.contractListLabel.setVisible(true);
        for (Property prop : this.selectedClass.getAttributes()) {
            if (prop.getAppliedStereotype(CONTRACT_PROP) == null) continue;
            if (prop.getType() == null) {
                this.contractList.add(String.valueOf(prop.getName()) + " : <TYPE NOT DEFINED>");
                continue;
            }
            this.contractList.add(String.valueOf(prop.getName()) + " : " + prop.getType().getName());
        }
    }

    private void setContractPropertyTab(Class clazz) {
        this.contract = clazz;
        this.contractLabel.setText("Selected Contract");
        this.contractText.setText(clazz.getQualifiedName());
        Stereotype contrStereo = clazz.getAppliedStereotype(CONTRACT);
        FormalProperty assumefp = (FormalProperty)clazz.getValue(contrStereo, "Assume");
        FormalProperty guaranteefp = (FormalProperty)clazz.getValue(contrStereo, "Guarantee");
        String assume = "";
        if (assumefp != null) {
            assume = assumefp.getBase_Constraint().getSpecification().stringValue();
        }
        String guarantee = "";
        if (guaranteefp != null) {
            guarantee = guaranteefp.getBase_Constraint().getSpecification().stringValue();
        }
        if (assume != null) {
            this.assumeText.setText(assume);
        }
        if (guarantee != null) {
            this.guaranteeText.setText(guarantee);
        }
        Contract cfr_ignored_0 = (Contract)this.contract.getStereotypeApplication(contrStereo);
    }

    private void cleanPropertyTab() {
        this.contractLabel.setText("Selected Contract");
        this.contractText.setText("no Contract selected");
        this.assumeText.setText("");
        this.guaranteeText.setText("");
        this.contract = null;
        this.contractList.removeAll();
        this.contractList.setVisible(false);
        this.contractListLabel.setVisible(false);
    }
}

