/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy.CanonicalStateListener;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SetCanonicalCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public class CanonicalObservableValue
extends ReferenceCountedObservable.Value
implements CommandBasedObservableValue,
AggregatedObservable,
IObserving {
    private TransactionalEditingDomain domain;
    private EditPart editPart;
    private boolean lastComputed;
    private CanonicalStateListener canonicalStateListener;
    private CanonicalStateListener.Handler refreshHandler;

    public CanonicalObservableValue(TransactionalEditingDomain domain, EditPart editPart) {
        this.domain = domain;
        this.editPart = editPart;
        final Runnable update = new Runnable(){

            @Override
            public void run() {
                boolean oldValue = CanonicalObservableValue.this.lastComputed;
                CanonicalObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)CanonicalObservableValue.this.doGetValue()));
            }
        };
        if (editPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphical = (IGraphicalEditPart)editPart;
            this.canonicalStateListener = CanonicalStateListener.getInstance((IGraphicalEditPart)graphical);
            this.refreshHandler = new CanonicalStateListener.Handler(){

                public Runnable handleAdd(CanonicalStyle style) {
                    return update;
                }

                public Runnable handleRemove(CanonicalStyle style) {
                    return update;
                }
            };
            this.canonicalStateListener.addCanonicalRefreshHandler(this.refreshHandler);
        }
    }

    public synchronized void dispose() {
        try {
            if (this.canonicalStateListener != null) {
                this.canonicalStateListener.removeCanonicalRefreshHandler(this.refreshHandler);
                this.canonicalStateListener.release();
                this.canonicalStateListener = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public Object getObserved() {
        return this.editPart;
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected Object doGetValue() {
        boolean result;
        this.lastComputed = result = DiagramEditPartsUtil.isCanonical((EditPart)this.editPart);
        return result;
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public Command getCommand(Object value) {
        boolean canonical = value instanceof Boolean && (Boolean)value != false;
        return GMFtoEMFCommandWrapper.wrap((ICommand)new SetCanonicalCommand(this.domain, NotationHelper.findView((Object)this.editPart), canonical));
    }

    public AggregatedObservable aggregate(IObservable observable) {
        return new AggregatedPapyrusObservableValue((EditingDomain)this.domain, new IObservable[]{this, observable});
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

