/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.service.datalocation.Location;

class FileUtil {
    FileUtil() {
    }

    public static List<EObject> fetch(String extension) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List<IFile> files = FileUtil.findInWorkspace(extension);
        for (IFile file : files) {
            List<EObject> fileContent = FileUtil.loadResource(file);
            result.addAll(fileContent);
        }
        return result;
    }

    private static List<IFile> findInWorkspace(String extension) {
        ArrayList<IFile> dictFiles = new ArrayList<IFile>();
        Location workspaceLocation = Platform.getInstanceLocation();
        if (workspaceLocation.isSet()) {
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            try {
                FileUtil.findFiles(dictFiles, (IResource)workspace, extension);
            }
            catch (CoreException e) {
                System.out.println((Object)e);
            }
        }
        return dictFiles;
    }

    private static void findFiles(List<IFile> files, IResource f, String fileType) throws CoreException {
        if (f instanceof IFile) {
            if (f.getFileExtension().toLowerCase().equals(fileType.toLowerCase())) {
                files.add((IFile)f);
            }
        } else if (f instanceof IContainer) {
            IResource[] iResourceArray = ((IContainer)f).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                FileUtil.findFiles(files, child, fileType);
                ++n2;
            }
        }
    }

    private static List<EObject> loadResource(IFile file) {
        EList result = null;
        String path = file.getLocation().toString();
        XMIResourceImpl resource = new XMIResourceImpl();
        File source = new File(path);
        try {
            resource.load((InputStream)new FileInputStream(source), new HashMap());
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        result = resource.getContents();
        return result;
    }
}

