/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.actions.NextDiagramAction;
import org.eclipse.emf.ecoretools.diagram.edit.actions.PreviousDiagramAction;
import org.eclipse.emf.ecoretools.diagram.edit.actions.UpDiagramAction;
import org.eclipse.emf.ecoretools.diagram.navigator.EcoreNavigatorItem;
import org.eclipse.emf.ecoretools.diagram.outline.EcoreDiagramOutlinePage;
import org.eclipse.emf.ecoretools.diagram.part.DiagramEditorContextMenuProvider;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcorePaletteFactory;
import org.eclipse.emf.ecoretools.diagram.part.NavigationManager;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EcoreDiagramEditor
extends DiagramDocumentEditor
implements IGotoMarker {
    private NavigationManager navigation = new NavigationManager(this);
    public static final String ID = "org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID";
    public static final String CONTEXT_ID = "org.eclipse.emf.ecoretools.diagram.ui.diagramContext";
    private IUndoContext localUndoContext;

    protected void setPartName(String partName) {
        String title = null;
        if (this.getDiagram() != null) {
            title = this.getDiagram().getName();
        }
        if (title != null && !title.equals("")) {
            super.setPartName(title);
        } else {
            super.setPartName(partName);
        }
    }

    public EcoreDiagramEditor() {
        super(true);
    }

    protected String getContextID() {
        return CONTEXT_ID;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot root = super.createPaletteRoot(existingPaletteRoot);
        new EcorePaletteFactory().fillPalette(root);
        return root;
    }

    protected PreferencesHint getPreferencesHint() {
        return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "org.eclipse.emf.ecoretools.diagram";
    }

    public Object getAdapter(Class type) {
        if (type == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
                }
            };
        }
        if (type == IContentOutlinePage.class) {
            return new EcoreDiagramOutlinePage((DiagramEditor)this);
        }
        return super.getAdapter(type);
    }

    protected IDocumentProvider getDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            return EcoreDiagramEditorPlugin.getInstance().getDocumentProvider();
        }
        return super.getDocumentProvider(input);
    }

    public TransactionalEditingDomain getEditingDomain() {
        IDocument document;
        IDocument iDocument = document = this.getEditorInput() != null ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()) : null;
        if (document instanceof IDiagramDocument) {
            return ((IDiagramDocument)document).getEditingDomain();
        }
        return super.getEditingDomain();
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            this.setDocumentProvider((IDocumentProvider)EcoreDiagramEditorPlugin.getInstance().getDocumentProvider());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block19: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = NLS.bind((String)org.eclipse.emf.ecoretools.diagram.part.Messages.EcoreDiagramEditor_SavingDeletedFile, (Object)original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)org.eclipse.emf.ecoretools.diagram.part.Messages.EcoreDiagramEditor_SaveAsErrorTitle, (String)org.eclipse.emf.ecoretools.diagram.part.Messages.EcoreDiagramEditor_SaveAsErrorMessage);
                    return;
                }
                ++i;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    this.getDocumentProvider((IEditorInput)newInput).saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)org.eclipse.emf.ecoretools.diagram.part.Messages.EcoreDiagramEditor_SaveErrorTitle, (String)org.eclipse.emf.ecoretools.diagram.part.Messages.EcoreDiagramEditor_SaveErrorMessage, (IStatus)x.getStatus());
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), this.getNavigatorSelection());
    }

    private ISelection getNavigatorSelection() {
        IDiagramDocument document = this.getDiagramDocument();
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            EcoreNavigatorItem item = new EcoreNavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        DiagramEditorContextMenuProvider provider = new DiagramEditorContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        this.getDiagramGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.getDiagramGraphicalViewer());
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer()){

            protected Object getJavaObject(TransferData data) {
                return LocalSelectionTransfer.getTransfer().nativeToJava(data);
            }
        });
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalTransfer.getInstance()){

            protected Object getJavaObject(TransferData data) {
                return LocalTransfer.getInstance().nativeToJava(data);
            }
        });
    }

    protected boolean shouldAddUndoContext(IUndoableOperation operation) {
        if (operation instanceof EMFCommandOperation) {
            return true;
        }
        return operation.getLabel() != null && (operation.getLabel().equals("Copy") || operation.getLabel().equals("Cut") || operation.getLabel().equals("Paste"));
    }

    protected IUndoContext getUndoContext() {
        if (this.localUndoContext == null) {
            this.localUndoContext = new ObjectUndoContext((Object)this);
            this.setUndoContext(this.localUndoContext);
            this.getOperationHistory().setLimit(this.localUndoContext, 50);
        }
        return this.localUndoContext;
    }

    protected void initializeGraphicalViewerContents() {
        this.getGraphicalViewer().setProperty("Appearance.fillFigureUsingGradient", (Object)EcoreDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("Appearance.fillFigureUsingGradient"));
        this.getGraphicalViewer().setProperty("Appearance.useShadowOnBorder", (Object)EcoreDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("Appearance.useShadowOnBorder"));
        super.initializeGraphicalViewerContents();
    }

    protected int getInitialDockLocation() {
        return 8;
    }

    public NavigationManager getNavigationManager() {
        return this.navigation;
    }

    public void setDiagram(final Diagram diagram) {
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    EcoreDiagramEditor.this.navigation.set(diagram);
                }
            });
        } else {
            this.navigation.set(diagram);
        }
    }

    void changeActiveDiagram(Diagram diagram) {
        IDocument document;
        IEditorInput oldInput = this.getEditorInput();
        this.clearGraphicalViewerContents();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null || !(provider instanceof IDiagramDocumentProvider)) {
            EcoreDiagramEditorPlugin.getInstance().logError(Messages.EcoreDiagramEditor_NoDocumentProviders);
        }
        if (!((document = provider.getDocument((Object)oldInput)) instanceof DiagramDocument)) {
            EcoreDiagramEditorPlugin.getInstance().logError(Messages.EcoreDiagramEditor_NoDiagramDocument);
        }
        ((DiagramDocument)document).setContent((Object)diagram);
        this.initializeGraphicalViewerContents();
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        WorkbenchPartAction action = new PreviousDiagramAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new UpDiagramAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new NextDiagramAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    protected void configureDiagramEditDomain() {
        DiagramEditDomain editDomain = (DiagramEditDomain)this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            DiagramCommandStack diagramStack = new DiagramCommandStack(this.getDiagramEditDomain()){

                protected void execute(ICommand command, IProgressMonitor progressMonitor) {
                    if (command != null) {
                        for (Object object : command.getAffectedFiles()) {
                            if (!"xcore".equals(((IFile)object).getFileExtension())) continue;
                            return;
                        }
                    }
                    super.execute(command, progressMonitor);
                }
            };
            diagramStack.setOperationHistory(this.getOperationHistory());
            diagramStack.setUndoContext(this.getUndoContext());
            editDomain.setCommandStack((CommandStack)diagramStack);
            editDomain.setActionManager(this.createActionManager());
        }
    }

    private abstract class DropTargetListener
    extends DiagramDropTargetListener {
        public DropTargetListener(EditPartViewer viewer, Transfer xfer) {
            super(viewer, xfer);
        }

        protected List getObjectsBeingDropped() {
            TransferData data = this.getCurrentEvent().currentDataType;
            HashSet<URI> uris = new HashSet<URI>();
            Object transferedObject = this.getJavaObject(data);
            if (transferedObject instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)transferedObject;
                for (Object nextSelectedObject : selection) {
                    if (nextSelectedObject instanceof EcoreNavigatorItem) {
                        View view = ((EcoreNavigatorItem)((Object)nextSelectedObject)).getView();
                        nextSelectedObject = view.getElement();
                    } else if (nextSelectedObject instanceof IAdaptable) {
                        IAdaptable adaptable = (IAdaptable)nextSelectedObject;
                        nextSelectedObject = adaptable.getAdapter(EObject.class);
                    }
                    if (!(nextSelectedObject instanceof EObject)) continue;
                    EObject modelElement = (EObject)nextSelectedObject;
                    Resource modelElementResource = modelElement.eResource();
                    uris.add(modelElementResource.getURI().appendFragment(modelElementResource.getURIFragment(modelElement)));
                }
            }
            ArrayList<EObject> result = new ArrayList<EObject>();
            for (URI nextURI : uris) {
                EObject modelObject = EcoreDiagramEditor.this.getEditingDomain().getResourceSet().getEObject(nextURI, true);
                result.add(modelObject);
            }
            return result;
        }

        protected abstract Object getJavaObject(TransferData var1);
    }
}

