/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.excel.ExcelExporter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.papyrus.infra.nattable.Activator;

public class PapyrusExcelExporter
extends ExcelExporter {
    private static final String EXCEL_HEADER_FILE = "papyrusExcelExportHeader.txt";

    public PapyrusExcelExporter() {
        this((IOutputStreamProvider)new FileOutputStreamProvider("table_export.xls", new String[]{"Excel Workbok (*.xls)"}, new String[]{"*.xls"}));
    }

    public PapyrusExcelExporter(IOutputStreamProvider outputStreamProvider) {
        super(outputStreamProvider);
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        this.writeHeader(outputStream);
        outputStream.write(this.asBytes("<body><table border='1'>"));
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        InputStream headerStream = null;
        try {
            try {
                int c;
                headerStream = ((Object)((Object)this)).getClass().getResourceAsStream(EXCEL_HEADER_FILE);
                while ((c = headerStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (ObjectUtils.isNotNull((Object)headerStream)) {
                    headerStream.close();
                }
            }
        }
        finally {
            if (ObjectUtils.isNotNull((Object)headerStream)) {
                headerStream.close();
            }
        }
    }

    private byte[] asBytes(String string) {
        return string.getBytes();
    }
}

