/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.eef.runtime.ui.notify.OpenWizardOnDoubleClick;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceAsset;
import org.eclipse.opencert.apm.baseline.baseline.BaseActivity;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefact;
import org.eclipse.opencert.apm.baseline.baseline.BaseAssurableElement;
import org.eclipse.opencert.apm.baseline.baseline.BaseComplianceMap;
import org.eclipse.opencert.apm.baseline.baseline.BaseFramework;
import org.eclipse.opencert.apm.baseline.baseline.BaseRequirement;
import org.eclipse.opencert.apm.baseline.baseline.BaseRole;
import org.eclipse.opencert.apm.baseline.baseline.BaseTechnique;
import org.eclipse.opencert.apm.baseline.baseline.util.ModelStorage;
import org.eclipse.opencert.apm.baseline.baseline.utils.MappingSet;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.infra.mappings.mapping.MapKind;
import org.eclipse.opencert.infra.mappings.mapping.MapModel;
import org.eclipse.opencert.pkm.refframework.refframework.provider.RefframeworkEditPlugin;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ComplianceTable
extends Dialog {
    private static final String ClassDiagram = "org.eclipse.opencert.apm.baseline.baseline.diagram.part.DawnBaselineDiagramEditor";
    protected IEditorPart editor;
    protected URI resourceURI;
    private CDOView viewCDO = null;
    private CDOTransaction transaction = null;
    private CDOSession sessionCDO = null;
    private CDOResource resourceFrom = null;
    protected Table tableHistory;
    protected ListViewer targetsList;
    protected Combo refList;
    protected ArrayList<String> refListDirMap;
    protected Combo cbMapGroup;
    String sElementFilter;
    protected Combo cbFilterElementMap;
    protected Button btnGap;
    protected Button btnFull;
    protected Button btnPartial;
    protected Button btnNoMap;
    protected Button btnSearch;
    protected String qref;
    protected BaseFramework baseFrameworkFrom;
    protected Color green;
    protected Color orange;
    protected Color red;

    public ComplianceTable(Shell parentShell) {
        super(parentShell);
        this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.editor.getClass().getName().contentEquals(ClassDiagram)) {
            ModelStorage ms = ModelStorage.getInstance();
            this.resourceURI = ms.getResourceURI();
        } else {
            this.resourceURI = EditUIUtil.getURI((IEditorInput)this.editor.getEditorInput());
        }
        System.out.println("MODELO _usar: " + this.resourceURI.toString());
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        this.sessionCDO = CDOConnectionUtil.instance.openSession();
        this.viewCDO = CDOConnectionUtil.instance.openView(this.sessionCDO);
        this.transaction = this.sessionCDO.openTransaction();
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public ComplianceTable(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
    }

    protected Control createDialogArea(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 2;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.heightHint = 600;
        this.createSearchArea(contents);
        this.createComplianceTable(contents, adapterFactory);
        this.CreateTableContents(this.baseFrameworkFrom);
        return contents;
    }

    protected void createSearchArea(Composite contents) {
        Composite controlMapping = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalAlignment = 0x1000008;
        controlMapping.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        data.horizontalSpan = 2;
        controlMapping.setLayout((Layout)layout);
        Group groupFilter = new Group(controlMapping, 0);
        groupFilter.setLayoutData((Object)new GridData(4, 0, true, true));
        groupFilter.setText("Filtering");
        groupFilter.setLayout((Layout)new RowLayout(256));
        Label mapping = new Label((Composite)groupFilter, 0);
        mapping.setText("Map Model: ");
        this.refList = new Combo((Composite)groupFilter, 8);
        this.refListDirMap = new ArrayList();
        String path = "";
        int i = 0;
        while (i < this.resourceURI.segmentCount()) {
            path = String.valueOf(path) + this.resourceURI.segment(i) + "/";
            ++i;
        }
        path = path.substring(0, path.length() - 1);
        try {
            this.resourceFrom = this.transaction.getResource(path);
        }
        catch (CDOException e) {
            e.printStackTrace();
        }
        this.baseFrameworkFrom = (BaseFramework)this.resourceFrom.getContents().get(0);
        CDOResourceFolder assuranceprojectFolder = this.resourceFrom.getFolder();
        EList lstResourceNodes = assuranceprojectFolder.getNodes();
        Iterator resourceNode = lstResourceNodes.iterator();
        String sName = "";
        this.refList.add("All");
        this.refList.select(0);
        while (resourceNode.hasNext()) {
            CDOResourceNode node = (CDOResourceNode)resourceNode.next();
            sName = node.getName();
            System.out.println(sName);
            if (!sName.endsWith(".mapping")) continue;
            this.refList.add(sName);
            this.refListDirMap.add(node.getPath());
        }
        this.qref = "";
        this.refList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComplianceTable.this.refList.getSelectionIndex() != 0) {
                    ComplianceTable.this.qref = ComplianceTable.this.refListDirMap.get(ComplianceTable.this.refList.getSelectionIndex() - 1).toString();
                    String pathModelMapping = String.valueOf(ComplianceTable.this.resourceURI.segment(0)) + "/" + ComplianceTable.this.resourceURI.segment(1) + "/" + ComplianceTable.this.refList.getItems()[ComplianceTable.this.refList.getSelectionIndex()];
                    CDOResource resourceMapModel = ComplianceTable.this.transaction.getResource(pathModelMapping);
                    MapModel mapModel = (MapModel)resourceMapModel.getContents().get(0);
                    ComplianceTable.this.CreateModelFromFiletocombo(ComplianceTable.this.cbMapGroup, mapModel);
                } else {
                    ComplianceTable.this.qref = "";
                    ComplianceTable.this.cbMapGroup.removeAll();
                }
            }
        });
        Label mapLabel = new Label((Composite)groupFilter, 0);
        mapLabel.setText("   Map Group: ");
        this.cbMapGroup = new Combo((Composite)groupFilter, 8);
        Label filtermapLabel = new Label((Composite)groupFilter, 0);
        filtermapLabel.setText("   Filter Map Element: ");
        this.cbFilterElementMap = new Combo((Composite)groupFilter, 8);
        this.cbFilterElementMap.add("All");
        this.cbFilterElementMap.add("Activity");
        this.cbFilterElementMap.add("Artefact");
        this.cbFilterElementMap.add("Requirement");
        this.cbFilterElementMap.add("Technique");
        this.cbFilterElementMap.add("Role");
        this.cbFilterElementMap.select(0);
        this.cbFilterElementMap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComplianceTable.this.cbFilterElementMap.getSelectionIndex() != -1) {
                    ComplianceTable.this.sElementFilter = ComplianceTable.this.cbFilterElementMap.getItem(ComplianceTable.this.cbFilterElementMap.getSelectionIndex());
                }
            }
        });
        Label filterMapType = new Label((Composite)groupFilter, 0);
        filterMapType.setText("   Map type: ");
        this.btnGap = new Button((Composite)groupFilter, 32);
        this.btnGap.setText("Not Defined  ");
        this.btnFull = new Button((Composite)groupFilter, 32);
        this.btnFull.setText("Full  ");
        this.btnFull.setSelection(true);
        this.btnPartial = new Button((Composite)groupFilter, 32);
        this.btnPartial.setText("Partial  ");
        this.btnPartial.setSelection(true);
        this.btnNoMap = new Button((Composite)groupFilter, 32);
        this.btnNoMap.setText("No Map  ");
        this.btnNoMap.setSelection(true);
        this.btnSearch = new Button((Composite)groupFilter, 8);
        this.btnSearch.setText("  SEARCH  ");
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComplianceTable.this.CreateTableContents(ComplianceTable.this.baseFrameworkFrom);
            }
        });
    }

    private void CreateModelFromFiletocombo(Combo combo, MapModel mapModel) {
        if (mapModel != null) {
            try {
                combo.removeAll();
                EList lstMapGroup = mapModel.getMapGroupModel();
                Iterator itermapGroup = lstMapGroup.iterator();
                combo.add("All");
                while (itermapGroup.hasNext()) {
                    combo.add(((MapGroup)itermapGroup.next()).getName());
                }
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Not valid model file", (String)"The provided model file couldn't be parsed as an EMF resource");
            }
        }
    }

    protected void createComplianceTable(Composite parent, ComposedAdapterFactory adapterFactory) {
        Composite Tablecomposite = new Composite(parent, 0);
        GridData data = new GridData(0, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        data.grabExcessVerticalSpace = true;
        Tablecomposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 3;
        Tablecomposite.setLayout((Layout)layout);
        this.tableHistory = new Table(Tablecomposite, 268503042);
        this.tableHistory.setLinesVisible(true);
        this.tableHistory.setHeaderVisible(true);
        GridData tableData = new GridData(1808);
        this.tableHistory.setLayoutData((Object)tableData);
        this.tableHistory.setItemCount(10);
        tableData.horizontalSpan = 2;
        TableColumn col1 = new TableColumn(this.tableHistory, 0);
        col1.setWidth(20);
        col1.setResizable(false);
        col1.setText("");
        TableColumn col2 = new TableColumn(this.tableHistory, 0);
        col2.setWidth(400);
        col2.setText("Base Element");
        TableColumn col3 = new TableColumn(this.tableHistory, 0);
        col3.setWidth(100);
        col3.setText("Status");
        Composite targetcomposite = new Composite(Tablecomposite, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        data2.grabExcessVerticalSpace = true;
        targetcomposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        targetcomposite.setLayout((Layout)layout2);
        Label filterMapType = new Label(targetcomposite, 0);
        filterMapType.setText("Baseline Element Target List: ");
        this.targetsList = new ListViewer(targetcomposite, 2820);
        this.targetsList.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                EList targets = (EList)inputElement;
                return targets.toArray();
            }
        });
        this.targetsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                AssuranceAsset oneTG = (AssuranceAsset)element;
                Object eFeature = oneTG.eGet(oneTG.eClass().getEStructuralFeature("name"));
                String name = "NoNamed";
                if (eFeature != null) {
                    name = eFeature.toString();
                }
                return "{" + oneTG.eClass().getName() + "} " + name;
            }
        });
        BasicCommandStack commandStackET = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomainEvidences = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStackET, new HashMap());
        this.targetsList.addDoubleClickListener((IDoubleClickListener)new OpenWizardOnDoubleClick((EditingDomain)editingDomainEvidences, (AdapterFactory)adapterFactory));
        this.tableHistory.addMouseListener(new MouseListener(){
            private boolean doubleClick;
            private MouseEvent event;

            public void mouseDoubleClick(MouseEvent e) {
                this.doubleClick = true;
                Point p = new Point(e.x, e.y);
                TableItem column = ComplianceTable.this.tableHistory.getItem(p);
                if (column != null) {
                    Object[] dataList = (Object[])column.getData();
                    if (dataList.length > 1) {
                        ComplianceTable.this.callComplianceMapEditor((BaseAssurableElement)dataList[0], (BaseComplianceMap)dataList[1], (String)dataList[2], (String)dataList[3]);
                    } else {
                        ComplianceTable.this.callComplianceMapEditor((BaseAssurableElement)dataList[0], null, null, null);
                    }
                } else {
                    MessageDialog.openInformation((Shell)ComplianceTable.this.getShell(), (String)"Problem with the selected elment", (String)"Not data found");
                }
            }

            public void mouseClick(MouseEvent e) {
                Point p = new Point(e.x, e.y);
                TableItem column = ComplianceTable.this.tableHistory.getItem(p);
                if (column != null) {
                    Object[] dataList = (Object[])column.getData();
                    if (dataList.length > 1) {
                        ComplianceTable.this.targetsList.getList().removeAll();
                        ComplianceTable.this.targetsList.setInput(dataList[4]);
                    }
                } else {
                    MessageDialog.openInformation((Shell)ComplianceTable.this.getShell(), (String)"Problem with the selected elment", (String)"Not data found");
                }
            }

            public void mouseDown(MouseEvent e) {
                this.doubleClick = false;
                this.event = e;
                Display.getDefault().timerExec(Display.getDefault().getDoubleClickTime(), new Runnable(){

                    @Override
                    public void run() {
                        if (!doubleClick) {
                            this.mouseClick(event);
                        }
                    }
                });
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void callComplianceMapEditor(BaseAssurableElement tid, BaseComplianceMap dataList, String mapName, String targetModel) {
        MappingSet complianceEditor = new MappingSet(this.getShell(), this.resourceURI);
        String type = tid.toString();
        type = type.split("@")[0];
        type = type.replace("Base", "");
        complianceEditor.create();
        complianceEditor.selectControlValues(type, tid, dataList, mapName, targetModel);
        complianceEditor.open();
        this.btnSearch.notifyListeners(13, new Event());
    }

    private void CreateTableContents(BaseFramework baseFramework) {
        try {
            ImageDescriptor image;
            URL url;
            Bundle bundle;
            Iterator it;
            EList lst;
            this.tableHistory.removeAll();
            this.targetsList.getList().removeAll();
            if (this.cbFilterElementMap.getSelectionIndex() != -1) {
                this.sElementFilter = this.cbFilterElementMap.getItem(this.cbFilterElementMap.getSelectionIndex());
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ComplianceTable.this.green = Display.getDefault().getSystemColor(5);
                    ComplianceTable.this.orange = new Color(ComplianceTable.this.green.getDevice(), 255, 140, 0);
                    ComplianceTable.this.red = Display.getDefault().getSystemColor(3);
                }
            });
            if (this.sElementFilter.contentEquals("All") || this.sElementFilter.contentEquals("Activity")) {
                lst = baseFramework.getOwnedActivities();
                it = lst.iterator();
                bundle = FrameworkUtil.getBundle(ComplianceTable.class);
                url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/BaseActivity.gif"), null);
                ImageDescriptor imageAct = ImageDescriptor.createFromURL((URL)url);
                while (it.hasNext()) {
                    BaseActivity baseActivity = (BaseActivity)it.next();
                    if (baseActivity.isIsSelected()) {
                        this.addComplianceToTable(imageAct, (BaseAssurableElement)baseActivity);
                    }
                    EList lstSubActivity = baseActivity.getSubActivity();
                    this.searchSubActivities((EList<BaseActivity>)lstSubActivity, imageAct);
                }
            }
            if (this.sElementFilter.contentEquals("All") || this.sElementFilter.contentEquals("Requirement")) {
                lst = baseFramework.getOwnedRequirement();
                it = lst.iterator();
                bundle = FrameworkUtil.getBundle(ComplianceTable.class);
                url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/BaseRequirement.gif"), null);
                image = ImageDescriptor.createFromURL((URL)url);
                while (it.hasNext()) {
                    BaseRequirement baseRequirement = (BaseRequirement)it.next();
                    if (!baseRequirement.isIsSelected()) continue;
                    this.addComplianceToTable(image, (BaseAssurableElement)baseRequirement);
                }
                EList lstBaseActivity = baseFramework.getOwnedActivities();
                this.searchActivityRequirements((EList<BaseActivity>)lstBaseActivity, image);
            }
            if (this.sElementFilter.contentEquals("All") || this.sElementFilter.contentEquals("Artefact")) {
                lst = baseFramework.getOwnedArtefact();
                it = lst.iterator();
                bundle = FrameworkUtil.getBundle(ComplianceTable.class);
                url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/BaseArtefact.gif"), null);
                image = ImageDescriptor.createFromURL((URL)url);
                while (it.hasNext()) {
                    BaseArtefact baseArtefact = (BaseArtefact)it.next();
                    if (!baseArtefact.isIsSelected()) continue;
                    this.addComplianceToTable(image, (BaseAssurableElement)baseArtefact);
                }
            }
            if (this.sElementFilter.contentEquals("All") || this.sElementFilter.contentEquals("Technique")) {
                lst = baseFramework.getOwnedTechnique();
                it = lst.iterator();
                bundle = FrameworkUtil.getBundle(ComplianceTable.class);
                url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/BaseTechnique.gif"), null);
                image = ImageDescriptor.createFromURL((URL)url);
                while (it.hasNext()) {
                    BaseTechnique baseTechnique = (BaseTechnique)it.next();
                    if (!baseTechnique.isIsSelected()) continue;
                    this.addComplianceToTable(image, (BaseAssurableElement)baseTechnique);
                }
            }
            if (this.sElementFilter.contentEquals("All") || this.sElementFilter.contentEquals("Role")) {
                lst = baseFramework.getOwnedRole();
                it = lst.iterator();
                bundle = FrameworkUtil.getBundle(ComplianceTable.class);
                url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/BaseRole.gif"), null);
                image = ImageDescriptor.createFromURL((URL)url);
                while (it.hasNext()) {
                    BaseRole baseRole = (BaseRole)it.next();
                    if (!baseRole.isIsSelected()) continue;
                    this.addComplianceToTable(image, (BaseAssurableElement)baseRole);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addComplianceToTable(ImageDescriptor image, BaseAssurableElement element) {
        EList lstBaseComplianceMap = element.getComplianceMap();
        Iterator itbaseComplianceMap = lstBaseComplianceMap.iterator();
        if (itbaseComplianceMap.hasNext()) {
            while (itbaseComplianceMap.hasNext()) {
                String selectedMapGroup;
                BaseComplianceMap bCM = (BaseComplianceMap)itbaseComplianceMap.next();
                if (!(bCM.getType() == MapKind.FULL && this.btnFull.getSelection() || bCM.getType() == MapKind.PARTIAL && this.btnPartial.getSelection()) && (bCM.getType() != MapKind.NO_MAP || !this.btnNoMap.getSelection())) continue;
                if (this.cbMapGroup.getSelectionIndex() <= 0 || (selectedMapGroup = this.cbMapGroup.getItem(this.cbMapGroup.getSelectionIndex())).equals(bCM.getMapGroup().getName())) {
                    TableItem tableItem = new TableItem(this.tableHistory, 2048);
                    Object[] dataList = new Object[5];
                    dataList[0] = element;
                    dataList[1] = bCM;
                    tableItem.setData((Object)dataList);
                    tableItem.setImage(0, image.createImage());
                    Object idFeature = element.eGet(element.eClass().getEStructuralFeature("id"));
                    if (idFeature != null) {
                        idFeature.toString();
                    }
                    this.getAllContainers((EObject)element);
                    tableItem.setText(1, element.eGet(element.eClass().getEStructuralFeature("name")).toString());
                    dataList[2] = bCM.getName();
                    tableItem.setText(2, bCM.getType().getName());
                    if (bCM.getType() == MapKind.FULL) {
                        tableItem.setBackground(2, this.green);
                    } else if (bCM.getType() == MapKind.PARTIAL) {
                        tableItem.setBackground(2, this.orange);
                    } else if (bCM.getType() == MapKind.NO_MAP) {
                        tableItem.setBackground(2, this.red);
                    }
                    EList targets = bCM.getTarget();
                    Iterator itTargets = targets.iterator();
                    if (!itTargets.hasNext()) continue;
                    AssuranceAsset oneTG = (AssuranceAsset)itTargets.next();
                    String fichero = oneTG.eResource().getURI().path();
                    dataList[3] = fichero;
                    dataList[4] = targets;
                    continue;
                }
                break;
            }
        } else if (this.btnGap.getSelection()) {
            TableItem tableItem = new TableItem(this.tableHistory, 2048);
            tableItem.setImage(0, image.createImage());
            Object idFeature = element.eGet(element.eClass().getEStructuralFeature("id"));
            if (idFeature != null) {
                idFeature.toString();
            }
            this.getAllContainers((EObject)element);
            tableItem.setText(1, element.eGet(element.eClass().getEStructuralFeature("name")).toString());
            Object[] dataList = new Object[]{element};
            tableItem.setData((Object)dataList);
        }
    }

    private String getAllContainers(EObject oneTG) {
        EObject padre = oneTG.eContainer();
        String retorno = "";
        while (padre != null) {
            EStructuralFeature nameEF = padre.eClass().getEStructuralFeature("name");
            if (nameEF != null) {
                Object eFeature = padre.eGet(nameEF);
                String name = "NoNamed";
                if (eFeature != null) {
                    name = eFeature.toString();
                }
                retorno = String.valueOf(name) + "->" + retorno;
            }
            padre = padre.eContainer();
        }
        return retorno;
    }

    private void searchSubActivities(EList<BaseActivity> lstBaseActivity, ImageDescriptor imageAct) {
        for (BaseActivity baseActivity : lstBaseActivity) {
            if (baseActivity.isIsSelected()) {
                this.addComplianceToTable(imageAct, (BaseAssurableElement)baseActivity);
            }
            EList lstSubActivity = baseActivity.getSubActivity();
            this.searchSubActivities((EList<BaseActivity>)lstSubActivity, imageAct);
        }
    }

    private void searchSubRequirements(EList<BaseRequirement> lstBaseRequirement, ImageDescriptor imageReq) {
        for (BaseRequirement baseReq : lstBaseRequirement) {
            if (baseReq.isIsSelected()) {
                this.addComplianceToTable(imageReq, (BaseAssurableElement)baseReq);
            }
            this.searchSubRequirements((EList<BaseRequirement>)baseReq.getSubRequirement(), imageReq);
        }
    }

    private void searchActivityRequirements(EList<BaseActivity> lstBaseActivity, ImageDescriptor imageReq) {
        for (BaseActivity baseActivity : lstBaseActivity) {
            EList lstBaseRequirement = baseActivity.getOwnedRequirement();
            for (BaseRequirement baseReq : lstBaseRequirement) {
                if (baseReq.isIsSelected()) {
                    this.addComplianceToTable(imageReq, (BaseAssurableElement)baseReq);
                }
                this.searchSubRequirements((EList<BaseRequirement>)baseReq.getSubRequirement(), imageReq);
            }
            EList lstSubActivity = baseActivity.getSubActivity();
            this.searchActivityRequirements((EList<BaseActivity>)lstSubActivity, imageReq);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Compliance Map table");
    }

    protected void okPressed() {
        this.transaction.close();
        super.okPressed();
    }

    public boolean close() {
        this.transaction.close();
        return super.close();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public Boolean getResult() {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return RefframeworkEditPlugin.INSTANCE;
    }
}

