/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetCommandFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.util.emf.core.command.EmfCommandUtils;

public class FacetCommandFactoryImpl
implements IFacetCommandFactory {
    private static final String VALUE_NOT_NULL = "The given value cannot be null";
    private static final String PARENT_NOT_NULL = "The given parent cannot be null";
    private static final Object NAME = "name";
    private static final Object LOWER_BOUND = "lowerBound";
    private static final Object UPPER_BOUND = "upperBound";
    private static final Object VOLATILE = "volatile";
    private static final Object CHANGEABLE = "changeable";
    private static final Object DERIVED = "derived";
    private static final Object TRANSIENT = "transient";
    private static final Object ORDERED = "ordered";
    private static final Object UNIQUE = "unique";
    private final EditingDomain editingDomain;

    public FacetCommandFactoryImpl(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    private Command createAddCommand(Object owner, Object element) {
        if (owner == null) {
            throw new IllegalArgumentException("The given owner cannot be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("The given element cannot be null");
        }
        return AddCommand.create((EditingDomain)this.editingDomain, (Object)owner, (Object)FacetCommandFactoryImpl.getEStructuralFeature(element), (Object)element);
    }

    public Command createSetCommand(Object initialObject, Object feature, Object newValue) {
        if (initialObject == null) {
            throw new IllegalArgumentException("The given owner cannot be null");
        }
        if (feature == null) {
            throw new IllegalArgumentException("The given feature cannot be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("The given newValue cannot be null");
        }
        return SetCommand.create((EditingDomain)this.editingDomain, (Object)initialObject, (Object)feature, (Object)newValue);
    }

    private static EStructuralFeature getEStructuralFeature(Object element) {
        EReference result = null;
        if (element instanceof FacetSet) {
            result = EcorePackage.eINSTANCE.getEPackage_ESubpackages();
        } else if (element instanceof Facet) {
            result = EcorePackage.eINSTANCE.getEPackage_EClassifiers();
        } else if (element instanceof FacetAttribute || element instanceof FacetReference) {
            result = EFacetPackage.eINSTANCE.getFacet_FacetElements();
        } else if (element instanceof FacetOperation) {
            result = EFacetPackage.eINSTANCE.getFacet_FacetOperations();
        }
        return result;
    }

    @Override
    public Command createFacetSetInFacetSetCommand(FacetSet owner, FacetSet facetSet) {
        return this.createAddCommand(owner, facetSet);
    }

    @Override
    public Command createFacetInFacetSetCommand(FacetSet parent, Facet facet) {
        return this.createAddCommand(parent, facet);
    }

    @Override
    public Command createEditFacetStructuralFeatureCommand(DerivedTypedElement feature, Facet container, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique, Query query, boolean volatilee, boolean change, boolean derived, boolean transientt) {
        if (feature == null) {
            throw new IllegalArgumentException("The parameter facetOperation must not be null");
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (feature.eContainer() != container) {
            AddCommand command = new AddCommand(this.editingDomain, (EObject)container, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)feature);
            commands.add(command);
        }
        if (feature instanceof EStructuralFeature) {
            SetCommand command;
            EStructuralFeature structuralFeature = (EStructuralFeature)feature;
            if (structuralFeature.isVolatile() != volatilee) {
                command = new SetCommand(this.editingDomain, (EObject)structuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), (Object)volatilee);
                commands.add(command);
            }
            if (structuralFeature.isChangeable() != change) {
                command = new SetCommand(this.editingDomain, (EObject)structuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Changeable(), (Object)change);
                commands.add(command);
            }
            if (structuralFeature.isDerived() != derived) {
                command = new SetCommand(this.editingDomain, (EObject)structuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Derived(), (Object)ordered);
                commands.add(command);
            }
            if (structuralFeature.isTransient() != transientt) {
                command = new SetCommand(this.editingDomain, (EObject)structuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), (Object)unique);
                commands.add(command);
            }
        }
        commands.add(this.createEditDerivedTypeElementCommand(feature, name, lowerBound, upperBound, type, ordered, unique, query));
        return EmfCommandUtils.createResult(commands, (String)"edit facet structural feature");
    }

    @Override
    public Command createAddOperationInFacetCommand(Facet parent, FacetOperation facetOperation) {
        return this.createAddCommand(parent, facetOperation);
    }

    @Override
    public Command createAddReferenceInFacetCommand(Facet parent, FacetReference facetReference) {
        return this.createAddCommand(parent, facetReference);
    }

    @Override
    public Command createAddParameterInOperationCommand(FacetOperation parent, EParameter opParameter) {
        return this.createAddCommand(parent, opParameter);
    }

    @Override
    public Command createChangeOwnerCommand(Object element, Object newOwner) {
        if (element == null) {
            throw new IllegalArgumentException("The given element cannot be null");
        }
        if (newOwner == null) {
            throw new IllegalArgumentException("The given element cannot be null");
        }
        return this.createAddCommand(newOwner, element);
    }

    @Override
    public Command createEditFacetSetCommand(FacetSet editedFacetSet, FacetSet container, String name) {
        if (editedFacetSet == null) {
            throw new IllegalArgumentException("The parameter 'editedFacetSet' must not be null");
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(this.createEditENamedElementcommand((ENamedElement)editedFacetSet, name));
        if (editedFacetSet.eContainer() != container) {
            AddCommand command = new AddCommand(this.editingDomain, (EObject)container, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_ESubpackages(), (Object)editedFacetSet);
            commands.add(command);
        }
        return EmfCommandUtils.createResult(commands, (String)"Edit FacetSet");
    }

    @Override
    public Command createEditFacetCommand(Facet facet, FacetSet container, String name, ETypedElement conformance, EClass extendMetaclass, FacetSet extendedFacetSet) {
        AddCommand command;
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(this.createEditENamedElementcommand((ENamedElement)facet, name));
        if (facet.eContainer() != container) {
            command = new AddCommand(this.editingDomain, (EObject)container, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)facet);
            commands.add(command);
        }
        if (facet.getConformanceTypedElement() != conformance) {
            command = new SetCommand(this.editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_ConformanceTypedElement(), (Object)conformance);
            commands.add(command);
        }
        if (extendedFacetSet != null && (facet.getExtendedFacets().isEmpty() || facet.getExtendedFacets().get(0) != extendedFacetSet)) {
            command = new SetCommand(this.editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_ExtendedFacets(), Collections.singletonList(extendedFacetSet));
            commands.add(command);
        }
        if (facet.getExtendedMetaclass() != extendMetaclass) {
            command = new SetCommand(this.editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_ExtendedMetaclass(), (Object)extendMetaclass);
            commands.add(command);
        }
        return EmfCommandUtils.createResult(commands, (String)"Edit Facet");
    }

    private Command createEditENamedElementcommand(ENamedElement namedElement, String name) {
        if (namedElement == null) {
            throw new IllegalArgumentException("The parameter 'editedFacetSet' must not be null");
        }
        ArrayList<SetCommand> commands = new ArrayList<SetCommand>();
        if (namedElement.getName() != name) {
            SetCommand command = new SetCommand(this.editingDomain, (EObject)namedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), (Object)name);
            commands.add(command);
        }
        return EmfCommandUtils.createResult(commands, (String)"Edit NamedElement");
    }

    @Override
    public Command createSetFacetAttributeCommand(Facet initialContainer, FacetAttribute initialElement, FacetAttribute newElement) {
        if (initialElement == null) {
            throw new IllegalArgumentException(PARENT_NOT_NULL);
        }
        if (newElement == null) {
            throw new IllegalArgumentException(VALUE_NOT_NULL);
        }
        CompoundCommand commands = new CompoundCommand();
        EList facetAttributes = EFacetPackage.eINSTANCE.getFacetAttribute().getEAllAttributes();
        this.setEStructuralFeatureAttributes((EStructuralFeature)initialElement, (EStructuralFeature)newElement, commands, (List<EAttribute>)facetAttributes);
        this.setETypedElementAttributes((ETypedElement)initialElement, (ETypedElement)newElement, commands, (List<EAttribute>)facetAttributes);
        Command changeOwner = this.createChangeOwnerCommand(newElement, initialContainer);
        commands.append(changeOwner);
        return commands;
    }

    @Override
    public Command createSetFacetReferenceCommand(Facet initialContainer, FacetReference initialElement, FacetReference newElement) {
        if (initialElement == null) {
            throw new IllegalArgumentException(PARENT_NOT_NULL);
        }
        if (newElement == null) {
            throw new IllegalArgumentException(VALUE_NOT_NULL);
        }
        CompoundCommand commands = new CompoundCommand();
        EList facetReferences = EFacetPackage.eINSTANCE.getFacetReference().getEAllAttributes();
        this.setEStructuralFeatureAttributes((EStructuralFeature)initialElement, (EStructuralFeature)newElement, commands, (List<EAttribute>)facetReferences);
        this.setETypedElementAttributes((ETypedElement)initialElement, (ETypedElement)newElement, commands, (List<EAttribute>)facetReferences);
        Command changeOwner = this.createChangeOwnerCommand(newElement, initialContainer);
        commands.append(changeOwner);
        return commands;
    }

    public Command createEditFacetOperationCommand(FacetOperation facetOperation, Facet container, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique, Query query) {
        if (facetOperation == null) {
            throw new IllegalArgumentException("The parameter facetOperation must not be null");
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (facetOperation.eContainer() != container) {
            AddCommand command = new AddCommand(this.editingDomain, (EObject)container, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)facetOperation);
            commands.add(command);
        }
        commands.add(this.createEditDerivedTypeElementCommand((DerivedTypedElement)facetOperation, name, lowerBound, upperBound, type, ordered, unique, query));
        return EmfCommandUtils.createResult(commands, (String)"Edit facet operation");
    }

    private Command createEditDerivedTypeElementCommand(DerivedTypedElement dte, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique, Query query) {
        if (dte == null) {
            throw new IllegalArgumentException("The parameter facetOperation must not be null");
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(this.createEditETypedElementCommand((ETypedElement)dte, name, lowerBound, upperBound, type, ordered, unique));
        if (dte.getQuery() != query) {
            SetCommand command = new SetCommand(this.editingDomain, (EObject)dte, (EStructuralFeature)EFacetPackage.eINSTANCE.getDerivedTypedElement_Query(), (Object)query);
            commands.add(command);
        }
        return EmfCommandUtils.createResult(commands, (String)"Edit derived typed element");
    }

    private Command createEditETypedElementCommand(ETypedElement typedElement, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique) {
        SetCommand command;
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(this.createEditENamedElementcommand((ENamedElement)typedElement, name));
        if (typedElement.getLowerBound() != lowerBound) {
            command = new SetCommand(this.editingDomain, (EObject)typedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound(), (Object)lowerBound);
            commands.add(command);
        }
        if (typedElement.getUpperBound() != upperBound) {
            command = new SetCommand(this.editingDomain, (EObject)typedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound(), (Object)upperBound);
            commands.add(command);
        }
        if (typedElement.isOrdered() != ordered) {
            command = new SetCommand(this.editingDomain, (EObject)typedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_Ordered(), (Object)ordered);
            commands.add(command);
        }
        if (typedElement.isUnique() != unique) {
            command = new SetCommand(this.editingDomain, (EObject)typedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_Ordered(), (Object)unique);
            commands.add(command);
        }
        if (typedElement.getEType() != type) {
            command = new SetCommand(this.editingDomain, (EObject)typedElement, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType(), (Object)type);
            commands.add(command);
        }
        return EmfCommandUtils.createResult(commands, (String)"Edit ETypedElement");
    }

    @Override
    public Command createEditOperationParameterCommand(EParameter parameter, FacetOperation facetOperation, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique) {
        if (parameter == null) {
            throw new IllegalArgumentException("The parameter parameter must not be null");
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(this.createEditETypedElementCommand((ETypedElement)parameter, name, lowerBound, upperBound, type, ordered, unique));
        return EmfCommandUtils.createResult(commands, (String)"Edit operation parameter");
    }

    private void setEStructuralFeatureAttributes(EStructuralFeature initialElement, EStructuralFeature newElement, CompoundCommand commands, List<EAttribute> facetOperations) {
        for (EAttribute attribute : facetOperations) {
            if (attribute.getName().equals(TRANSIENT)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.isTransient()));
            }
            if (attribute.getName().equals(VOLATILE)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.isVolatile()));
            }
            if (attribute.getName().equals(CHANGEABLE)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.isChangeable()));
            }
            if (!attribute.getName().equals(DERIVED)) continue;
            commands.append(this.createSetCommand(initialElement, attribute, newElement.isDerived()));
        }
    }

    private void setETypedElementAttributes(ETypedElement initialElement, ETypedElement newElement, CompoundCommand commands, List<EAttribute> facetOperations) {
        for (EAttribute attribute : facetOperations) {
            if (attribute.getName().equals(NAME)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.getName()));
            }
            if (attribute.getName().equals(LOWER_BOUND)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.getLowerBound()));
            }
            if (attribute.getName().equals(UPPER_BOUND)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.getUpperBound()));
            }
            if (attribute.getName().equals(ORDERED)) {
                commands.append(this.createSetCommand(initialElement, attribute, newElement.isOrdered()));
            }
            if (!attribute.getName().equals(UNIQUE)) continue;
            commands.append(this.createSetCommand(initialElement, attribute, newElement.isUnique()));
        }
    }

    @Override
    public Command createEditFacetOperationCommand(DerivedTypedElement dte, Facet facetContainer, String name, int lowerBound, int upperBound, EClassifier type, boolean ordered, boolean unique, Query query) {
        return null;
    }
}

