/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.ui.contentassist;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.scoping.visitors.ScopingVisitors;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.FeatureTree;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSLProposalUtils {
    public static Map<String, Element> buildProposalForType(Classifier classifier, MultiplicityElement elem) {
        Map<String, Element> allProposals = VSLProposalUtils.buildProposalForType(classifier);
        if (elem.upperBound() == 1) {
            return allProposals;
        }
        HashMap<String, Element> allProposalsWithAccountForMultiplicity = new HashMap<String, Element>();
        for (String s : allProposals.keySet()) {
            String displayString;
            if (!s.contains("|")) {
                displayString = s;
            } else {
                String[] splitted = s.split("|");
                displayString = splitted[0];
            }
            String newProposal = "{" + displayString + "/* , " + displayString + " */ }";
            allProposalsWithAccountForMultiplicity.put(newProposal, allProposals.get(s));
        }
        return allProposalsWithAccountForMultiplicity;
    }

    public static Map<String, Element> buildProposalForType(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        if (VSLContextUtil.isATupleType((Classifier)classifier)) {
            allProposals.putAll(VSLProposalUtils.buildProposalForTupleType(classifier));
        } else if (VSLContextUtil.isAChoiceType((Classifier)classifier)) {
            allProposals.putAll(VSLProposalUtils.buildProposalForChoiceType(classifier));
        } else if (VSLContextUtil.isACollectionType((Classifier)classifier)) {
            allProposals.putAll(VSLProposalUtils.buildProposalForCollectionType(classifier));
        } else if (classifier instanceof Enumeration) {
            allProposals.putAll(VSLProposalUtils.buildProposalForEnumeration(classifier));
        } else if (classifier instanceof PrimitiveType) {
            allProposals.putAll(VSLProposalUtils.buildProposalForPrimitiveType(classifier));
        } else if (classifier instanceof Stereotype) {
            allProposals.putAll(VSLProposalUtils.buildProposalForStereotype(classifier));
        } else if (classifier instanceof Class) {
            allProposals.putAll(VSLProposalUtils.buildProposalForMetaclass(classifier));
        } else {
            allProposals.put("/* " + classifier.getName() + "*/", null);
        }
        HashMap<String, Element> crossReferences = new HashMap<String, Element>();
        crossReferences.putAll(VSLProposalUtils.buildProposalForMetaclass(UMLPackage.eINSTANCE.getBehavior()));
        ArrayList<String> proposalsToBeRemoved = new ArrayList<String>();
        for (String key : crossReferences.keySet()) {
            Type behaviorReturnType = null;
            Behavior behavior = (Behavior)crossReferences.get(key);
            for (Parameter p : behavior.getOwnedParameters()) {
                if (p.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
                behaviorReturnType = p.getType();
            }
            if (behaviorReturnType == null) {
                proposalsToBeRemoved.add(key);
                continue;
            }
            if ((classifier.getName().equals("Integer") || classifier.getName().equals("Boolean") || classifier.getName().equals("String")) && !behaviorReturnType.getName().equals(classifier.getName())) {
                proposalsToBeRemoved.add(key);
                continue;
            }
            if (behaviorReturnType.conformsTo((Type)classifier)) continue;
            proposalsToBeRemoved.add(key);
        }
        for (String key : proposalsToBeRemoved) {
            crossReferences.remove(key);
        }
        for (String key : crossReferences.keySet()) {
            Behavior calledBehavior = (Behavior)crossReferences.get(key);
            allProposals.put(String.valueOf(VSLProposalUtils.buildCompletionStringForBehaviorCall(calledBehavior)) + "|" + VSLProposalUtils.buildDisplayStringForBehaviorCall(calledBehavior), (Element)calledBehavior);
        }
        Element context = VSLJavaValidator.getContextElement();
        while (context != null && !(context instanceof Classifier)) {
            context = context.getOwner();
        }
        if (context != null && context instanceof Classifier) {
            EList allProperties = ((Classifier)context).getAllAttributes();
            for (Property p : allProperties) {
                ArrayList<Classifier> classifiers;
                FeatureTree tree = new FeatureTree((Feature)p, classifiers = new ArrayList<Classifier>());
                if (!tree.canClassifierBeReached(classifier)) continue;
                allProposals.put(p.getName(), (Element)p);
            }
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForTupleType(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        String proposal = "";
        proposal = String.valueOf(proposal) + "{";
        Property p = null;
        Property propertyValue = null;
        Property propertyUnit = null;
        boolean first = true;
        for (NamedElement n : VSLContextUtil.getTupleAttribs((Classifier)classifier)) {
            p = (Property)n;
            if (p.getType() == null || p.getType().getName().equalsIgnoreCase("VSL_Expression")) continue;
            if (!first) {
                proposal = String.valueOf(proposal) + ", ";
            } else {
                first = false;
            }
            proposal = String.valueOf(proposal) + p.getName() + " = /";
            if (p.getName().equals("value")) {
                propertyValue = p;
                continue;
            }
            if (!p.getName().equals("unit")) continue;
            propertyUnit = p;
        }
        if (propertyUnit != null && propertyValue != null) {
            String shortProposal = "{unit = /, value = /}";
            allProposals.put(shortProposal, null);
        }
        proposal = String.valueOf(proposal) + "}";
        allProposals.put(proposal, null);
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForChoiceType(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        Property p = null;
        for (NamedElement n : VSLContextUtil.getChoiceAttribs((Classifier)classifier)) {
            p = (Property)n;
            String choiceProposal = String.valueOf(p.getName()) + "(";
            Map<String, Element> nestedProposals = VSLProposalUtils.buildProposalForType((Classifier)p.getType());
            for (String nestedProposal : nestedProposals.keySet()) {
                allProposals.put(String.valueOf(choiceProposal) + nestedProposal + ")", null);
            }
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForCollectionType(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        Property p = null;
        if (VSLContextUtil.getCollectionAttrib((Classifier)classifier) != null) {
            p = (Property)VSLContextUtil.getCollectionAttrib((Classifier)classifier);
        }
        if (p.getType() != null) {
            Map<String, Element> nestedProposals = VSLProposalUtils.buildProposalForType((Classifier)p.getType());
            for (String nestedProposal : nestedProposals.keySet()) {
                allProposals.put("{" + nestedProposal + "}", null);
            }
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForEnumeration(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        for (EnumerationLiteral n : ((Enumeration)classifier).getOwnedLiterals()) {
            allProposals.put(n.getName(), (Element)n);
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForPrimitiveType(Classifier classifier) {
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        if (classifier.getName().contains("Integer")) {
            allProposals.put("1", null);
        } else if (classifier.getName().contains("Real")) {
            allProposals.put("1.0", null);
        } else if (classifier.getName().contains("Natural")) {
            allProposals.put("*", null);
        } else if (classifier.getName().contains("DateTime")) {
            String second;
            String minute;
            String hour;
            Date currentDate = new Date();
            String year = "" + (currentDate.getYear() + 1900);
            String month = "" + currentDate.getMonth();
            if (month.length() == 1) {
                month = "0" + month;
            }
            String day = "";
            switch (currentDate.getDay()) {
                case 0: {
                    day = String.valueOf(day) + "Sun";
                    break;
                }
                case 1: {
                    day = String.valueOf(day) + "Mon";
                    break;
                }
                case 2: {
                    day = String.valueOf(day) + "Tue";
                    break;
                }
                case 3: {
                    day = String.valueOf(day) + "Wed";
                    break;
                }
                case 4: {
                    day = String.valueOf(day) + "Thu";
                    break;
                }
                case 5: {
                    day = String.valueOf(day) + "Fri";
                    break;
                }
                default: {
                    day = String.valueOf(day) + "Sat";
                }
            }
            String dayOfMonth = "" + currentDate.getDate();
            if (dayOfMonth.length() == 1) {
                dayOfMonth = "0" + dayOfMonth;
            }
            if ((hour = "" + currentDate.getHours()).length() == 1) {
                hour = "0" + hour;
            }
            if ((minute = "" + currentDate.getMinutes()).length() == 1) {
                minute = "0" + minute;
            }
            if ((second = "" + currentDate.getSeconds()).length() == 1) {
                second = "0" + second;
            }
            String centi = "00";
            String dateString = String.valueOf(year) + "/" + month + "/" + dayOfMonth;
            String dateString_dayString = String.valueOf(dateString) + " " + day;
            String timeString = String.valueOf(hour) + ":" + minute + ":" + second;
            String timeString_dateString_dayString = String.valueOf(timeString) + " " + dateString + " " + day;
            String timeString_dayString = String.valueOf(timeString) + " " + day;
            String timeString_dateString = String.valueOf(timeString) + " " + dateString;
            String dayString = day;
            allProposals.put(timeString_dateString_dayString, null);
            allProposals.put(timeString_dayString, null);
            allProposals.put(timeString_dateString, null);
            allProposals.put(timeString, null);
            allProposals.put(dateString_dayString, null);
            allProposals.put(dateString, null);
            allProposals.put(dayString, null);
        } else if (classifier.getName().contains("Boolean")) {
            allProposals.put("true", null);
            allProposals.put("false", null);
        } else if (classifier.getName().contains("String")) {
            allProposals.put("\"value\"", null);
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForStereotype(Classifier classifier) {
        ArrayList allElements = new ArrayList();
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        new ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedStereotypeInstances();
        allElements.addAll(ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedStereotypeInstances.visit((Namespace)VSLJavaValidator.getModel(), (Stereotype)((Stereotype)classifier)));
        for (Element c : allElements) {
            if (!(c instanceof NamedElement)) continue;
            allProposals.put(VSLProposalUtils.getNameLabel((NamedElement)c), c);
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForMetaclass(Classifier classifier) {
        ArrayList allElements = new ArrayList();
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        new ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedMetaclassInstances();
        allElements.addAll(ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedMetaclassInstances.visit((Namespace)VSLJavaValidator.getModel(), (Class)((Class)classifier)));
        for (Element c : allElements) {
            if (!(c instanceof NamedElement)) continue;
            allProposals.put(VSLProposalUtils.getNameLabel((NamedElement)c), c);
        }
        return allProposals;
    }

    protected static Map<String, Element> buildProposalForMetaclass(EClass metaclass) {
        ArrayList allElements = new ArrayList();
        HashMap<String, Element> allProposals = new HashMap<String, Element>();
        new ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedMetaclassInstances();
        allElements.addAll(ScopingVisitors.Visitor_GetRecursivelyOwnedAndImportedMetaclassInstances.visit((Namespace)VSLJavaValidator.getModel(), (EClass)metaclass));
        for (Element c : allElements) {
            if (!(c instanceof NamedElement)) continue;
            allProposals.put(VSLProposalUtils.getNameLabel((NamedElement)c), c);
        }
        return allProposals;
    }

    public static String getNameLabel(NamedElement elem) {
        String label = "";
        Namespace model = VSLJavaValidator.getModel();
        ArrayList importedPackages = new ArrayList(model.getImportedPackages());
        ArrayList<Namespace> visitedNamespaces = new ArrayList<Namespace>();
        Namespace currentNamespace = elem.getNamespace();
        boolean rootFound = false;
        while (currentNamespace != null && !rootFound) {
            Element owner;
            visitedNamespaces.add(currentNamespace);
            if (importedPackages.contains(currentNamespace) || currentNamespace == model) {
                rootFound = true;
            }
            Namespace namespace = currentNamespace = (owner = currentNamespace.getOwner()) != null ? (Namespace)owner : null;
        }
        int i = visitedNamespaces.size() - 1;
        while (i >= 0) {
            label = String.valueOf(label) + ((Namespace)visitedNamespaces.get(i)).getName() + "::";
            --i;
        }
        return String.valueOf(label) + elem.getName();
    }

    public static String buildDisplayStringForBehaviorCall(Behavior calledBehavior) {
        String label = String.valueOf(calledBehavior.getName()) + "(";
        String returnTypeName = "";
        ArrayList<String> parameterLabels = new ArrayList<String>();
        for (Parameter p : calledBehavior.getOwnedParameters()) {
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                returnTypeName = p.getType().getName();
                continue;
            }
            String parameterLabel = "";
            switch (p.getDirection()) {
                case IN_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "in ";
                    break;
                }
                case OUT_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "out ";
                    break;
                }
                case INOUT_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "inout ";
                    break;
                }
            }
            parameterLabel = String.valueOf(parameterLabel) + p.getName() + " : " + p.getType().getName();
            parameterLabels.add(parameterLabel);
        }
        boolean first = true;
        for (String parameterLabel : parameterLabels) {
            if (!first) {
                label = String.valueOf(label) + ", ";
            } else {
                first = false;
            }
            label = String.valueOf(label) + parameterLabel;
        }
        return String.valueOf(label) + ") : " + returnTypeName;
    }

    public static String buildCompletionStringForBehaviorCall(Behavior calledBehavior) {
        String label = String.valueOf(calledBehavior.getName()) + "(";
        ArrayList<String> parameterLabels = new ArrayList<String>();
        for (Parameter p : calledBehavior.getOwnedParameters()) {
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            parameterLabels.add(p.getName());
        }
        boolean first = true;
        for (String parameterLabel : parameterLabels) {
            if (!first) {
                label = String.valueOf(label) + ", ";
            } else {
                first = false;
            }
            label = String.valueOf(label) + parameterLabel;
        }
        return String.valueOf(label) + ")";
    }

    public static String buildDisplayStringForOperationCall(Operation calledOperation) {
        String label = String.valueOf(calledOperation.getName()) + "(";
        String returnTypeName = "";
        ArrayList<String> parameterLabels = new ArrayList<String>();
        for (Parameter p : calledOperation.getOwnedParameters()) {
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                returnTypeName = p.getType().getName();
                continue;
            }
            String parameterLabel = "";
            switch (p.getDirection()) {
                case IN_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "in ";
                    break;
                }
                case OUT_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "out ";
                    break;
                }
                case INOUT_LITERAL: {
                    parameterLabel = String.valueOf(parameterLabel) + "inout ";
                    break;
                }
            }
            parameterLabel = String.valueOf(parameterLabel) + p.getName() + " : " + p.getType().getName();
            parameterLabels.add(parameterLabel);
        }
        boolean first = true;
        for (String parameterLabel : parameterLabels) {
            if (!first) {
                label = String.valueOf(label) + ", ";
            } else {
                first = false;
            }
            label = String.valueOf(label) + parameterLabel;
        }
        return String.valueOf(label) + ") : " + returnTypeName;
    }

    public static String buildCompletionStringForOperationCall(Operation calledOperation) {
        String label = String.valueOf(calledOperation.getName()) + "(";
        ArrayList<String> parameterLabels = new ArrayList<String>();
        for (Parameter p : calledOperation.getOwnedParameters()) {
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            parameterLabels.add(p.getName());
        }
        boolean first = true;
        for (String parameterLabel : parameterLabels) {
            if (!first) {
                label = String.valueOf(label) + ", ";
            } else {
                first = false;
            }
            label = String.valueOf(label) + parameterLabel;
        }
        return String.valueOf(label) + ")";
    }
}

