/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.requirements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VerdictKind implements Enumerator
{
    PASS(0, "pass", "pass"),
    FAIL(1, "fail", "fail"),
    INCONCLUSIVE(2, "inconclusive", "inconclusive"),
    ERROR(3, "error", "error");

    public static final int PASS_VALUE = 0;
    public static final int FAIL_VALUE = 1;
    public static final int INCONCLUSIVE_VALUE = 2;
    public static final int ERROR_VALUE = 3;
    private static final VerdictKind[] VALUES_ARRAY;
    public static final List<VerdictKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VerdictKind[]{PASS, FAIL, INCONCLUSIVE, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VerdictKind get(int value) {
        switch (value) {
            case 0: {
                return PASS;
            }
            case 1: {
                return FAIL;
            }
            case 2: {
                return INCONCLUSIVE;
            }
            case 3: {
                return ERROR;
            }
        }
        return null;
    }

    public static VerdictKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerdictKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerdictKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerdictKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private VerdictKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

