/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.IMaskManagedSemanticParser;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.diagram.common.parser.ParameterLabelParser;
import org.eclipse.papyrus.uml.diagram.common.utils.ParameterLabelUtil;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLPackage;

public class OperationLabelParser
extends NamedElementLabelParser {
    protected IMaskManagedSemanticParser parameterParser = new ParameterLabelParser();
    protected static final String VISIBILITY_FORMAT = "%s ";
    protected static final String NAME_FORMAT = "%s%s(%s)";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Operation) {
            Operation operation = (Operation)eObject;
            if (maskValues.contains("visibility")) {
                String visibility;
                switch (operation.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(VISIBILITY_FORMAT, visibility);
            }
            if (maskValues.contains("name") && operation.isSetName()) {
                String name = operation.getName();
                StringBuffer params = new StringBuffer();
                for (Parameter parameter : operation.getOwnedParameters()) {
                    if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                    String currentParamLabel = ParameterLabelUtil.getPrintString(parameter, OperationLabelParser.extractParameterMaskValues(maskValues));
                    params.append(params.length() == 0 ? currentParamLabel : ", " + currentParamLabel);
                }
                result = String.format(NAME_FORMAT, result, name, params);
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (operation.getType() != null) {
                    type = operation.getType().getName();
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            if (maskValues.contains("modifiers")) {
                StringBuffer sb = new StringBuffer();
                if (operation.isAbstract()) {
                    sb.append(sb.length() == 0 ? "abstract" : ", abstract");
                }
                if (operation.isStatic()) {
                    sb.append(sb.length() == 0 ? "static" : ", static");
                }
                if (operation.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (operation.isQuery()) {
                    sb.append(sb.length() == 0 ? "query" : ", query");
                }
                if (operation.isLeaf()) {
                    sb.append(sb.length() == 0 ? "leaf" : ", leaf");
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }

    private static Collection<String> extractParameterMaskValues(Collection<String> operationMaskValues) {
        HashSet<String> result = new HashSet<String>();
        for (String maskValue : operationMaskValues) {
            if (!maskValue.startsWith("parameters")) continue;
            String newValue = StringHelper.firstToLower((String)maskValue.replace("parameters", ""));
            result.add(newValue);
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getNamedElement_Visibility().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getBehavioralFeature_IsAbstract().equals(feature) || UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature) || UMLPackage.eINSTANCE.getOperation_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getOperation_IsQuery().equals(feature) || UMLPackage.eINSTANCE.getRedefinableElement_IsLeaf().equals(feature) || this.parameterParser.isAffectingEvent(event, flags) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Operation) {
            Operation semElement = (Operation)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            for (Parameter parameter : semElement.getOwnedParameters()) {
                semanticElementsBeingParsed.addAll(this.parameterParser.getSemanticElementsBeingParsed((EObject)parameter));
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>(5);
        masks.put("visibility", "Visibility");
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("undefinedType", "Show <Undefined> type");
        masks.put("modifiers", "Modifiers");
        masks.put("parametersDirection", "Parameter direction");
        masks.put("parametersName", "Parameter name");
        masks.put("parametersType", "Parameter type");
        masks.put("parametersMultiplicity", "Parameter multiplicity");
        masks.put("parametersDefault", "Parameter default value");
        masks.put("parametersModifiers", "Parameter modifiers");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name", "type", "parametersDirection", "parametersName", "parametersType");
    }
}

