/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattableFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.Style;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.ui.modelelement.CompositeModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.UMLNotationModelElement;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NattablePropertyEditor
extends AbstractPropertyEditor {
    private static final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
    private static final String TABLES_PREFERENCES_FOLDER_NAME = "tables";
    private static final String FILE_EXTENSION = "table";
    protected Group self = null;
    private URI tableConfigURI = null;
    protected NatTable natTableWidget = null;
    protected INattableModelManager nattableManager = null;
    private DisposeListener nattableDisposeListener = null;
    private IDataSourceListener dataSourceListener;
    private ServicesRegistry serviceRegistry = null;
    private Resource resource = null;
    private Table table = null;
    private TableConfiguration tableConfiguration = null;
    private boolean registerTableConfigurationByEClass = false;

    static {
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        saveOptions.put("SAVE_TYPE_INFORMATION", true);
    }

    public NattablePropertyEditor(Composite parent, int style) {
        this.self = new Group(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        this.self.setLayout((Layout)fillLayout);
    }

    public final void setRegisterTableConfigurationByEClass(boolean newValue) {
        this.registerTableConfigurationByEClass = newValue;
    }

    public void setTableConfigurationURI(String uri) {
        this.tableConfigURI = URI.createURI((String)uri);
        this.checkInput();
    }

    public String getTableConfigurationURI() {
        return this.tableConfigURI == null ? null : this.tableConfigURI.toString();
    }

    @Deprecated
    public void setTableURI(String uri) {
        this.setTableConfigurationURI(uri);
    }

    public String getTableURI() {
        return this.getTableConfigurationURI();
    }

    protected void checkInput() {
        if (this.tableConfigURI != null) {
            super.checkInput();
        }
    }

    protected void doBinding() {
        super.doBinding();
        ModelElement modelElement = this.input.getModelElement(this.propertyPath);
        ArrayList<EModelElement> rows = new ArrayList<EModelElement>();
        EObject sourceElement = null;
        EStructuralFeature feature = null;
        if (modelElement instanceof CompositeModelElement) {
            if (!((CompositeModelElement)modelElement).getSubElements().isEmpty()) {
                if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof UMLNotationModelElement) {
                    EModelElement eModelElement = ((UMLNotationModelElement)((Object)((CompositeModelElement)modelElement).getSubElements().get(0))).getEModelElement();
                    for (ModelElement subModelElement : ((CompositeModelElement)modelElement).getSubElements()) {
                        if (!(subModelElement instanceof UMLNotationModelElement)) continue;
                        rows.add(((UMLNotationModelElement)subModelElement).getEModelElement());
                    }
                    sourceElement = eModelElement;
                } else if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement) {
                    EMFModelElement emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                    sourceElement = emfModelElement.getSource();
                    feature = emfModelElement.getFeature(this.getLocalPropertyPath());
                }
            }
        } else if (modelElement instanceof UMLNotationModelElement) {
            EModelElement eModelElement = ((UMLNotationModelElement)modelElement).getEModelElement();
            rows.add(eModelElement);
            sourceElement = eModelElement;
        } else if (modelElement instanceof EMFModelElement) {
            EMFModelElement emfModelElement = (EMFModelElement)modelElement;
            sourceElement = emfModelElement.getSource();
            feature = emfModelElement.getFeature(this.getLocalPropertyPath());
        } else {
            this.displayError("Invalid table context");
            return;
        }
        this.createWidgets(sourceElement, feature, rows);
    }

    protected void createWidgets(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        this.createPreviousWidgets(sourceElement, feature);
        this.createTableWidget(sourceElement, feature, rows);
        this.createFollowingWidgets(sourceElement, feature);
        this.configureLayout(sourceElement);
        this.self.layout();
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
    }

    protected void createTableWidget(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        if (this.serviceRegistry == null) {
            try {
                this.serviceRegistry = this.createServiceRegistry(sourceElement);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        if (this.serviceRegistry == null) {
            this.displayError("Cannot initialize the service registry");
            return;
        }
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        if (domain == null) {
            this.displayError("Cannot found the editing domain");
            return;
        }
        this.table = this.getOrCreateTable(sourceElement, feature, rows);
        if (this.table == null) {
            this.displayError("Cannot initialize the table");
            return;
        }
        CompoundCommand cc = new CompoundCommand("Configure table command");
        if (this.table.eResource() == null) {
            cc.append(NattablePropertyEditor.addTableToResource(domain, this.resource, this.table));
        }
        this.configureTable(domain, this.table, sourceElement, feature, rows, cc);
        if (!cc.canExecute()) {
            this.displayError("The table can't be initialized");
            return;
        }
        ResourceSet resourceSet = this.getResourceSet();
        resourceSet.getResources().remove((Object)this.resource);
        domain.getCommandStack().execute((Command)cc);
        resourceSet.getResources().add((Object)this.resource);
        if (this.table.getContext() == null) {
            this.displayError("The context of the table hasn't be set");
            return;
        }
        this.nattableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(this.table, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.natTableWidget = this.createNatTableWidget(this.nattableManager, (Composite)this.self, 0, rows);
        this.self.addDisposeListener(this.getDisposeListener());
        this.configureLayout();
        ((NattableModelManager)this.nattableManager).refreshNatTable();
    }

    protected void createFollowingWidgets(EObject sourceElement, EStructuralFeature feature) {
    }

    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        NatTable natTable = manager.createNattable((Composite)this.self, style, null);
        natTable.setBackground(this.self.getBackground());
        return natTable;
    }

    protected ServicesRegistry createServiceRegistry(EObject sourceElement) throws Exception {
        ServicesRegistry result = new ServicesRegistry();
        result.add(ModelSet.class, 10, (Object)new ModelSet());
        ServiceDescriptor desc = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        desc.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        desc.setClassBundleID("org.eclipse.papyrus.uml.properties");
        result.add(desc);
        result.startRegistry();
        return result;
    }

    protected void configureTable(TransactionalEditingDomain domain, Table table, EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows, CompoundCommand command) {
        Assert.isNotNull((Object)domain);
        Command setContextCommand = SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Context(), (Object)sourceElement);
        command.append(setContextCommand);
    }

    @Deprecated
    protected void configureTreeTable(TreeNattableModelManager nattableManager, EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
    }

    @Deprecated
    protected void configureLayout() {
        GridData data = new GridData(4, 4, true, true);
        int headerHeight = this.natTableWidget.getPreferredHeight() - this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getPreferredHeight();
        int bodyHeight = this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getHeight();
        int extra = 36;
        data.minimumHeight = headerHeight + bodyHeight + 36;
        this.self.setLayoutData((Object)data);
        this.self.layout();
        this.natTableWidget.layout();
    }

    protected void configureLayout(EObject sourceElement) {
        this.configureSize(sourceElement);
        this.natTableWidget.layout();
        ((NattableModelManager)this.nattableManager).refreshNatTable();
    }

    protected void configureSize(EObject sourceElement) {
        GridData data = new GridData(4, 4, true, true);
        int headerHeight = this.natTableWidget.getPreferredHeight() - this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getPreferredHeight();
        int bodyHeight = this.nattableManager.getBodyLayerStack().getRowHideShowLayer().getHeight();
        int extra = 36;
        data.minimumHeight = headerHeight + bodyHeight + 36;
        this.self.setLayoutData((Object)data);
    }

    protected void updateDescription(String description) {
        this.self.setToolTipText(description);
    }

    public void updateLabel(String label) {
        if (this.showLabel) {
            this.self.setText(this.getLabel());
        }
    }

    protected void displayError(String message) {
        CLabel label = new CLabel((Composite)this.self, 0);
        label.setText(message);
        label.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/error.gif"));
    }

    protected Table getOrCreateTable(EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows) {
        Table returnedTable = null;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        if (this.serviceRegistry != null) {
            URI tableURI = this.createTableURI(sourceElement, tableConfiguration);
            ResourceSet resourceSet = this.getResourceSet();
            ((ModelSet)resourceSet).createModels(tableURI);
            boolean exists = resourceSet.getURIConverter().exists(tableURI, Collections.emptyMap());
            this.resource = exists ? resourceSet.getResource(tableURI, true) : resourceSet.createResource(tableURI);
            Iterator iter = this.resource.getContents().iterator();
            while (iter.hasNext() && returnedTable == null) {
                TableConfiguration configuration;
                EObject object = (EObject)iter.next();
                if (!(object instanceof Table) || (configuration = ((Table)object).getTableConfiguration()) == null || !configuration.getType().equals(this.getTableConfiguration().getType())) continue;
                returnedTable = (Table)object;
            }
            if (returnedTable == null) {
                returnedTable = this.createTable(sourceElement, synchronizedFeature);
            }
        }
        return returnedTable;
    }

    protected ResourceSet getResourceSet() {
        ResourceSet set = null;
        if (this.serviceRegistry != null) {
            try {
                set = (ResourceSet)this.serviceRegistry.getService(ModelSet.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return set;
    }

    protected URI createTableURI(EObject sourceElement, TableConfiguration tableConfiguration) {
        IPath preferencePath = Activator.getDefault().getStateLocation();
        preferencePath = preferencePath.append(TABLES_PREFERENCES_FOLDER_NAME).append(tableConfiguration.getType());
        StringBuilder b = new StringBuilder().append(preferencePath.toPortableString());
        if (this.registerTableConfigurationByEClass) {
            ModelElement modelElement = this.input.getModelElement(this.propertyPath);
            EClass eClass = null;
            if (modelElement instanceof CompositeModelElement) {
                CompositeModelElement compoModelElement = (CompositeModelElement)modelElement;
                Iterator iter = compoModelElement.getSubElements().iterator();
                while (eClass == null && iter.hasNext()) {
                    ModelElement tmp = (ModelElement)iter.next();
                    if (tmp instanceof UMLNotationModelElement) {
                        EditPart part = ((UMLNotationModelElement)tmp).getEditPart();
                        eClass = EMFHelper.getEObject((Object)part).eClass();
                        continue;
                    }
                    if (!(tmp instanceof EMFModelElement)) continue;
                    eClass = ((EMFModelElement)tmp).getSource().eClass();
                }
            }
            if (modelElement instanceof UMLNotationModelElement) {
                EditPart part = ((UMLNotationModelElement)modelElement).getEditPart();
                eClass = EMFHelper.getEObject((Object)part).eClass();
            }
            b.append("_");
            b.append(eClass.getName());
        }
        URI newURI = URI.createFileURI((String)b.toString()).appendFileExtension(FILE_EXTENSION);
        return newURI;
    }

    protected Table createTable(EObject sourceElement, EStructuralFeature synchronizedFeature) {
        BooleanValueStyle expandStyle;
        BooleanValueStyle fillStyle;
        String description;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfiguration);
        Property property = this.getModelProperty();
        if (property != null && (description = property.getDescription()) != null) {
            table.setDescription(description);
        }
        table.setName(this.getLabel());
        Object rowProvider = tableConfiguration.getDefaultRowAxisProvider();
        rowProvider = rowProvider == null ? NattableaxisproviderFactory.eINSTANCE.createMasterObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        Object columnProvider = tableConfiguration.getDefaultColumnAxisProvider();
        columnProvider = columnProvider == null ? NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        table.getColumnAxisProvidersHistory().add(columnProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add(rowProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        for (Style style : tableConfiguration.getStyles()) {
            table.getStyles().add((Object)((Style)EcoreUtil.copy((EObject)style)));
        }
        BooleanValueStyle columnsWidthAsPercentage = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
        if (columnsWidthAsPercentage == null && (fillStyle = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize")) == null) {
            columnsWidthAsPercentage = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            columnsWidthAsPercentage.setName("columnsWidthAsPercentage");
            columnsWidthAsPercentage.setBooleanValue(true);
            table.getStyles().add((Object)columnsWidthAsPercentage);
        }
        if ((expandStyle = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "expandAll")) == null) {
            expandStyle = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            expandStyle.setName("expandAll");
            expandStyle.setBooleanValue(true);
            table.getStyles().add((Object)expandStyle);
        }
        return table;
    }

    @Deprecated
    protected Table createTable(EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows) {
        String description;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfiguration);
        Property property = this.getModelProperty();
        if (property != null && (description = property.getDescription()) != null) {
            table.setDescription(description);
        }
        table.setName(this.getLabel());
        Object rowProvider = tableConfiguration.getDefaultRowAxisProvider();
        rowProvider = rowProvider == null ? NattableaxisproviderFactory.eINSTANCE.createMasterObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        Object columnProvider = tableConfiguration.getDefaultColumnAxisProvider();
        columnProvider = columnProvider == null ? NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        if (synchronizedFeature != null) {
            TableHeaderAxisConfiguration rowHeaderAxisconfig = tableConfiguration.getRowHeaderAxisConfiguration();
            for (IAxisConfiguration axisConfig : rowHeaderAxisconfig.getOwnedAxisConfigurations()) {
                if (!(axisConfig instanceof EStructuralFeatureValueFillingConfiguration)) continue;
                ((EStructuralFeatureValueFillingConfiguration)axisConfig).setListenFeature(synchronizedFeature);
            }
        }
        table.getColumnAxisProvidersHistory().add(columnProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add(rowProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        for (Style style : tableConfiguration.getStyles()) {
            table.getStyles().add((Object)((Style)EcoreUtil.copy((EObject)style)));
        }
        return table;
    }

    @Deprecated
    protected void addTreeItemAxis(AbstractAxisProvider axisProvider, AxisManagerRepresentation rep, Object object) {
        if (object instanceof View && this.isStereotypedElement((View)object)) {
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            ITreeItemAxis axis = ITreeItemAxisHelper.createITreeItemAxis(null, null, (Object)object, (AxisManagerRepresentation)rep);
            Command addCommand = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)axisProvider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.singleton(axis));
            domain.getCommandStack().execute(addCommand);
        }
    }

    protected TransactionalEditingDomain getTableEditingDomain() {
        try {
            return (TransactionalEditingDomain)this.serviceRegistry.getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    protected boolean isStereotypedElement(View view) {
        boolean result = false;
        if (view.getElement() instanceof Element && !((Element)view.getElement()).getAppliedStereotypes().isEmpty()) {
            result = true;
        }
        return result;
    }

    protected TableConfiguration getTableConfiguration() {
        ResourceSet resourceSet;
        if (this.tableConfiguration == null && (resourceSet = this.getResourceSet()) != null) {
            try {
                this.tableConfiguration = (TableConfiguration)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)this.tableConfigURI);
            }
            catch (Exception ex) {
                Activator.log.error("Invalid table configuration", (Throwable)ex);
            }
        }
        return this.tableConfiguration;
    }

    protected DisposeListener getDisposeListener() {
        if (this.nattableDisposeListener == null) {
            this.nattableDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    NattablePropertyEditor.this.disposeListener();
                }
            };
        }
        return this.nattableDisposeListener;
    }

    protected void disposeListener() {
        if (this.serviceRegistry != null) {
            TransactionalEditingDomain domain;
            if (this.nattableManager != null) {
                this.nattableManager.dispose();
            }
            if (this.natTableWidget != null) {
                this.natTableWidget.dispose();
            }
            if ((domain = this.getTableEditingDomain()) != null && this.table != null) {
                ResourceSet resourceSet = this.getResourceSet();
                resourceSet.getResources().remove((Object)this.resource);
                CompoundCommand cmd = this.getDisposeTableCommand(domain, this.table);
                cmd.execute();
                resourceSet.getResources().add((Object)this.resource);
            }
            if (this.resource != null) {
                try {
                    this.resource.save(saveOptions);
                }
                catch (IOException e1) {
                    Activator.log.error((Throwable)e1);
                }
            }
            try {
                this.serviceRegistry.disposeRegistry();
            }
            catch (ServiceMultiException e1) {
                Activator.log.error((Throwable)e1);
            }
            this.serviceRegistry = null;
            this.table = null;
        }
    }

    protected CompoundCommand getDisposeTableCommand(TransactionalEditingDomain domain, Table table) {
        CompoundCommand disposeCommand = new CompoundCommand("Command used to clean the table before disposing it");
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Context(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Owner(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table.getCurrentRowAxisProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.emptyList()));
        return disposeCommand;
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                public void dataSourceChanged(DataSourceChangedEvent event) {
                    NattablePropertyEditor.this.disposeListener();
                    if (NattablePropertyEditor.this.self != null) {
                        if (NattablePropertyEditor.this.self.getChildren().length > 0) {
                            Control[] controlArray = NattablePropertyEditor.this.self.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control control = controlArray[n2];
                                control.dispose();
                                ++n2;
                            }
                        }
                        NattablePropertyEditor.this.self.removeDisposeListener(NattablePropertyEditor.this.getDisposeListener());
                        NattablePropertyEditor.this.nattableDisposeListener = null;
                        NattablePropertyEditor.this.self.layout();
                    }
                    DataSource dataSource = event.getDataSource();
                    StructuredSelection selection = (StructuredSelection)dataSource.getSelection();
                    ArrayList<Object> contexts = new ArrayList<Object>(selection.size());
                    for (Object selectedObject : selection) {
                        if (selectedObject instanceof AbstractEditPart) {
                            contexts.add(((AbstractEditPart)selectedObject).getModel());
                            continue;
                        }
                        contexts.add(selectedObject);
                    }
                    if (contexts.size() > 0) {
                        ModelElement modelElement = dataSource.getModelElement(NattablePropertyEditor.this.propertyPath);
                        EObject sourceElement = NattablePropertyEditor.this.getEObjectAsTableContext(EMFHelper.getEObject(contexts.get(0)));
                        EStructuralFeature feature = null;
                        if (modelElement instanceof CompositeModelElement) {
                            if (!((CompositeModelElement)modelElement).getSubElements().isEmpty() && ((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement) {
                                EMFModelElement emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                                feature = emfModelElement.getFeature(NattablePropertyEditor.this.getLocalPropertyPath());
                            }
                        } else if (modelElement instanceof EMFModelElement) {
                            EMFModelElement emfModelElement = (EMFModelElement)modelElement;
                            feature = emfModelElement.getFeature(NattablePropertyEditor.this.getLocalPropertyPath());
                        }
                        NattablePropertyEditor.this.createWidgets(sourceElement, feature, contexts);
                    }
                }
            };
        }
        return this.dataSourceListener;
    }

    protected EObject getEObjectAsTableContext(EObject element) {
        EObject result = element;
        if (result instanceof View) {
            result = ((View)result).getElement();
        }
        return result;
    }

    private static final Command addTableToResource(TransactionalEditingDomain domain, final Resource resource, final Table table) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                resource.getContents().add((Object)table);
            }
        };
    }
}

