/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.prettyprint;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.Value;

public class EssentialOCLPrettyPrintVisitor
extends PrettyPrintVisitor {
    public EssentialOCLPrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    protected void appendSourceNavigation(@NonNull CallExp object) {
        OCLExpression source = object.getOwnedSource();
        if (!(source == null || source instanceof VariableExp && ((VariableExp)source).isIsImplicit())) {
            if (source instanceof OperationCallExp && ((OperationCallExp)source).getReferredOperation() != null && ((OperationCallExp)source).getReferredOperation().getPrecedence() != null) {
                ((PrettyPrinter)this.context).append("(");
                ((PrettyPrinter)this.context).precedenceVisit(source, null);
                ((PrettyPrinter)this.context).append(")");
            } else {
                this.safeVisit(source);
            }
            if (source.getType() instanceof CollectionType) {
                ((PrettyPrinter)this.context).append(PivotUtil.getNavigationOperator(object.isIsSafe(), !object.isIsImplicit()));
            } else if (!object.isIsImplicit()) {
                ((PrettyPrinter)this.context).append(PivotUtil.getNavigationOperator(object.isIsSafe(), false));
            }
        }
    }

    @Override
    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
        ((PrettyPrinter)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return null;
    }

    @Override
    public Object visitCollectionItem(@NonNull CollectionItem object) {
        this.safeVisit(object.getOwnedItem());
        return null;
    }

    @Override
    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        ((PrettyPrinter)this.context).appendName(object.getType(), ((PrettyPrinter)this.context).getReservedNames());
        List<CollectionLiteralPart> parts = object.getOwnedParts();
        if (parts.isEmpty()) {
            ((PrettyPrinter)this.context).append("{}");
        } else {
            ((PrettyPrinter)this.context).push("{", "");
            String prefix = "";
            for (CollectionLiteralPart part : parts) {
                ((PrettyPrinter)this.context).append(prefix);
                this.safeVisit(part);
                prefix = ", ";
            }
            ((PrettyPrinter)this.context).exdent("", "}", "");
            ((PrettyPrinter)this.context).pop();
        }
        return null;
    }

    @Override
    public Object visitCollectionRange(@NonNull CollectionRange object) {
        this.safeVisit(object.getOwnedFirst());
        ((PrettyPrinter)this.context).next("", "..", "");
        this.safeVisit(object.getOwnedLast());
        return null;
    }

    @Override
    public Object visitConstraint(@NonNull Constraint object) {
        String stereotype = PivotUtilInternal.getStereotype(object);
        if ("body".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("body");
        } else if ("derivation".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("der");
        } else if ("initial".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("init");
        } else if ("invariant".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("inv");
        } else if ("postcondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("post");
        } else if ("precondition".equals(stereotype)) {
            ((PrettyPrinter)this.context).append("pre");
        } else {
            ((PrettyPrinter)this.context).append(stereotype);
        }
        if (object.getName() != null) {
            ((PrettyPrinter)this.context).append(" ");
            ((PrettyPrinter)this.context).appendName(object);
        }
        ((PrettyPrinter)this.context).push(":", " ");
        this.safeVisit(object.getOwnedSpecification());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp object) {
        this.safeVisit(object.getReferredLiteral());
        return null;
    }

    @Override
    public Object visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        OCLExpression bodyExpression = object.getOwnedBody();
        if (bodyExpression != null) {
            this.safeVisit(bodyExpression);
        } else {
            String body = object.getBody();
            if (body != null) {
                ((PrettyPrinter)this.context).append(body);
            } else {
                ((PrettyPrinter)this.context).append("null -- not specified");
            }
        }
        return null;
    }

    @Override
    public Object visitIfExp(@NonNull IfExp object) {
        ((PrettyPrinter)this.context).push("if", " ");
        this.safeVisit(object.getOwnedCondition());
        ((PrettyPrinter)this.context).exdent(" ", "then", " ");
        this.safeVisit(object.getOwnedThen());
        ((PrettyPrinter)this.context).exdent(" ", "else", " ");
        this.safeVisit(object.getOwnedElse());
        ((PrettyPrinter)this.context).exdent(" ", "endif", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getIntegerSymbol());
        return null;
    }

    @Override
    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp object) {
        ((PrettyPrinter)this.context).append("invalid");
        return null;
    }

    @Override
    public Object visitIterateExp(@NonNull IterateExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getOwnedBody();
        Variable result = object.getOwnedResult();
        if (((PrettyPrinter)this.context).showNames()) {
            List<Variable> iterators = object.getOwnedIterators();
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            if (iterators.size() > 0) {
                boolean hasExplicitIterator = false;
                for (Variable iterator : iterators) {
                    if (iterator.isIsImplicit()) continue;
                    if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                    ((PrettyPrinter)this.context).appendName(iterator);
                    prefix = ",";
                    hasExplicitIterator = true;
                }
                if (hasExplicitIterator) {
                    prefix = ";";
                }
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(result);
                ((PrettyPrinter)this.context).next(null, " |", " ");
            }
            this.safeVisit(body);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
        } else {
            Type sourceType;
            OCLExpression source = object.getOwnedSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getOwnedIterators()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, ";", " ");
            ((PrettyPrinter)this.context).appendName(result);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(result.getType());
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    @Override
    public Object visitIteratorExp(@NonNull IteratorExp object) {
        Iteration referredIteration = object.getReferredIteration();
        OCLExpression body = object.getOwnedBody();
        if (((PrettyPrinter)this.context).showNames()) {
            List<Variable> iterators = object.getOwnedIterators();
            this.appendSourceNavigation(object);
            if (object.isIsImplicit()) {
                assert (referredIteration.getName().equals("collect"));
                assert (iterators.size() == 1);
                this.safeVisit(body);
            } else {
                ((PrettyPrinter)this.context).appendName(referredIteration);
                ((PrettyPrinter)this.context).push("(", "");
                if (iterators.size() > 0) {
                    String prefix = null;
                    boolean hasExplicitIterator = false;
                    for (Variable iterator : iterators) {
                        if (iterator.isIsImplicit()) continue;
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        ((PrettyPrinter)this.context).appendName(iterator);
                        prefix = ",";
                        hasExplicitIterator = true;
                    }
                    if (hasExplicitIterator) {
                        ((PrettyPrinter)this.context).next(null, " |", " ");
                    } else if (prefix != null) {
                        ((PrettyPrinter)this.context).next(null, prefix, " ");
                    }
                }
                this.safeVisit(body);
                ((PrettyPrinter)this.context).next("", ")", "");
                ((PrettyPrinter)this.context).pop();
            }
        } else {
            Type sourceType;
            OCLExpression source = object.getOwnedSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredIteration);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (Variable iterator : object.getOwnedIterators()) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName(iterator);
                ((PrettyPrinter)this.context).append(" : ");
                this.safeVisit(iterator.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next(null, " |", " ");
            this.safeVisit(body != null ? body.getType() : null);
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    @Override
    public Object visitLetExp(@NonNull LetExp object) {
        ((PrettyPrinter)this.context).push("let", " ");
        this.safeVisit(object.getOwnedVariable());
        ((PrettyPrinter)this.context).exdent(" ", "in", " ");
        this.safeVisit(object.getOwnedIn());
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMapLiteralExp(@NonNull MapLiteralExp object) {
        ((PrettyPrinter)this.context).appendName(object.getType(), ((PrettyPrinter)this.context).getReservedNames());
        List<MapLiteralPart> parts = object.getOwnedParts();
        if (parts.isEmpty()) {
            ((PrettyPrinter)this.context).append("{}");
        } else {
            ((PrettyPrinter)this.context).push("{", "");
            String prefix = "";
            for (MapLiteralPart part : parts) {
                ((PrettyPrinter)this.context).append(prefix);
                this.safeVisit(part);
                prefix = ", ";
            }
            ((PrettyPrinter)this.context).exdent("", "}", "");
            ((PrettyPrinter)this.context).pop();
        }
        return null;
    }

    @Override
    public Object visitMapLiteralPart(@NonNull MapLiteralPart object) {
        this.safeVisit(object.getOwnedKey());
        ((PrettyPrinter)this.context).next("", " <- ", "");
        this.safeVisit(object.getOwnedValue());
        return null;
    }

    @Override
    public Object visitNullLiteralExp(@NonNull NullLiteralExp object) {
        ((PrettyPrinter)this.context).append("null");
        return null;
    }

    @Override
    public Object visitOCLExpression(@NonNull OCLExpression object) {
        ((PrettyPrinter)this.context).append("<");
        ((PrettyPrinter)this.context).append(object.eClass().getName());
        ((PrettyPrinter)this.context).append(">");
        return null;
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        OCLExpression source = object.getOwnedSource();
        List<OCLExpression> arguments = object.getOwnedArguments();
        Operation referredOperation = object.getReferredOperation();
        if (((PrettyPrinter)this.context).showNames()) {
            Precedence precedence;
            Precedence precedence2 = precedence = referredOperation != null ? referredOperation.getPrecedence() : null;
            if (precedence == null) {
                this.appendSourceNavigation(object);
                if (!object.isIsImplicit()) {
                    ((PrettyPrinter)this.context).appendName(referredOperation);
                    ((PrettyPrinter)this.context).push("(", "");
                    String prefix = null;
                    for (OCLExpression argument : arguments) {
                        if (prefix != null) {
                            ((PrettyPrinter)this.context).next(null, prefix, " ");
                        }
                        ((PrettyPrinter)this.context).precedenceVisit(argument, null);
                        prefix = ",";
                    }
                    ((PrettyPrinter)this.context).next("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            } else {
                boolean lowerPrecedence;
                Precedence currentPrecedence = ((PrettyPrinter)this.context).getCurrentPrecedence();
                boolean bl = lowerPrecedence = currentPrecedence != null && precedence.getOrder().intValue() > currentPrecedence.getOrder().intValue();
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).push("(", null);
                }
                if (arguments.size() == 0) {
                    ((PrettyPrinter)this.context).appendName(referredOperation, null);
                    if (referredOperation != null && PivotUtilInternal.isValidIdentifier(referredOperation.getName())) {
                        ((PrettyPrinter)this.context).append(" ");
                    }
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                } else {
                    ((PrettyPrinter)this.context).precedenceVisit(source, precedence);
                    String name = ((PrettyPrinter)this.context).getName(referredOperation, null);
                    assert (name != null);
                    ((PrettyPrinter)this.context).next(" ", name, " ");
                    ((PrettyPrinter)this.context).precedenceVisit(arguments.get(0), precedence);
                }
                if (lowerPrecedence) {
                    ((PrettyPrinter)this.context).exdent("", ")", "");
                    ((PrettyPrinter)this.context).pop();
                }
            }
        } else {
            Type sourceType;
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredOperation);
            ((PrettyPrinter)this.context).push("(", "");
            String prefix = null;
            for (OCLExpression argument : arguments) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                this.safeVisit(argument.getType());
                prefix = ",";
            }
            ((PrettyPrinter)this.context).next("", ")", "");
            ((PrettyPrinter)this.context).pop();
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    @Override
    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        Property referredProperty;
        Property referredOppositeProperty = object.getReferredProperty();
        Property property = referredProperty = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        if (((PrettyPrinter)this.context).showNames()) {
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredProperty);
        } else {
            Type sourceType;
            OCLExpression source = object.getOwnedSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredProperty);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    @Override
    public Object visitParameter(@NonNull Parameter object) {
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendQualifiedType(type);
            ((PrettyPrinter)this.context).appendTypedMultiplicity(object);
        }
        return null;
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property referredProperty = object.getReferredProperty();
        if (((PrettyPrinter)this.context).showNames()) {
            this.appendSourceNavigation(object);
            ((PrettyPrinter)this.context).appendName(referredProperty);
        } else {
            Type sourceType;
            OCLExpression source = object.getOwnedSource();
            if (source != null && (sourceType = source.getType()) != null) {
                ((PrettyPrinter)this.context).appendQualifiedType(sourceType);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName(referredProperty);
            ((PrettyPrinter)this.context).append(" : ");
            this.safeVisit(object.getType());
        }
        return null;
    }

    @Override
    public Object visitRealLiteralExp(@NonNull RealLiteralExp object) {
        ((PrettyPrinter)this.context).append(object.getRealSymbol());
        return null;
    }

    @Override
    public Value visitShadowExp(@NonNull ShadowExp object) {
        Class type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (ShadowPart part : object.getOwnedParts()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public String visitShadowPart(@NonNull ShadowPart part) {
        ((PrettyPrinter)this.context).appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getOwnedInit();
        if (initExpression != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public Object visitStringLiteralExp(@NonNull StringLiteralExp object) {
        ((PrettyPrinter)this.context).append("'");
        ((PrettyPrinter)this.context).append(StringUtil.convertToOCLString(object.getStringSymbol()));
        ((PrettyPrinter)this.context).append("'");
        return null;
    }

    @Override
    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        ((PrettyPrinter)this.context).append("Tuple");
        ((PrettyPrinter)this.context).push("{", "");
        String prefix = "";
        for (TupleLiteralPart part : object.getOwnedParts()) {
            ((PrettyPrinter)this.context).append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        ((PrettyPrinter)this.context).exdent("", "}", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        ((PrettyPrinter)this.context).appendName(object);
        ((PrettyPrinter)this.context).append(" = ");
        this.safeVisit(object.getOwnedInit());
        return null;
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp object) {
        Type type = object.getReferredType();
        if (type != null) {
            ((PrettyPrinter)this.context).appendQualifiedType(type);
        }
        return null;
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp object) {
        Number symbol = object.getUnlimitedNaturalSymbol();
        if (symbol == Unlimited.INSTANCE) {
            ((PrettyPrinter)this.context).append("*");
        } else {
            ((PrettyPrinter)this.context).append(symbol.toString());
        }
        return null;
    }

    @Override
    public Object visitVariable(@NonNull Variable object) {
        OCLExpression initExpression;
        ((PrettyPrinter)this.context).appendName(object);
        Type type = object.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity(object);
        }
        if ((initExpression = object.getOwnedInit()) != null) {
            ((PrettyPrinter)this.context).append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public Object visitVariableExp(@NonNull VariableExp object) {
        VariableDeclaration referredVariable = object.getReferredVariable();
        if (referredVariable != null && "self".equals(referredVariable.getName())) {
            ((PrettyPrinter)this.context).appendName(referredVariable, null);
        } else {
            ((PrettyPrinter)this.context).appendName(referredVariable);
        }
        return null;
    }
}

