/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.collection.CollectionAsBagOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsOrderedSetOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsSequenceOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsSetOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingAllOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionFlattenOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionIntersectionOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionMinOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionFirstOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionLastOperation;
import org.eclipse.ocl.pivot.library.iterator.AnyIteration;
import org.eclipse.ocl.pivot.library.iterator.CollectIteration;
import org.eclipse.ocl.pivot.library.iterator.RejectIteration;
import org.eclipse.ocl.pivot.library.iterator.SelectIteration;
import org.eclipse.ocl.pivot.library.iterator.SortedByIteration;

public abstract class TemplateParameterSubstitutionHelper {
    private static @NonNull Map<Class<? extends LibraryFeature>, TemplateParameterSubstitutionHelper> className2helper = new HashMap<Class<? extends LibraryFeature>, TemplateParameterSubstitutionHelper>();

    static {
        TemplateParameterSubstitutionHelper.addHelper(AnyIteration.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectIteration.class, new CollectionCollectHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsBagOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsOrderedSetOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsSequenceOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsSetOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionExcludingOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionExcludingAllOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionIntersectionOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionMinOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionAtOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionFirstOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionLastOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionFlattenOperation.class, new CollectionFlattenHelper());
        TemplateParameterSubstitutionHelper.addHelper(RejectIteration.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(SelectIteration.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(SortedByIteration.class, new CollectionSourceHelper());
    }

    public void resolveUnmodeledTemplateParameterSubstitutions(@NonNull TemplateParameterSubstitutionVisitor templateParameterSubstitutions, @NonNull CallExp callExp) {
    }

    public @Nullable Type resolveBodyType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type bodyType) {
        return bodyType;
    }

    public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
        return returnType;
    }

    public static void addHelper(@NonNull Class<? extends LibraryFeature> className, @NonNull TemplateParameterSubstitutionHelper helper) {
        className2helper.put(className, helper);
    }

    public static @Nullable TemplateParameterSubstitutionHelper getHelper(@NonNull Class<? extends LibraryFeature> className) {
        return className2helper.get(className);
    }

    private static class CollectionCollectHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionCollectHelper() {
        }

        @Override
        public @Nullable Type resolveBodyType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type bodyType;
            LoopExp loopExp = (LoopExp)callExp;
            OCLExpression body = loopExp.getOwnedBody();
            Type asType = body != null ? body.getType() : null;
            Type type = bodyType = asType != null ? PivotUtilInternal.getNonLambdaType(asType) : null;
            if (bodyType != null) {
                @NonNull Type elementType = bodyType;
                while (elementType instanceof CollectionType) {
                    Type elementType2 = ((CollectionType)elementType).getElementType();
                    if (elementType2 == null) continue;
                    elementType = elementType2;
                }
                return elementType;
            }
            return returnType;
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type bodyType;
            LoopExp loopExp = (LoopExp)callExp;
            OCLExpression body = loopExp.getOwnedBody();
            Type asType = body != null ? body.getType() : null;
            Type type = bodyType = asType != null ? PivotUtilInternal.getNonLambdaType(asType) : null;
            if (bodyType != null) {
                @NonNull Type elementType = bodyType;
                while (elementType instanceof CollectionType) {
                    Type elementType2 = ((CollectionType)elementType).getElementType();
                    if (elementType2 == null) continue;
                    elementType = elementType2;
                }
                boolean isOrdered = returnType instanceof CollectionType && ((CollectionType)returnType).isOrdered();
                boolean isNullFree = asType instanceof CollectionType && ((CollectionType)asType).isIsNullFree();
                boolean isRequired = !(asType instanceof CollectionType) && body != null && body.isIsRequired();
                returnType = metamodelManager.getCollectionType(isOrdered, false, elementType, isNullFree || isRequired, null, null);
            }
            return returnType;
        }
    }

    private static class CollectionFlattenHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionFlattenHelper() {
        }

        @Override
        public void resolveUnmodeledTemplateParameterSubstitutions(@NonNull TemplateParameterSubstitutionVisitor templateParameterSubstitutions, @NonNull CallExp callExp) {
            Type elementType = callExp.getOwnedSource().getType();
            while (elementType instanceof CollectionType) {
                elementType = ((CollectionType)elementType).getElementType();
            }
            templateParameterSubstitutions.put(1, elementType);
        }
    }

    private static class CollectionSourceHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionSourceHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
                Type sourceType = ownedSource.getType();
                CollectionType collectionType = (CollectionType)returnType;
                if (sourceType instanceof CollectionType && ((CollectionType)sourceType).isIsNullFree() && !collectionType.isIsNullFree()) {
                    @NonNull Type elementType = collectionType.getElementType();
                    returnType = metamodelManager.getCollectionType(collectionType.isOrdered(), collectionType.isUnique(), elementType, true, collectionType.getLowerValue(), collectionType.getUpperValue());
                }
            }
            return returnType;
        }
    }
}

