/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Port;
import org.polarsys.chess.service.internal.Activator;

public class CHESSInternalEditorUtils {
    public static List<View> getDiagramAllVisiblePort(View diagram) {
        List<View> list = new ArrayList<View>();
        list = CHESSInternalEditorUtils.getDiagramAllVisiblePortRecur(list, diagram);
        return list;
    }

    public static List<View> getDiagramAllVisiblePortRecur(List<View> list, View view) {
        for (Object v : view.getVisibleChildren()) {
            if (!(v instanceof View)) continue;
            if (((View)v).getElement() instanceof Port) {
                list.add((View)v);
            }
            CHESSInternalEditorUtils.getDiagramAllVisiblePortRecur(list, (View)v);
        }
        return list;
    }

    public static IEditorPart getEditor() {
        IEditorPart editor = null;
        try {
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (Exception e) {
            Activator.error("Editor not found", e);
        }
        return editor;
    }

    public static int StatusDialog(EditorPart editor, String dialogTitle, String dialogMessage, IStatus status) {
        ErrorDialog errDlg = new ErrorDialog(editor.getSite().getShell(), dialogTitle, dialogMessage, status, 4){

            protected void buttonPressed(int id) {
                if (id == 2) {
                    id = 0;
                }
                if (id == 3) {
                    this.setReturnCode(5);
                    this.close();
                } else {
                    super.buttonPressed(id);
                }
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                this.createDetailsButton(parent);
            }
        };
        return errDlg.open();
    }

    public static MessageDialog showYesNoDialog(EditorPart editor, String dialogTitle, String dialogMessage) {
        MessageDialog md = new MessageDialog(editor.getSite().getShell(), dialogTitle, null, dialogMessage, 5, new String[]{"Yes", "No"}, 0);
        md.setBlockOnOpen(true);
        return md;
    }
}

