/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISecondarySaveableSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.progress.IJobRunnable;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SaveableHelper {
    public static final int USER_RESPONSE = -1;
    private static int AutomatedResponse = -1;

    public static void testSetAutomatedResponse(int response) {
        AutomatedResponse = response;
    }

    public static int testGetAutomatedResponse() {
        return AutomatedResponse;
    }

    public static boolean savePart(ISaveablePart saveable, IWorkbenchPart part, IWorkbenchWindow window, boolean confirm) {
        if (!saveable.isDirty()) {
            return true;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                if (saveable instanceof ISaveablePart2) {
                    choice = ((ISaveablePart2)saveable).promptToSaveOnClose();
                }
                if (choice == -1 || choice == 3) {
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)LegacyActionTools.escapeMnemonics((String)part.getTitle()));
                    MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, 0, new String[]{WorkbenchMessages.SaveableHelper_Save, WorkbenchMessages.SaveableHelper_Dont_Save, WorkbenchMessages.SaveableHelper_Cancel}){

                        protected int getShellStyle() {
                            return super.getShellStyle() | 0x10000000;
                        }
                    };
                    choice = d.open();
                }
            }
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        if (saveable instanceof ISaveablesSource) {
            return SaveableHelper.saveModels((ISaveablesSource)((Object)saveable), window, confirm);
        }
        IRunnableWithProgress progressOp = monitor -> {
            EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
            saveable.doSave(monitorWrap);
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp, window);
    }

    private static boolean saveModels(ISaveablesSource modelSource, IWorkbenchWindow window, boolean confirm) {
        ArrayList<Saveable> dirtyModels = new ArrayList<Saveable>();
        Saveable[] saveableArray = modelSource.getActiveSaveables();
        int n = saveableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (model.isDirty()) {
                dirtyModels.add(model);
            }
            ++n2;
        }
        if (dirtyModels.isEmpty()) {
            return true;
        }
        IRunnableWithProgress progressOp = monitor -> {
            EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitorWrap, (String)WorkbenchMessages.Save, (int)dirtyModels.size());
            try {
                for (Saveable model : dirtyModels) {
                    if (!model.isDirty()) {
                        subMonitor.worked(1);
                        continue;
                    }
                    SaveableHelper.doSaveModel(model, (IProgressMonitor)subMonitor.split(1), window, confirm);
                }
            }
            finally {
                monitorWrap.done();
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp, window);
    }

    static int savePart(ISaveablePart2 saveable, IWorkbenchWindow window, boolean confirm) {
        IRunnableWithProgress progressOp;
        if (!saveable.isDirty()) {
            return 0;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                choice = saveable.promptToSaveOnClose();
            }
            if (choice != 0) {
                return choice == -1 ? 3 : choice;
            }
        }
        if (!SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp = monitor -> {
            EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
            saveable.doSave(monitorWrap);
        }, window)) {
            return 2;
        }
        return 0;
    }

    static boolean runProgressMonitorOperation(String opName, IRunnableWithProgress progressOp, IRunnableContext runnableContext) {
        boolean[] success = new boolean[1];
        IRunnableWithProgress runnable = monitor -> {
            progressOp.run(monitor);
            if (!monitor.isCanceled()) {
                blArray[0] = true;
            }
        };
        try {
            runnableContext.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            String title = NLS.bind((String)WorkbenchMessages.EditorManager_operationFailed, (Object)opName);
            Throwable targetExc = e.getTargetException();
            WorkbenchPlugin.log(title, (IStatus)new Status(2, "org.eclipse.ui", 0, title, targetExc));
            StatusUtil.handleStatus(title, targetExc, 2);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
        return success[0];
    }

    public static boolean needsSave(ISaveablesSource modelSource) {
        Saveable[] saveableArray = modelSource.getActiveSaveables();
        int n = saveableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (model.isDirty() && !model.isSavingInBackground()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doSaveModel(final Saveable model, IProgressMonitor progressMonitor, final IShellProvider shellProvider, boolean blockUntilSaved) {
        block11: {
            block12: {
                Job backgroundSaveJob = model.getBackgroundSaveJob();
                if (backgroundSaveJob == null) break block11;
                boolean canceled = SaveableHelper.waitForBackgroundSaveJob(model);
                if (!canceled) break block12;
                progressMonitor.setCanceled(true);
                progressMonitor.done();
                return;
            }
            if (model.isDirty()) break block11;
            progressMonitor.done();
            return;
        }
        try {
            IJobRunnable[] backgroundSaveRunnable;
            block14: {
                block15: {
                    SubMonitor subMonitor;
                    block13: {
                        backgroundSaveRunnable = new IJobRunnable[1];
                        subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
                        backgroundSaveRunnable[0] = model.doSave((IProgressMonitor)subMonitor.split(2), shellProvider);
                        if (backgroundSaveRunnable[0] != null) break block13;
                        progressMonitor.done();
                        return;
                    }
                    if (!blockUntilSaved) break block14;
                    IStatus result = backgroundSaveRunnable[0].run((IProgressMonitor)subMonitor.split(1));
                    if (result.isOK()) break block15;
                    StatusUtil.handleStatus(result, 2);
                    progressMonitor.setCanceled(true);
                }
                progressMonitor.done();
                return;
            }
            try {
                IWorkbenchPart[] parts;
                Job saveJob = new Job(NLS.bind((String)WorkbenchMessages.EditorManager_backgroundSaveJobName, (Object)model.getName())){

                    public boolean belongsTo(Object family) {
                        if (family instanceof DynamicFamily) {
                            return ((DynamicFamily)family).contains(model);
                        }
                        return family.equals(model);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        return backgroundSaveRunnable[0].run(monitor);
                    }
                };
                model.setBackgroundSaveJob(saveJob);
                SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
                IWorkbenchPart[] iWorkbenchPartArray = parts = saveablesList.getPartsForSaveable(model);
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPart workbenchPart = iWorkbenchPartArray[n2];
                    IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)Adapters.adapt((Object)workbenchPart.getSite(), IWorkbenchSiteProgressService.class);
                    progressService.showBusyForFamily(model);
                    ++n2;
                }
                model.disableUI(parts, blockUntilSaved);
                saveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        model.setBackgroundSaveJob(null);
                        shellProvider.getShell().getDisplay().asyncExec(() -> {
                            SaveableHelper.notifySaveAction(parts);
                            model.enableUI(parts);
                        });
                    }
                });
                saveJob.schedule();
                SaveableHelper.notifySaveAction(parts);
                return;
            }
            catch (CoreException e) {
                StatusUtil.handleStatus(e.getStatus(), 2);
                progressMonitor.setCanceled(true);
                return;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            progressMonitor.done();
        }
    }

    private static void notifySaveAction(IWorkbenchPart[] parts) {
        HashSet<IWorkbenchWindow> wwindows = new HashSet<IWorkbenchWindow>();
        IWorkbenchPart[] iWorkbenchPartArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPart part = iWorkbenchPartArray[n2];
            wwindows.add(part.getSite().getWorkbenchWindow());
            ++n2;
        }
        for (IWorkbenchWindow iWorkbenchWindow : wwindows) {
            WorkbenchWindow wwin = (WorkbenchWindow)iWorkbenchWindow;
            wwin.fireBackgroundSaveStarted();
        }
    }

    private static boolean waitForBackgroundSaveJob(Saveable model) {
        ArrayList<Saveable> models = new ArrayList<Saveable>();
        models.add(model);
        return SaveableHelper.waitForBackgroundSaveJobs(models);
    }

    public static boolean waitForBackgroundSaveJobs(List modelsToSave) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> Job.getJobManager().join((Object)new DynamicFamily((Collection<?>)modelsToSave), monitor));
        }
        catch (InvocationTargetException e) {
            StatusUtil.handleStatus(e, 3);
        }
        catch (InterruptedException e) {
            return true;
        }
        Iterator it = modelsToSave.iterator();
        while (it.hasNext()) {
            Saveable model = (Saveable)it.next();
            if (model.isDirty()) continue;
            it.remove();
        }
        return false;
    }

    public static ISaveablePart getSaveable(Object o) {
        return (ISaveablePart)Adapters.adapt((Object)o, ISaveablePart.class);
    }

    public static boolean isSaveable(Object o) {
        return SaveableHelper.getSaveable(o) != null;
    }

    public static ISaveablePart2 getSaveable2(Object o) {
        ISaveablePart saveable = SaveableHelper.getSaveable(o);
        if (saveable instanceof ISaveablePart2) {
            return (ISaveablePart2)saveable;
        }
        return (ISaveablePart2)Adapters.adapt((Object)o, ISaveablePart2.class);
    }

    public static boolean isSaveable2(Object o) {
        return SaveableHelper.getSaveable2(o) != null;
    }

    public static boolean isDirtyStateSupported(IWorkbenchPart part) {
        if (part instanceof ISecondarySaveableSource) {
            return ((ISecondarySaveableSource)((Object)part)).isDirtyStateSupported();
        }
        return SaveableHelper.isSaveable(part);
    }

    private static class DynamicFamily
    extends HashSet<Object> {
        private static final long serialVersionUID = 1L;

        public DynamicFamily(Collection<?> collection) {
            super(collection);
        }
    }
}

