/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataAtSizeProvider;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.StrictChecks;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.image.ImageColorTransformer;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    private boolean isInitialized;
    private boolean isDestroyed;
    GC memGC;
    private final AbstractImageProviderWrapper imageProvider;
    private int styleFlag = 0;
    private RGB backgroundColor;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private List<Consumer<Image>> onDisposeListeners;
    private final ImageHandleManager imageHandleManager = new ImageHandleManager();
    private final HandleAtSize lastRequestedHandle = new HandleAtSize();

    private Image(Device device, int type, long handle, int nativeZoom) {
        super(device);
        this.type = type;
        this.imageProvider = new ExistingImageHandleProviderWrapper(handle, nativeZoom);
        this.isInitialized = true;
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.imageProvider = new PlainImageProviderWrapper(width, height);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        device = this.device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        this.type = srcImage.type;
        this.styleFlag = srcImage.styleFlag | flag;
        this.imageProvider = srcImage.imageProvider.createCopy(this);
        block0 : switch (flag) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        for (ImageHandle imageHandle : srcImage.imageHandleManager.getAllImageHandles()) {
                            Rectangle rect = imageHandle.bounds();
                            long srcImageHandle = imageHandle.handle();
                            long hDC = device.internal_new_GC(null);
                            long hdcSource = OS.CreateCompatibleDC(hDC);
                            long hdcDest = OS.CreateCompatibleDC(hDC);
                            long hOldSrc = OS.SelectObject(hdcSource, srcImageHandle);
                            BITMAP bm = new BITMAP();
                            OS.GetObject(srcImageHandle, BITMAP.sizeof, bm);
                            InternalImageHandle imageMetadata = this.imageHandleManager.getOrCreate(imageHandle.zoom(), () -> new DestroyableImageHandle(OS.CreateCompatibleBitmap(hdcSource, rectangle.width, bITMAP.bmBits != 0L ? -rectangle.height : rectangle.height), imageHandle.zoom(), imageHandle.transparentPixel()));
                            if (imageMetadata.handle == 0L) {
                                SWT.error(2);
                            }
                            long hOldDest = OS.SelectObject(hdcDest, imageMetadata.handle);
                            OS.BitBlt(hdcDest, 0, 0, rect.width, rect.height, hdcSource, 0, 0, 0xCC0020);
                            OS.SelectObject(hdcSource, hOldSrc);
                            OS.SelectObject(hdcDest, hOldDest);
                            OS.DeleteDC(hdcSource);
                            OS.DeleteDC(hdcDest);
                            device.internal_dispose_GC(hDC, null);
                        }
                        break block0;
                    }
                    case 1: {
                        for (ImageHandle imageHandle : srcImage.imageHandleManager.getAllImageHandles()) {
                            Rectangle rect = imageHandle.bounds();
                            InternalImageHandle imageMetadata = this.imageHandleManager.getOrCreate(imageHandle.zoom(), () -> new DestroyableImageHandle(OS.CopyImage(imageHandle.handle(), 1, rectangle.width, rectangle.height, 0), imageHandle.zoom(), imageHandle.transparentPixel()));
                            if (imageMetadata.handle != 0L) continue;
                            SWT.error(2);
                        }
                        break block0;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                for (ImageHandle imageHandle : srcImage.imageHandleManager.getAllImageHandles()) {
                    Rectangle rect = imageHandle.bounds();
                    ImageData data = srcImage.getImageData(imageHandle.zoom());
                    ImageData newData = this.applyDisableImageData(data, rect.height, rect.width);
                    this.imageHandleManager.getOrCreate(imageHandle.zoom(), () -> this.init(newData, imageHandle.zoom()));
                }
                break;
            }
            case 2: {
                for (ImageHandle imageHandle : srcImage.imageHandleManager.getAllImageHandles()) {
                    Rectangle rect = imageHandle.bounds();
                    ImageData data = srcImage.getImageData(imageHandle.zoom());
                    ImageData newData = this.applyGrayImageData(data, rect.height, rect.width);
                    this.imageHandleManager.getOrCreate(imageHandle.zoom(), () -> this.init(newData, imageHandle.zoom()));
                }
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    @Deprecated(since="2025-06", forRemoval=true)
    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.imageProvider = new PlainImageProviderWrapper(bounds.width, bounds.height);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageData data) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.imageProvider = new PlainImageDataProviderWrapper(data);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    private Image(Device device, ImageData data, int zoom) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.imageProvider = new PlainImageDataProviderWrapper(data, zoom);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        this.imageProvider = new MaskedImageDataProviderWrapper(source, mask);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, InputStream stream) {
        super(device);
        if (stream == null) {
            SWT.error(4);
        }
        this.imageProvider = new ImageDataLoaderStreamProviderWrapper(stream);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.imageProvider = new ImageFileNameProviderWrapper(zoom -> {
            if (zoom == 100) {
                return filename;
            }
            return null;
        });
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageProvider = new ImageFileNameProviderWrapper(imageFileNameProvider);
        if (imageFileNameProvider.getImagePath(100) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(imageFileNameProvider) + "] returns null fileName at 100% zoom.");
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageProvider = new ImageDataProviderWrapper(imageDataProvider);
        if (imageDataProvider.getImageData(100) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(imageDataProvider) + "] returns null ImageData at 100% zoom.");
        }
        StrictChecks.runIfStrictChecksEnabled(() -> DPIUtil.validateLinearScaling(imageDataProvider));
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Image(Device device, ImageGcDrawer imageGcDrawer, int width, int height) {
        super(device);
        this.imageProvider = new ImageGcDrawerWrapper(imageGcDrawer, width, height);
        this.init();
    }

    private ImageData adaptImageDataIfDisabledOrGray(ImageData data) {
        ImageData returnImageData = null;
        switch (this.styleFlag) {
            case 1: {
                ImageData newData;
                returnImageData = newData = this.applyDisableImageData(data, data.height, data.width);
                break;
            }
            case 2: {
                ImageData newData;
                returnImageData = newData = this.applyGrayImageData(data, data.height, data.width);
                break;
            }
            default: {
                returnImageData = data;
            }
        }
        return returnImageData;
    }

    @Override
    void init() {
        super.init();
        this.isInitialized = true;
    }

    private ImageData applyDisableImageData(ImageData data, int height, int width) {
        PaletteData palette = data.palette;
        ImageData newData = new ImageData(width, height, 32, new PaletteData(255, 65280, 0xFF0000));
        newData.alpha = data.alpha;
        newData.alphaData = data.alphaData;
        newData.maskData = data.maskData;
        newData.maskPad = data.maskPad;
        if (data.transparentPixel != -1) {
            newData.transparentPixel = 0;
        }
        int[] scanline = new int[width];
        int[] maskScanline = null;
        ImageData mask = null;
        if (data.maskData != null) {
            mask = data.getTransparencyMask();
        }
        if (mask != null) {
            maskScanline = new int[width];
        }
        int redMask = palette.redMask;
        int greenMask = palette.greenMask;
        int blueMask = palette.blueMask;
        int redShift = palette.redShift;
        int greenShift = palette.greenShift;
        int blueShift = palette.blueShift;
        int y = 0;
        while (y < height) {
            data.getPixels(0, y, width, scanline, 0);
            if (mask != null) {
                mask.getPixels(0, y, width, maskScanline, 0);
            }
            int x = 0;
            while (x < width) {
                int pixel = scanline[x];
                if (!(data.transparentPixel != -1 && pixel == data.transparentPixel || mask != null && maskScanline[x] == 0)) {
                    int blue;
                    int green;
                    int red;
                    if (palette.isDirect) {
                        red = pixel & redMask;
                        red = redShift < 0 ? red >>> -redShift : red << redShift;
                        green = pixel & greenMask;
                        green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                        blue = pixel & blueMask;
                        blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                    } else {
                        red = palette.colors[pixel].red;
                        green = palette.colors[pixel].green;
                        blue = palette.colors[pixel].blue;
                    }
                    RGBA result = ImageColorTransformer.DEFAULT_DISABLED_IMAGE_TRANSFORMER.adaptPixelValue(red, green, blue, data.getAlpha(x, y));
                    newData.setAlpha(x, y, result.alpha);
                    newData.setPixel(x, y, newData.palette.getPixel(result.rgb));
                }
                ++x;
            }
            ++y;
        }
        return newData;
    }

    private ImageData applyGrayImageData(ImageData data, int pHeight, int pWidth) {
        PaletteData palette = data.palette;
        ImageData newData = data;
        if (!palette.isDirect) {
            RGB[] rgbs = palette.getRGBs();
            int i = 0;
            while (i < rgbs.length) {
                if (data.transparentPixel != i) {
                    int intensity;
                    RGB color = rgbs[i];
                    int red = color.red;
                    int green = color.green;
                    int blue = color.blue;
                    color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                    color.red = color.blue;
                }
                ++i;
            }
            newData.palette = new PaletteData(rgbs);
        } else {
            RGB[] rgbs = new RGB[256];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(i, i, i);
                ++i;
            }
            newData = new ImageData(pWidth, pHeight, 8, new PaletteData(rgbs));
            newData.alpha = data.alpha;
            newData.alphaData = data.alphaData;
            newData.maskData = data.maskData;
            newData.maskPad = data.maskPad;
            if (data.transparentPixel != -1) {
                newData.transparentPixel = 254;
            }
            int[] scanline = new int[pWidth];
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int redShift = palette.redShift;
            int greenShift = palette.greenShift;
            int blueShift = palette.blueShift;
            int y = 0;
            while (y < pHeight) {
                int offset = y * newData.bytesPerLine;
                data.getPixels(0, y, pWidth, scanline, 0);
                int x = 0;
                while (x < pWidth) {
                    int pixel = scanline[x];
                    if (pixel != data.transparentPixel) {
                        int red = pixel & redMask;
                        red = redShift < 0 ? red >>> -redShift : red << redShift;
                        int green = pixel & greenMask;
                        green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                        int blue = pixel & blueMask;
                        blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                        int intensity = red + red + green + green + green + green + green + blue >> 3;
                        if (newData.transparentPixel == intensity) {
                            intensity = 255;
                        }
                        newData.data[offset] = (byte)intensity;
                    } else {
                        newData.data[offset] = -2;
                    }
                    ++offset;
                    ++x;
                }
                ++y;
            }
        }
        return newData;
    }

    private InternalImageHandle getImageMetadata(ZoomContext zoomContext) {
        int targetZoom = zoomContext.targetZoom();
        return this.imageHandleManager.getOrCreate(targetZoom, () -> this.imageProvider.newImageHandle(zoomContext));
    }

    public static long win32_getHandle(Image image, int zoom) {
        return image.getHandle(zoom, zoom).handle();
    }

    ImageHandle getHandle(int targetZoom, int nativeZoom) {
        if (this.isDisposed()) {
            return null;
        }
        ZoomContext zoomContext = this.imageProvider.getFittingZoomContext(targetZoom, nativeZoom);
        return this.getImageMetadata(zoomContext);
    }

    void executeOnImageHandleAtBestFittingSize(Consumer<ImageHandle> handleAtSizeConsumer, int widthHint, int heightHint) {
        ImageHandle imageHandle = this.lastRequestedHandle.refresh(widthHint, heightHint);
        handleAtSizeConsumer.accept(imageHandle);
    }

    public static void drawAtSize(GC gc, ImageData imageData, int width, int height) {
        StrictChecks.runWithStrictChecksDisabled(() -> {
            Image imageToDraw = new Image(gC.device, zoom -> imageData);
            gc.drawImage(imageToDraw, 0, 0, imageData.width, imageData.height, 0, 0, width, height, false);
            imageToDraw.dispose();
        });
    }

    long[] createGdipImage(Integer zoom) {
        ImageHandle handle = this.getHandle(zoom, zoom);
        return this.createGdipImageFromHandle(handle);
    }

    long[] createGdipImageFromHandle(ImageHandle imageHandle) {
        long handle = imageHandle.handle();
        int transparentPixel = imageHandle.transparentPixel();
        switch (this.type) {
            case 0: {
                boolean hasAlpha;
                BITMAP bm = new BITMAP();
                OS.GetObject(handle, BITMAP.sizeof, bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                boolean isDib = bm.bmBits != 0L;
                boolean bl = hasAlpha = isDib && depth == 32;
                if (hasAlpha || transparentPixel != -1) {
                    int imgWidth = bm.bmWidth;
                    int imgHeight = bm.bmHeight;
                    long hDC = this.device.internal_new_GC(null);
                    if (hDC == 0L) {
                        SWT.error(2);
                    }
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    this.device.internal_dispose_GC(hDC, null);
                    if (srcHdc == 0L) {
                        SWT.error(2);
                    }
                    if (memHdc == 0L) {
                        SWT.error(2);
                    }
                    long oldSrcBitmap = OS.SelectObject(srcHdc, handle);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
                    long hHeap = OS.GetProcessHeap();
                    long pixels = OS.HeapAlloc(hHeap, 8, sizeInBytes);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    byte red = 0;
                    byte green = 0;
                    byte blue = 0;
                    if (hasAlpha) {
                        OS.MoveMemory(pixels, bm.bmBits, sizeInBytes);
                    } else {
                        if (bm.bmBitsPixel <= 8) {
                            byte[] color = new byte[4];
                            OS.GetDIBColorTable(srcHdc, transparentPixel, 1, color);
                            blue = color[0];
                            green = color[1];
                            red = color[2];
                        } else {
                            switch (bm.bmBitsPixel) {
                                case 16: {
                                    int blueMask = 31;
                                    int blueShift = ImageData.getChannelShift(blueMask);
                                    byte[] blues = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(blueMask, blueShift)];
                                    blue = blues[(transparentPixel & blueMask) >> blueShift];
                                    int greenMask = 992;
                                    int greenShift = ImageData.getChannelShift(greenMask);
                                    byte[] greens = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(greenMask, greenShift)];
                                    green = greens[(transparentPixel & greenMask) >> greenShift];
                                    int redMask = 31744;
                                    int redShift = ImageData.getChannelShift(redMask);
                                    byte[] reds = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(redMask, redShift)];
                                    red = reds[(transparentPixel & redMask) >> redShift];
                                    break;
                                }
                                case 24: {
                                    blue = (byte)((transparentPixel & 0xFF0000) >> 16);
                                    green = (byte)((transparentPixel & 0xFF00) >> 8);
                                    red = (byte)(transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    blue = (byte)((transparentPixel & 0xFF000000) >>> 24);
                                    green = (byte)((transparentPixel & 0xFF0000) >> 16);
                                    red = (byte)((transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                        byte[] srcData = new byte[sizeInBytes];
                        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
                        int y = 0;
                        int dp = 0;
                        while (y < imgHeight) {
                            int x = 0;
                            while (x < imgWidth) {
                                srcData[dp + 3] = srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red ? 0 : -1;
                                dp += 4;
                                ++x;
                            }
                            ++y;
                        }
                        OS.MoveMemory(pixels, srcData, sizeInBytes);
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(srcHdc);
                    OS.DeleteObject(memHdc);
                    OS.DeleteObject(memDib);
                    int pixelFormat = hasAlpha ? 925707 : 2498570;
                    return new long[]{Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, pixelFormat, pixels), pixels};
                }
                long[] lArray = new long[2];
                lArray[0] = Gdip.Bitmap_new(handle, 0L);
                return lArray;
            }
            case 1: {
                ICONINFO iconInfo = new ICONINFO();
                OS.GetIconInfo(handle, iconInfo);
                long hBitmap = iconInfo.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = iconInfo.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                int imgWidth = bm.bmWidth;
                int imgHeight = hBitmap == iconInfo.hbmMask ? bm.bmHeight / 2 : bm.bmHeight;
                long img = 0L;
                long pixels = 0L;
                if (imgWidth > imgHeight || bm.bmBitsPixel == 32) {
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, hBitmap == iconInfo.hbmMask ? imgHeight : 0, 0xCC0020);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(memHdc);
                    byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                    OS.MoveMemory(srcData, dibBM.bmBits, srcData.length);
                    OS.DeleteObject(memDib);
                    OS.SelectObject(srcHdc, iconInfo.hbmMask);
                    int y = 0;
                    int dp = 3;
                    while (y < imgHeight) {
                        int x = 0;
                        while (x < imgWidth) {
                            if (srcData[dp] == 0) {
                                srcData[dp] = OS.GetPixel(srcHdc, x, y) != 0 ? 0 : -1;
                            }
                            dp += 4;
                            ++x;
                        }
                        ++y;
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.DeleteObject(srcHdc);
                    this.device.internal_dispose_GC(hDC, null);
                    long hHeap = OS.GetProcessHeap();
                    pixels = OS.HeapAlloc(hHeap, 8, srcData.length);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(pixels, srcData, srcData.length);
                    img = Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, 2498570, pixels);
                } else {
                    img = Gdip.Bitmap_new(handle);
                }
                if (iconInfo.hbmColor != 0L) {
                    OS.DeleteObject(iconInfo.hbmColor);
                }
                if (iconInfo.hbmMask != 0L) {
                    OS.DeleteObject(iconInfo.hbmMask);
                }
                return new long[]{img, pixels};
            }
        }
        SWT.error(40);
        return null;
    }

    void addOnDisposeListener(Consumer<Image> onDisposeListener) {
        if (this.onDisposeListeners == null) {
            this.onDisposeListeners = new ArrayList<Consumer<Image>>();
        }
        this.onDisposeListeners.add(onDisposeListener);
    }

    void removeOnDisposeListener(Consumer<Image> onDisposeListener) {
        if (this.onDisposeListeners == null) {
            return;
        }
        this.onDisposeListeners.remove(onDisposeListener);
    }

    @Override
    public void dispose() {
        if (this.onDisposeListeners != null) {
            this.onDisposeListeners.forEach(listener -> listener.accept(this));
            this.onDisposeListeners.clear();
        }
        super.dispose();
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.isDestroyed = true;
        this.destroyHandles();
        this.memGC = null;
    }

    private void destroyHandles() {
        this.lastRequestedHandle.destroy();
        this.imageHandleManager.destroyHandles(__ -> true);
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.imageHandleManager.destroyHandles(zoom -> !zoomLevels.contains(zoom) && !this.imageProvider.getPreservedZoomLevels().contains(zoom));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device) {
            return false;
        }
        return this.styleFlag == image.styleFlag && this.imageProvider.equals(image.imageProvider);
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.getImageData().transparentPixel == -1) {
            return null;
        }
        if (this.backgroundColor != null) {
            return Color.win32_new(this.device, this.backgroundColor.blue << 16 | this.backgroundColor.green << 8 | this.backgroundColor.red);
        }
        ImageHandle imageHandle = this.getHandle(100, 100);
        if (imageHandle.transparentPixel() == -1) {
            return null;
        }
        long hDC = this.device.internal_new_GC(null);
        long handle = imageHandle.handle();
        int transparentPixel = imageHandle.transparentPixel();
        BITMAP bm = new BITMAP();
        OS.GetObject(handle, BITMAP.sizeof, bm);
        long hdcMem = OS.CreateCompatibleDC(hDC);
        long hOldObject = OS.SelectObject(hdcMem, handle);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (bm.bmBitsPixel <= 8) {
            byte[] color = new byte[4];
            OS.GetDIBColorTable(hdcMem, transparentPixel, 1, color);
            blue = color[0] & 0xFF;
            green = color[1] & 0xFF;
            red = color[2] & 0xFF;
        } else {
            switch (bm.bmBitsPixel) {
                case 16: {
                    blue = (transparentPixel & 0x1F) << 3;
                    green = (transparentPixel & 0x3E0) >> 2;
                    red = (transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    blue = (transparentPixel & 0xFF0000) >> 16;
                    green = (transparentPixel & 0xFF00) >> 8;
                    red = transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    blue = (transparentPixel & 0xFF000000) >>> 24;
                    green = (transparentPixel & 0xFF0000) >> 16;
                    red = (transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(hdcMem, hOldObject);
        OS.DeleteDC(hdcMem);
        this.device.internal_dispose_GC(hDC, null);
        return Color.win32_new(this.device, blue << 16 | green << 8 | red);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBounds(100);
    }

    Rectangle getBounds(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.imageHandleManager.contains(zoom)) {
            InternalImageHandle imageMetadata = this.imageHandleManager.get(zoom);
            Rectangle rectangle = new Rectangle(0, 0, imageMetadata.width(), imageMetadata.height());
            return Win32DPIUtils.scaleBounds(rectangle, zoom, imageMetadata.zoom());
        }
        return this.imageProvider.getBounds(zoom);
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public Rectangle getBoundsInPixels() {
        return this.applyUsingAnyHandle(ImageHandle::bounds);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    public ImageData getImageData(int zoom) {
        InternalImageHandle imageHandle;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((imageHandle = this.imageHandleManager.get(zoom)) != null) {
            return imageHandle.getImageData();
        }
        return this.imageProvider.newImageData(zoom);
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public ImageData getImageDataAtCurrentZoom() {
        return this.applyUsingAnyHandle(InternalImageHandle::getImageData);
    }

    public int hashCode() {
        return this.imageProvider.hashCode();
    }

    static long createDIB(int width, int height, int depth) {
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        return OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
    }

    private static ImageData indexToIndex(ImageData src, int newDepth) {
        ImageData img = new ImageData(src.width, src.height, newDepth, src.palette);
        ImageData.blit(src.data, src.depth, src.bytesPerLine, src.getByteOrder(), src.width, src.height, img.data, img.depth, img.bytesPerLine, src.getByteOrder(), img.width, img.height, false, false);
        img.transparentPixel = src.transparentPixel;
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    private static ImageData indexToDirect(ImageData src, int newDepth, PaletteData newPalette, int newByteOrder) {
        ImageData img = new ImageData(src.width, src.height, newDepth, newPalette);
        RGB[] rgbs = src.palette.getRGBs();
        byte[] srcReds = new byte[rgbs.length];
        byte[] srcGreens = new byte[rgbs.length];
        byte[] srcBlues = new byte[rgbs.length];
        int j = 0;
        while (j < rgbs.length) {
            RGB rgb = rgbs[j];
            if (rgb != null) {
                srcReds[j] = (byte)rgb.red;
                srcGreens[j] = (byte)rgb.green;
                srcBlues[j] = (byte)rgb.blue;
            }
            ++j;
        }
        ImageData.blit(src.width, src.height, src.data, src.depth, src.bytesPerLine, src.getByteOrder(), srcReds, srcGreens, srcBlues, img.data, img.depth, img.bytesPerLine, newByteOrder, newPalette.redMask, newPalette.greenMask, newPalette.blueMask);
        if (src.transparentPixel != -1) {
            img.transparentPixel = newPalette.getPixel(src.palette.getRGB(src.transparentPixel));
        }
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    private static ImageData directToDirect(ImageData src, int newDepth, PaletteData newPalette, int newByteOrder) {
        ImageData img = new ImageData(src.width, src.height, newDepth, newPalette);
        ImageData.blit(src.data, src.depth, src.bytesPerLine, src.getByteOrder(), src.width, src.height, src.palette.redMask, src.palette.greenMask, src.palette.blueMask, img.data, img.depth, img.bytesPerLine, newByteOrder, img.width, img.height, img.palette.redMask, img.palette.greenMask, img.palette.blueMask, false, false);
        if (src.transparentPixel != -1) {
            img.transparentPixel = img.palette.getPixel(src.palette.getRGB(src.transparentPixel));
        }
        img.maskPad = src.maskPad;
        img.maskData = src.maskData;
        img.alpha = src.alpha;
        img.alphaData = src.alphaData;
        return img;
    }

    private static HandleForImageDataContainer init(Device device, ImageData i) {
        long[] pBits;
        long hDib;
        int g;
        boolean hasAlpha;
        if (i.depth == 2) {
            i = Image.indexToIndex(i, 4);
        }
        if (i.depth == 16 && !i.palette.isDirect) {
            PaletteData newPalette = new PaletteData(255, 65280, 0xFF0000);
            i = Image.indexToDirect(i, 24, newPalette, 1);
        }
        boolean bl = hasAlpha = i.alpha != -1 || i.alphaData != null;
        if (i.palette.isDirect) {
            PaletteData palette = i.palette;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int newDepth = i.depth;
            int newOrder = 1;
            PaletteData newPalette = null;
            if (hasAlpha) {
                newDepth = 32;
                newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            } else {
                switch (i.depth) {
                    case 8: {
                        int minDepth = ImageData.getChannelWidth(redMask, palette.redShift) + ImageData.getChannelWidth(greenMask, palette.greenShift) + ImageData.getChannelWidth(blueMask, palette.blueShift);
                        if (minDepth <= 16) {
                            newDepth = 16;
                            newOrder = 0;
                            newPalette = new PaletteData(31744, 992, 31);
                            break;
                        }
                        newDepth = 24;
                        newPalette = new PaletteData(255, 65280, 0xFF0000);
                        break;
                    }
                    case 16: {
                        newOrder = 0;
                        if (redMask == 31744 && greenMask == 992 && blueMask == 31) break;
                        newPalette = new PaletteData(31744, 992, 31);
                        break;
                    }
                    case 24: {
                        if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) break;
                        newPalette = new PaletteData(255, 65280, 0xFF0000);
                        break;
                    }
                    case 32: {
                        if (i.getTransparencyType() != 2) {
                            newDepth = 24;
                            newPalette = new PaletteData(255, 65280, 0xFF0000);
                            break;
                        }
                        if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) break;
                        newPalette = new PaletteData(65280, 0xFF0000, -16777216);
                        break;
                    }
                    default: {
                        SWT.error(38);
                    }
                }
            }
            if (newPalette != null) {
                i = Image.directToDirect(i, newDepth, newPalette, newOrder);
            }
        } else if (hasAlpha) {
            PaletteData newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            i = Image.indexToDirect(i, 32, newPalette, 1);
        }
        if (i.alpha != -1) {
            int alpha = i.alpha & 0xFF;
            byte[] data = i.data;
            dp = 0;
            while (dp < i.data.length) {
                int r = (data[dp] & 0xFF) * alpha + 128;
                r = r + (r >> 8) >> 8;
                int g2 = (data[dp + 1] & 0xFF) * alpha + 128;
                g2 = g2 + (g2 >> 8) >> 8;
                int b = (data[dp + 2] & 0xFF) * alpha + 128;
                b = b + (b >> 8) >> 8;
                data[dp] = (byte)b;
                data[dp + 1] = (byte)g2;
                data[dp + 2] = (byte)r;
                data[dp + 3] = (byte)alpha;
                dp += 4;
            }
        } else if (i.alphaData != null) {
            byte[] data = i.data;
            int ap = 0;
            dp = 0;
            while (dp < i.data.length) {
                int a = i.alphaData[ap] & 0xFF;
                int r = (data[dp] & 0xFF) * a + 128;
                r = r + (r >> 8) >> 8;
                g = (data[dp + 1] & 0xFF) * a + 128;
                g = g + (g >> 8) >> 8;
                int b = (data[dp + 2] & 0xFF) * a + 128;
                b = b + (b >> 8) >> 8;
                data[dp] = (byte)r;
                data[dp + 1] = (byte)g;
                data[dp + 2] = (byte)b;
                data[dp + 3] = (byte)a;
                ++ap;
                dp += 4;
            }
        }
        RGB[] rgbs = i.palette.getRGBs();
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = i.width;
        bmiHeader.biHeight = -i.height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)i.depth;
        bmiHeader.biCompression = 0;
        bmiHeader.biClrUsed = rgbs == null ? 0 : rgbs.length;
        byte[] bmi = i.palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof] : new byte[BITMAPINFOHEADER.sizeof + rgbs.length * 4];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        int offset = BITMAPINFOHEADER.sizeof;
        if (!i.palette.isDirect) {
            RGB[] minDepth = rgbs;
            int n = rgbs.length;
            g = 0;
            while (g < n) {
                RGB rgb = minDepth[g];
                bmi[offset] = (byte)rgb.blue;
                bmi[offset + 1] = (byte)rgb.green;
                bmi[offset + 2] = (byte)rgb.red;
                bmi[offset + 3] = 0;
                offset += 4;
                ++g;
            }
        }
        if ((hDib = OS.CreateDIBSection(0L, bmi, 0, pBits = new long[1], 0L, 0)) == 0L) {
            SWT.error(2);
        }
        byte[] data = i.data;
        if (i.scanlinePad != 4 && i.bytesPerLine % 4 != 0) {
            data = ImageData.convertPad(data, i.width, i.height, i.depth, i.scanlinePad, 4);
        }
        OS.MoveMemory(pBits[0], data, data.length);
        if (i.getTransparencyType() == 2) {
            long hDC = device.internal_new_GC(null);
            long hdcSrc = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcSrc, hDib);
            long hBitmap = OS.CreateCompatibleBitmap(hDC, i.width, i.height);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            long hdcDest = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcDest, hBitmap);
            OS.BitBlt(hdcDest, 0, 0, i.width, i.height, hdcSrc, 0, 0, 0xCC0020);
            device.internal_dispose_GC(hDC, null);
            byte[] maskData = ImageData.convertPad(i.maskData, i.width, i.height, 1, i.maskPad, 2);
            long hMask = OS.CreateBitmap(i.width, i.height, 1, 1, maskData);
            if (hMask == 0L) {
                SWT.error(2);
            }
            OS.SelectObject(hdcSrc, hMask);
            OS.PatBlt(hdcSrc, 0, 0, i.width, i.height, 0x550009);
            OS.DeleteDC(hdcSrc);
            OS.DeleteDC(hdcDest);
            OS.DeleteObject(hDib);
            return new HandleForImageDataContainer(1, i, new long[]{hBitmap, hMask});
        }
        return new HandleForImageDataContainer(0, i, new long[]{hDib});
    }

    private DestroyableImageHandle initIconHandle(Device device, ImageData source, ImageData mask, Integer zoom) {
        ImageData imageData = Image.applyMask(source, mask);
        HandleForImageDataContainer imageDataHandle = Image.init(device, imageData);
        return this.initIconHandle(imageDataHandle.handles, zoom);
    }

    private DestroyableImageHandle initIconHandle(long[] handles, int zoom) {
        ICONINFO info = new ICONINFO();
        info.fIcon = true;
        info.hbmColor = handles[0];
        info.hbmMask = handles[1];
        long hIcon = OS.CreateIconIndirect(info);
        if (hIcon == 0L) {
            SWT.error(2);
        }
        OS.DeleteObject(handles[0]);
        OS.DeleteObject(handles[1]);
        this.type = 1;
        return new DestroyableImageHandle(hIcon, zoom, -1);
    }

    private DestroyableImageHandle initBitmapHandle(ImageData imageData, long handle, Integer zoom) {
        this.type = 0;
        return new DestroyableImageHandle(handle, zoom, imageData.transparentPixel);
    }

    static long[] initIcon(Device device, ImageData source, ImageData mask) {
        ImageData imageData = Image.applyMask(source, mask);
        return Image.init((Device)device, (ImageData)imageData).handles;
    }

    /*
     * Unable to fully structure code
     */
    private static ImageData applyMask(ImageData source, ImageData mask) {
        block13: {
            block12: {
                blackIndex = 0;
                if (!source.palette.isDirect) break block12;
                imageData = new ImageData(source.width, source.height, source.depth, source.palette);
                break block13;
            }
            black = new RGB(0, 0, 0);
            rgbs = source.getRGBs();
            if (source.transparentPixel == -1) ** GOTO lbl27
            newRGBs = new RGB[rgbs.length];
            System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
            if (source.transparentPixel >= newRGBs.length) {
                rgbs = new RGB[source.transparentPixel + 1];
                System.arraycopy(newRGBs, 0, rgbs, 0, newRGBs.length);
                i = newRGBs.length;
                while (i <= source.transparentPixel) {
                    rgbs[i] = new RGB(0, 0, 0);
                    ++i;
                }
            } else {
                newRGBs[source.transparentPixel] = black;
                rgbs = newRGBs;
            }
            blackIndex = source.transparentPixel;
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            break block13;
            while (!rgbs[blackIndex].equals(black)) {
                ++blackIndex;
lbl27:
                // 2 sources

                if (blackIndex < rgbs.length) continue;
            }
            if (blackIndex == rgbs.length) {
                if (1 << source.depth > rgbs.length) {
                    newRGBs = new RGB[rgbs.length + 1];
                    System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                    newRGBs[rgbs.length] = black;
                    rgbs = newRGBs;
                } else {
                    blackIndex = -1;
                }
            }
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
        }
        if (blackIndex == -1) {
            System.arraycopy(source.data, 0, imageData.data, 0, imageData.data.length);
        } else {
            imagePixels = new int[imageData.width];
            maskPixels = new int[mask.width];
            y = 0;
            while (y < imageData.height) {
                source.getPixels(0, y, imageData.width, imagePixels, 0);
                mask.getPixels(0, y, mask.width, maskPixels, 0);
                i = 0;
                while (i < imagePixels.length) {
                    if (maskPixels[i] == 0) {
                        imagePixels[i] = blackIndex;
                    }
                    ++i;
                }
                imageData.setPixels(0, y, source.width, imagePixels, 0);
                ++y;
            }
        }
        imageData.maskPad = mask.scanlinePad;
        imageData.maskData = mask.data;
        return imageData;
    }

    private DestroyableImageHandle init(ImageData i, int zoom) {
        if (i == null) {
            SWT.error(4);
        }
        HandleForImageDataContainer imageDataHandle = Image.init(this.device, i);
        switch (imageDataHandle.type()) {
            case 1: {
                return this.initIconHandle(imageDataHandle.handles(), zoom);
            }
            case 0: {
                return this.initBitmapHandle(imageDataHandle.imageData(), imageDataHandle.handles()[0], zoom);
            }
        }
        SWT.error(5);
        return null;
    }

    @Override
    public long internal_new_GC(GCData data) {
        return this.imageProvider.configureGCData(data);
    }

    private long configureGC(GCData data, ZoomContext zoomContext) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        StrictChecks.runIfStrictChecksEnabled(() -> this.checkImageTypeForValidCustomDrawing(zoomContext.targetZoom()));
        long hDC = this.device.internal_new_GC(null);
        long imageDC = OS.CreateCompatibleDC(hDC);
        this.device.internal_dispose_GC(hDC, null);
        if (imageDC == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.nativeZoom = zoomContext.nativeZoom();
            data.imageZoom = zoomContext.targetZoom();
            data.image = this;
            data.font = SWTFontProvider.getSystemFont(this.device, zoomContext.nativeZoom());
        }
        return imageDC;
    }

    private void checkImageTypeForValidCustomDrawing(int zoom) {
        String replacementInfo = "It should be created with an ImageGcDrawer (see SWT Snippet 384).";
        if (this.imageProvider instanceof ImageDataProviderWrapper || this.imageProvider instanceof ImageFileNameProviderWrapper) {
            String message = "***WARNING: Image initialized with ImageDataProvider or ImageFileNameProvider is not supposed to be modified.";
            System.err.println(message + " " + replacementInfo);
        } else if (!(this.imageHandleManager.isEmpty() || this.imageHandleManager.getAllImageHandles().size() == 1 && this.imageHandleManager.contains(zoom))) {
            String message = "***WARNING: Images with handles created for multiple zooms should not be modified. ";
            System.err.println(message + " " + replacementInfo);
        }
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        OS.DeleteDC(hDC);
    }

    @Override
    public boolean isDisposed() {
        return !this.isInitialized || this.isDestroyed;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.backgroundColor = color.getRGB();
        this.imageHandleManager.getAllImageHandles().forEach(imageHandle -> imageHandle.setBackground(this.backgroundColor));
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + String.valueOf(this.imageHandleManager) + "}";
    }

    <T> T applyUsingAnyHandle(Function<InternalImageHandle, T> function) {
        if (this.imageHandleManager.isEmpty()) {
            DestroyableImageHandle temporaryHandle = this.imageProvider.newImageHandle(new ZoomContext(DPIUtil.getDeviceZoom(), DPIUtil.getNativeDeviceZoom()));
            try {
                T t = function.apply(temporaryHandle);
                return t;
            }
            finally {
                temporaryHandle.destroy();
            }
        }
        return function.apply(this.imageHandleManager.getAllImageHandles().get(0));
    }

    public static Image win32_new(Device device, int type, long handle, int nativeZoom) {
        return new Image(device, type, handle, nativeZoom);
    }

    private abstract class AbstractImageProviderWrapper {
        private AbstractImageProviderWrapper() {
        }

        protected abstract Rectangle getBounds(int var1);

        protected ZoomContext getFittingZoomContext(int targetZoom, int nativeZoom) {
            return new ZoomContext(targetZoom);
        }

        protected long configureGCData(GCData data) {
            return Image.this.configureGC(data, new ZoomContext(100));
        }

        public Collection<Integer> getPreservedZoomLevels() {
            return Collections.emptySet();
        }

        protected abstract DPIUtil.ElementAtZoom<ImageData> loadImageData(int var1);

        abstract ImageData newImageData(int var1);

        abstract AbstractImageProviderWrapper createCopy(Image var1);

        ImageData getScaledImageData(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> closestAvailableImageData = this.getClosestAvailableImageData(zoom);
            return DPIUtil.scaleImageData(Image.this.device, closestAvailableImageData.element(), zoom, closestAvailableImageData.zoom());
        }

        DPIUtil.ElementAtZoom<ImageData> getClosestAvailableImageData(int zoom) {
            TreeSet<Integer> availableZooms = new TreeSet<Integer>(Image.this.imageHandleManager.getAllZooms());
            int closestZoom = Optional.ofNullable(availableZooms.higher(zoom)).orElse(availableZooms.lower(zoom));
            return new DPIUtil.ElementAtZoom<ImageData>(Image.this.getImageMetadata(new ZoomContext(closestZoom)).getImageData(), closestZoom);
        }

        protected Optional<ImageData> loadImageDataAtExactSize(int width, int height) {
            return Optional.empty();
        }

        protected DestroyableImageHandle newImageHandle(ZoomContext zoomContext) {
            ImageData resizedData = Image.this.getImageData(zoomContext.targetZoom());
            return this.newImageHandle(resizedData, zoomContext);
        }

        protected final DestroyableImageHandle newImageHandle(ImageData data, ZoomContext zoomContext) {
            if (Image.this.type == 1 && data.getTransparencyType() != 2) {
                return Image.this.initIconHandle(Image.this.device, data, data.getTransparencyMask(), zoomContext.targetZoom());
            }
            return Image.this.init(data, zoomContext.targetZoom());
        }
    }

    private abstract class BaseImageProviderWrapper<T>
    extends DynamicImageProviderWrapper {
        private final Map<Integer, ImageData> cachedImageData;
        protected final T provider;

        BaseImageProviderWrapper(T provider, Class<T> expectedClass) {
            this.cachedImageData = new HashMap<Integer, ImageData>();
            this.checkProvider(provider, expectedClass);
            this.provider = provider;
        }

        @Override
        Object getProvider() {
            return this.provider;
        }

        @Override
        ImageData newImageData(int zoom) {
            Function<Integer, ImageData> imageDataRetrival = zoomToRetrieve -> {
                DestroyableImageHandle handle = this.initializeHandleFromSource((int)zoomToRetrieve);
                ImageData data = handle.getImageData();
                handle.destroy();
                return data;
            };
            return (ImageData)this.cachedImageData.computeIfAbsent(zoom, imageDataRetrival).clone();
        }

        @Override
        protected DestroyableImageHandle newImageHandle(ZoomContext zoomContext) {
            int targetZoom = zoomContext.targetZoom();
            ImageData cachedData = this.cachedImageData.remove(targetZoom);
            if (cachedData != null) {
                return Image.this.init(cachedData, targetZoom);
            }
            return this.initializeHandleFromSource(targetZoom);
        }

        private DestroyableImageHandle initializeHandleFromSource(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> imageDataAtZoom = this.loadImageData(zoom);
            ImageData imageData = DPIUtil.scaleImageData(Image.this.device, imageDataAtZoom.element(), zoom, imageDataAtZoom.zoom());
            imageData = Image.this.adaptImageDataIfDisabledOrGray(imageData);
            return Image.this.init(imageData, zoom);
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            ImageData imageData = Image.this.getImageData(zoom);
            return new Rectangle(0, 0, imageData.width, imageData.height);
        }
    }

    private class DestroyableImageHandle
    extends InternalImageHandle {
        private boolean isDisposed;

        DestroyableImageHandle(long handle, int zoom, int transparentPixel) {
            super(handle, zoom, transparentPixel);
        }

        @Override
        boolean isDisposed() {
            return this.isDisposed;
        }

        void destroy() {
            if (Image.this.type == 1) {
                OS.DestroyIcon(this.handle());
            } else {
                OS.DeleteObject(this.handle());
            }
            this.isDisposed = true;
        }
    }

    private static class DrawableWrapper
    implements Drawable {
        private final Image image;
        private final ZoomContext zoomContext;

        public DrawableWrapper(Image image, ZoomContext zoomContext) {
            this.image = image;
            this.zoomContext = zoomContext;
        }

        @Override
        public long internal_new_GC(GCData data) {
            return this.image.configureGC(data, this.zoomContext);
        }

        @Override
        public void internal_dispose_GC(long handle, GCData data) {
            this.image.internal_dispose_GC(handle, data);
        }
    }

    private abstract class DynamicImageProviderWrapper
    extends AbstractImageProviderWrapper {
        private DynamicImageProviderWrapper() {
        }

        abstract Object getProvider();

        protected void checkProvider(Object provider, Class<?> expectedClass) {
            if (provider == null) {
                SWT.error(4);
            }
            if (!expectedClass.isAssignableFrom(provider.getClass())) {
                SWT.error(5);
            }
        }

        public int hashCode() {
            return this.getProvider().hashCode();
        }

        public boolean equals(Object otherProvider) {
            if (otherProvider instanceof DynamicImageProviderWrapper) {
                DynamicImageProviderWrapper aip = (DynamicImageProviderWrapper)otherProvider;
                if (Objects.equals(this.getProvider(), aip.getProvider())) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ExistingImageHandleProviderWrapper
    extends AbstractImageProviderWrapper {
        private final int width;
        private final int height;
        private final long handle;
        private final int zoomForHandle;

        public ExistingImageHandleProviderWrapper(long handle, int zoomForHandle) {
            this.handle = handle;
            this.zoomForHandle = zoomForHandle;
            InternalImageHandle imageHandle = Image.this.imageHandleManager.getOrCreate(zoomForHandle, () -> new DestroyableImageHandle(handle, zoomForHandle, -1));
            ImageData baseData = imageHandle.getImageData();
            this.width = DPIUtil.pixelToPoint(baseData.width, zoomForHandle);
            this.height = DPIUtil.pixelToPoint(baseData.height, zoomForHandle);
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return Win32DPIUtils.pointToPixel(rectangle, zoom);
        }

        @Override
        ImageData newImageData(int zoom) {
            return this.getScaledImageData(zoom);
        }

        @Override
        AbstractImageProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ExistingImageHandleProviderWrapper(this.handle, this.zoomForHandle);
        }

        @Override
        public Collection<Integer> getPreservedZoomLevels() {
            return Collections.singleton(this.zoomForHandle);
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return this.getClosestAvailableImageData(zoom);
        }
    }

    private class HandleAtSize {
        private ImageHandle handleContainer = null;
        private DestroyableImageHandle temporaryHandleContainer = null;
        private int requestedWidth = -1;
        private int requestedHeight = -1;

        private HandleAtSize() {
        }

        public void destroy() {
            if (this.temporaryHandleContainer != null) {
                this.temporaryHandleContainer.destroy();
                this.temporaryHandleContainer = null;
            }
            this.handleContainer = null;
            this.requestedWidth = -1;
            this.requestedHeight = -1;
        }

        public ImageHandle refresh(int width, int height) {
            if (!this.isReusable(width, height)) {
                this.destroy();
                this.requestedWidth = width;
                this.requestedHeight = height;
                this.handleContainer = this.createHandleAtExactSize(width, height).orElseGet(() -> this.getOrCreateImageHandleAtClosestSize(width, height));
            }
            return this.handleContainer;
        }

        private boolean isReusable(int width, int height) {
            if (this.handleContainer == null || this.handleContainer.isDisposed()) {
                return false;
            }
            return this.requestedHeight == height && this.requestedWidth == width || this.handleContainer.height() == height && this.handleContainer.height() == width;
        }

        private Optional<ImageHandle> createHandleAtExactSize(int width, int height) {
            Optional<ImageData> imageData = Image.this.imageProvider.loadImageDataAtExactSize(width, height);
            if (imageData.isPresent()) {
                ImageData adaptedData = Image.this.adaptImageDataIfDisabledOrGray(imageData.get());
                this.temporaryHandleContainer = Image.this.init(adaptedData, -1);
                return Optional.of(this.temporaryHandleContainer);
            }
            return Optional.empty();
        }

        private ImageHandle getOrCreateImageHandleAtClosestSize(int widthHint, int heightHint) {
            Rectangle bounds = Image.this.getBounds(100);
            int imageZoomForWidth = 100 * widthHint / bounds.width;
            int imageZoomForHeight = 100 * heightHint / bounds.height;
            int imageZoom = DPIUtil.getZoomForAutoscaleProperty(Math.max(imageZoomForWidth, imageZoomForHeight));
            InternalImageHandle bestFittingHandle = Image.this.imageHandleManager.get(imageZoom);
            if (bestFittingHandle == null) {
                ImageData bestFittingImageData = Image.this.imageProvider.loadImageData(imageZoom).element();
                ImageData adaptedData = Image.this.adaptImageDataIfDisabledOrGray(bestFittingImageData);
                this.temporaryHandleContainer = Image.this.init(adaptedData, -1);
                bestFittingHandle = this.temporaryHandleContainer;
            }
            return bestFittingHandle;
        }
    }

    private record HandleForImageDataContainer(int type, ImageData imageData, long[] handles) {
    }

    private class ImageDataLoaderStreamProviderWrapper
    extends ImageFromImageDataProviderWrapper {
        private byte[] inputStreamData;

        ImageDataLoaderStreamProviderWrapper(InputStream inputStream) {
            try {
                this.inputStreamData = inputStream.readAllBytes();
                this.initImage();
            }
            catch (IOException e) {
                SWT.error(5, e);
            }
        }

        private ImageDataLoaderStreamProviderWrapper(byte[] inputStreamData) {
            this.inputStreamData = inputStreamData;
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return ImageDataLoader.loadByZoom(new ByteArrayInputStream(this.inputStreamData), 100, zoom);
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            ImageData scaledImageData = Image.this.getImageData(zoom);
            return new Rectangle(0, 0, scaledImageData.width, scaledImageData.height);
        }

        @Override
        AbstractImageProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageDataLoaderStreamProviderWrapper(this.inputStreamData);
        }

        @Override
        protected Optional<ImageData> loadImageDataAtExactSize(int targetWidth, int targetHeight) {
            if (ImageDataLoader.isDynamicallySizable(new ByteArrayInputStream(this.inputStreamData))) {
                ImageData imageDataAtSize = ImageDataLoader.loadBySize(new ByteArrayInputStream(this.inputStreamData), targetWidth, targetHeight);
                return Optional.of(imageDataAtSize);
            }
            return Optional.empty();
        }
    }

    private class ImageDataProviderWrapper
    extends BaseImageProviderWrapper<ImageDataProvider> {
        ImageDataProviderWrapper(ImageDataProvider provider) {
            super(provider, ImageDataProvider.class);
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return DPIUtil.validateAndGetImageDataAtZoom((ImageDataProvider)this.provider, zoom);
        }

        @Override
        ImageDataProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageDataProviderWrapper((ImageDataProvider)this.provider);
        }

        @Override
        protected Optional<ImageData> loadImageDataAtExactSize(int targetWidth, int targetHeight) {
            ImageDataProvider imageDataProvider = (ImageDataProvider)this.provider;
            if (imageDataProvider instanceof ImageDataAtSizeProvider) {
                ImageDataAtSizeProvider imageDataAtSizeProvider = (ImageDataAtSizeProvider)imageDataProvider;
                ImageData imageData = imageDataAtSizeProvider.getImageData(targetWidth, targetHeight);
                if (imageData == null) {
                    SWT.error(5, null, " ImageDataAtSizeProvider returned null for width=" + targetWidth + ", height=" + targetHeight);
                }
                return Optional.of(imageData);
            }
            return Optional.empty();
        }
    }

    private class ImageFileNameProviderWrapper
    extends BaseImageProviderWrapper<ImageFileNameProvider> {
        ImageFileNameProviderWrapper(ImageFileNameProvider provider) {
            super(provider, ImageFileNameProvider.class);
            this.newImageData(DPIUtil.getDeviceZoom());
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            DPIUtil.ElementAtZoom<ImageData> imageDataAtZoom;
            InternalImageHandle nativeInitializedImage;
            DPIUtil.ElementAtZoom<String> fileForZoom = DPIUtil.validateAndGetImagePathAtZoom((ImageFileNameProvider)this.provider, zoom);
            if (fileForZoom.zoom() != zoom && ImageDataLoader.canLoadAtZoom(fileForZoom.element(), fileForZoom.zoom(), zoom)) {
                DPIUtil.ElementAtZoom<ImageData> imageDataAtZoom2 = ImageDataLoader.loadByZoom(fileForZoom.element(), fileForZoom.zoom(), zoom);
                return new DPIUtil.ElementAtZoom<ImageData>(imageDataAtZoom2.element(), zoom);
            }
            DestroyableImageHandle temporaryImageHandle = null;
            if (Image.this.imageHandleManager.contains(fileForZoom.zoom())) {
                nativeInitializedImage = Image.this.imageHandleManager.get(fileForZoom.zoom());
            } else {
                temporaryImageHandle = this.initNative(fileForZoom.element(), fileForZoom.zoom());
                nativeInitializedImage = temporaryImageHandle;
            }
            if (nativeInitializedImage == null) {
                imageDataAtZoom = ImageDataLoader.loadByZoom(fileForZoom.element(), fileForZoom.zoom(), zoom);
            } else {
                imageDataAtZoom = new DPIUtil.ElementAtZoom<ImageData>(nativeInitializedImage.getImageData(), fileForZoom.zoom());
                if (temporaryImageHandle != null) {
                    temporaryImageHandle.destroy();
                }
            }
            return imageDataAtZoom;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.provider, Image.this.styleFlag);
        }

        @Override
        ImageFileNameProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageFileNameProviderWrapper((ImageFileNameProvider)this.provider);
        }

        DestroyableImageHandle initNative(String filename, int zoom) {
            DestroyableImageHandle imageMetadata = null;
            long handle = 0L;
            int width = -1;
            int height = -1;
            Image.this.device.checkGDIP();
            boolean gdip = true;
            if (gdip && C.PTR_SIZEOF == 8 && filename.toLowerCase().endsWith(".gif")) {
                gdip = false;
            }
            if (filename.toLowerCase().endsWith(".gif")) {
                gdip = false;
            }
            if (!gdip) {
                return null;
            }
            int length = filename.length();
            char[] chars = new char[length + 1];
            filename.getChars(0, length, chars, 0);
            long bitmap = Gdip.Bitmap_new(chars, false);
            if (bitmap == 0L) {
                return null;
            }
            int error = 2;
            int status = Gdip.Image_GetLastStatus(bitmap);
            if (status == 0) {
                if (filename.toLowerCase().endsWith(".ico")) {
                    Image.this.type = 1;
                    long[] hicon = new long[1];
                    status = Gdip.Bitmap_GetHICON(bitmap, hicon);
                    handle = hicon[0];
                    imageMetadata = new DestroyableImageHandle(handle, zoom, -1);
                } else {
                    int pixelFormat;
                    Image.this.type = 0;
                    width = Gdip.Image_GetWidth(bitmap);
                    handle = this.extractHandleForPixelFormat(width, height = Gdip.Image_GetHeight(bitmap), pixelFormat = Gdip.Image_GetPixelFormat(bitmap));
                    if (handle != 0L) {
                        long hDC = Image.this.device.internal_new_GC(null);
                        long srcHDC = OS.CreateCompatibleDC(hDC);
                        long oldSrcBitmap = OS.SelectObject(srcHDC, handle);
                        long graphics = Gdip.Graphics_new(srcHDC);
                        if (graphics != 0L) {
                            Rect rect = new Rect();
                            rect.Width = width;
                            rect.Height = height;
                            status = Gdip.Graphics_DrawImage(graphics, bitmap, rect, 0, 0, width, height, 2, 0L, 0L, 0L);
                            if (status != 0) {
                                error = 40;
                                OS.DeleteObject(handle);
                                handle = 0L;
                            }
                            Gdip.Graphics_delete(graphics);
                        }
                        OS.SelectObject(srcHDC, oldSrcBitmap);
                        OS.DeleteDC(srcHDC);
                        Image.this.device.internal_dispose_GC(hDC, null);
                        imageMetadata = new DestroyableImageHandle(handle, zoom, -1);
                    } else {
                        long lockedBitmapData = Gdip.BitmapData_new();
                        if (lockedBitmapData != 0L) {
                            status = Gdip.Bitmap_LockBits(bitmap, 0L, 0, pixelFormat, lockedBitmapData);
                            if (status == 0) {
                                BitmapData bitmapData = new BitmapData();
                                Gdip.MoveMemory(bitmapData, lockedBitmapData);
                                int stride = bitmapData.Stride;
                                long pixels = bitmapData.Scan0;
                                int depth = 0;
                                int scanlinePad = 4;
                                int transparentPixel = -1;
                                depth = this.extractDepthForPixelFormat(bitmapData);
                                if (depth != 0) {
                                    PaletteData paletteData = null;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: 
                                        case 197634: 
                                        case 198659: {
                                            int paletteSize = Gdip.Image_GetPaletteSize(bitmap);
                                            long hHeap = OS.GetProcessHeap();
                                            long palette = OS.HeapAlloc(hHeap, 8, paletteSize);
                                            if (palette == 0L) {
                                                SWT.error(2);
                                            }
                                            Gdip.Image_GetPalette(bitmap, palette, paletteSize);
                                            ColorPalette colorPalette = new ColorPalette();
                                            Gdip.MoveMemory(colorPalette, palette, ColorPalette.sizeof);
                                            int[] entries = new int[colorPalette.Count];
                                            OS.MoveMemory(entries, palette + 8L, entries.length * 4);
                                            OS.HeapFree(hHeap, 0, palette);
                                            RGB[] rgbs = new RGB[colorPalette.Count];
                                            paletteData = new PaletteData(rgbs);
                                            int i = 0;
                                            while (i < entries.length) {
                                                if ((entries[i] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                    transparentPixel = i;
                                                }
                                                rgbs[i] = new RGB((entries[i] & 0xFF0000) >> 16, (entries[i] & 0xFF00) >> 8, (entries[i] & 0xFF) >> 0);
                                                ++i;
                                            }
                                            break;
                                        }
                                        case 135173: 
                                        case 397319: {
                                            paletteData = new PaletteData(31744, 992, 31);
                                            break;
                                        }
                                        case 135174: {
                                            paletteData = new PaletteData(63488, 2016, 31);
                                            break;
                                        }
                                        case 137224: {
                                            paletteData = new PaletteData(255, 65280, 0xFF0000);
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                        }
                                    }
                                    byte[] data = new byte[stride * height];
                                    byte[] alphaData = null;
                                    OS.MoveMemory(data, pixels, data.length);
                                    switch (bitmapData.PixelFormat) {
                                        case 397319: {
                                            alphaData = new byte[width * height];
                                            int i = 1;
                                            int j = 0;
                                            while (i < data.length) {
                                                alphaData[j] = (byte)((data[i] & 0x80) != 0 ? 255 : 0);
                                                i += 2;
                                                ++j;
                                            }
                                            break;
                                        }
                                        case 2498570: {
                                            alphaData = new byte[width * height];
                                            int i = 3;
                                            int j = 0;
                                            while (i < data.length) {
                                                alphaData[j] = data[i];
                                                i += 4;
                                                ++j;
                                            }
                                            break;
                                        }
                                    }
                                    ImageData img = new ImageData(width, height, depth, paletteData, scanlinePad, data);
                                    img.transparentPixel = transparentPixel;
                                    img.alphaData = alphaData;
                                    imageMetadata = Image.this.init(img, zoom);
                                    handle = imageMetadata.handle();
                                }
                                Gdip.Bitmap_UnlockBits(bitmap, lockedBitmapData);
                            } else {
                                error = 40;
                            }
                            Gdip.BitmapData_delete(lockedBitmapData);
                        }
                    }
                }
            }
            Gdip.Bitmap_delete(bitmap);
            if (status == 0) {
                if (handle == 0L) {
                    SWT.error(error);
                }
                if (imageMetadata == null) {
                    SWT.error(error);
                }
            }
            return imageMetadata;
        }

        private int extractDepthForPixelFormat(BitmapData bitmapData) {
            int depth = 0;
            switch (bitmapData.PixelFormat) {
                case 196865: {
                    depth = 1;
                    break;
                }
                case 197634: {
                    depth = 4;
                    break;
                }
                case 198659: {
                    depth = 8;
                    break;
                }
                case 135173: 
                case 135174: 
                case 397319: {
                    depth = 16;
                    break;
                }
                case 137224: {
                    depth = 24;
                    break;
                }
                case 139273: 
                case 2498570: {
                    depth = 32;
                }
            }
            return depth;
        }

        private long extractHandleForPixelFormat(int width, int height, int pixelFormat) {
            long handle = 0L;
            switch (pixelFormat) {
                case 135173: 
                case 135174: {
                    handle = Image.createDIB(width, height, 16);
                    break;
                }
                case 8207: 
                case 137224: {
                    handle = Image.createDIB(width, height, 24);
                    break;
                }
                case 139273: 
                case 925707: 
                case 0x101004: 
                case 1060876: 
                case 1851406: 
                case 3424269: {
                    handle = Image.createDIB(width, height, 32);
                }
            }
            return handle;
        }

        @Override
        protected Optional<ImageData> loadImageDataAtExactSize(int targetWidth, int targetHeight) {
            String fileName = DPIUtil.validateAndGetImagePathAtZoom((ImageFileNameProvider)this.provider, 100).element();
            if (ImageDataLoader.isDynamicallySizable(fileName)) {
                ImageData imageDataAtSize = ImageDataLoader.loadBySize(fileName, targetWidth, targetHeight);
                return Optional.of(imageDataAtSize);
            }
            return Optional.empty();
        }
    }

    private abstract class ImageFromImageDataProviderWrapper
    extends AbstractImageProviderWrapper {
        private final Map<Integer, ImageData> cachedImageData = new HashMap<Integer, ImageData>();

        private ImageFromImageDataProviderWrapper() {
        }

        void initImage() {
            this.newImageData(100);
        }

        @Override
        ImageData newImageData(int zoom) {
            Function<Integer, ImageData> imageDataRetrieval = zoomToRetrieve -> {
                DestroyableImageHandle handle = this.initializeHandleFromSource(new ZoomContext((int)zoomToRetrieve));
                ImageData data = handle.getImageData();
                handle.destroy();
                return data;
            };
            return (ImageData)this.cachedImageData.computeIfAbsent(zoom, imageDataRetrieval).clone();
        }

        @Override
        protected DestroyableImageHandle newImageHandle(ZoomContext zoomContext) {
            ImageData cachedData = this.cachedImageData.remove(zoomContext.targetZoom());
            if (cachedData != null) {
                return this.newImageHandle(cachedData, zoomContext);
            }
            return this.initializeHandleFromSource(zoomContext);
        }

        private DestroyableImageHandle initializeHandleFromSource(ZoomContext zoomContext) {
            DPIUtil.ElementAtZoom<ImageData> imageDataAtZoom = this.loadImageData(zoomContext.targetZoom());
            ImageData imageData = DPIUtil.scaleImageData(Image.this.device, imageDataAtZoom.element(), zoomContext.targetZoom(), imageDataAtZoom.zoom());
            imageData = Image.this.adaptImageDataIfDisabledOrGray(imageData);
            return this.newImageHandle(imageData, zoomContext);
        }
    }

    private class ImageGcDrawerWrapper
    extends DynamicImageProviderWrapper {
        private ImageGcDrawer drawer;
        private int width;
        private int height;
        private ZoomContext currentZoom = new ZoomContext(100);

        ImageGcDrawerWrapper(ImageGcDrawer imageGcDrawer, int width, int height) {
            this.checkProvider(imageGcDrawer, ImageGcDrawer.class);
            this.drawer = imageGcDrawer;
            this.width = width;
            this.height = height;
        }

        @Override
        protected ZoomContext getFittingZoomContext(int targetZoom, int nativeZoom) {
            return new ZoomContext(targetZoom, nativeZoom);
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return Win32DPIUtils.scaleBounds(rectangle, zoom, 100);
        }

        @Override
        protected long configureGCData(GCData data) {
            return Image.this.configureGC(data, this.currentZoom);
        }

        @Override
        ImageData newImageData(int zoom) {
            return this.loadImageData(zoom).element();
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return new DPIUtil.ElementAtZoom<ImageData>(Image.this.getImageMetadata(new ZoomContext(zoom)).getImageData(), zoom);
        }

        @Override
        protected DestroyableImageHandle newImageHandle(ZoomContext zoomContext) {
            Image image;
            this.currentZoom = zoomContext;
            int targetZoom = zoomContext.targetZoom();
            int gcStyle = this.drawer.getGcStyle();
            if ((gcStyle & 0x40000000) != 0) {
                int scaledHeight = DPIUtil.pointToPixel(this.height, targetZoom);
                int scaledWidth = DPIUtil.pointToPixel(this.width, targetZoom);
                ImageData resultData = new ImageData(scaledWidth, scaledHeight, 24, new PaletteData(255, 65280, 0xFF0000));
                resultData.alphaData = new byte[scaledWidth * scaledHeight];
                image = new Image(Image.this.device, resultData, targetZoom);
            } else {
                image = new Image(Image.this.device, this.width, this.height);
            }
            GC gc = new GC(new DrawableWrapper(image, zoomContext), gcStyle);
            try {
                this.drawer.drawOn(gc, this.width, this.height);
                ImageData imageData = image.getImageData(targetZoom);
                this.drawer.postProcess(imageData);
                ImageData newData = Image.this.adaptImageDataIfDisabledOrGray(imageData);
                DestroyableImageHandle destroyableImageHandle = Image.this.init(newData, targetZoom);
                return destroyableImageHandle;
            }
            finally {
                gc.dispose();
                image.dispose();
            }
        }

        @Override
        Object getProvider() {
            return this.drawer;
        }

        @Override
        ImageGcDrawerWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new ImageGcDrawerWrapper(this.drawer, this.width, this.height);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getProvider().hashCode(), this.width, this.height);
        }

        @Override
        public boolean equals(Object otherProvider) {
            if (otherProvider instanceof ImageGcDrawerWrapper) {
                ImageGcDrawerWrapper aip = (ImageGcDrawerWrapper)otherProvider;
                if (this.getProvider().equals(aip.getProvider()) && this.width == aip.width && this.height == aip.height) {
                    return true;
                }
            }
            return false;
        }
    }

    abstract class ImageHandle {
        private final long handle;
        private final int zoom;
        private final int height;
        private final int width;
        private final int transparentPixel;
        private int transparentColor = -1;

        ImageHandle(long handle, int zoom, int transparentPixel) {
            this.handle = handle;
            this.zoom = zoom;
            Point bounds = this.getBoundsInPixelsFromNative();
            this.width = bounds.x;
            this.height = bounds.y;
            this.transparentPixel = transparentPixel;
        }

        long handle() {
            return this.isDisposed() ? 0L : this.handle;
        }

        int width() {
            return this.width;
        }

        int height() {
            return this.height;
        }

        Rectangle bounds() {
            return new Rectangle(0, 0, this.width, this.height);
        }

        int zoom() {
            return this.zoom;
        }

        int transparentPixel() {
            return this.transparentPixel;
        }

        int transparentColor() {
            return this.transparentColor;
        }

        void setTransparentColor(int transparentColor) {
            this.transparentColor = transparentColor;
        }

        abstract boolean isDisposed();

        private Point getBoundsInPixelsFromNative() {
            switch (Image.this.type) {
                case 0: {
                    BITMAP bm = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bm);
                    return new Point(bm.bmWidth, bm.bmHeight);
                }
                case 1: {
                    ICONINFO info = new ICONINFO();
                    OS.GetIconInfo(this.handle, info);
                    long hBitmap = info.hbmColor;
                    if (hBitmap == 0L) {
                        hBitmap = info.hbmMask;
                    }
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                    if (hBitmap == info.hbmMask) {
                        bm.bmHeight /= 2;
                    }
                    if (info.hbmColor != 0L) {
                        OS.DeleteObject(info.hbmColor);
                    }
                    if (info.hbmMask != 0L) {
                        OS.DeleteObject(info.hbmMask);
                    }
                    return new Point(bm.bmWidth, bm.bmHeight);
                }
            }
            SWT.error(40);
            return null;
        }
    }

    private class ImageHandleManager {
        private Map<Integer, DestroyableImageHandle> zoomLevelToImageHandle = new HashMap<Integer, DestroyableImageHandle>();

        private ImageHandleManager() {
        }

        InternalImageHandle get(int zoom) {
            DestroyableImageHandle imageHandle = this.zoomLevelToImageHandle.get(zoom);
            if (imageHandle == null) {
                return null;
            }
            return imageHandle;
        }

        InternalImageHandle getOrCreate(int zoom, Supplier<DestroyableImageHandle> creator) {
            if (zoom == -1) {
                return null;
            }
            DestroyableImageHandle imageHandle = (DestroyableImageHandle)this.get(zoom);
            if (imageHandle != null) {
                return imageHandle;
            }
            imageHandle = creator.get();
            this.zoomLevelToImageHandle.put(zoom, imageHandle);
            return imageHandle;
        }

        boolean contains(int zoom) {
            return this.zoomLevelToImageHandle.containsKey(zoom);
        }

        boolean isEmpty() {
            return this.zoomLevelToImageHandle.isEmpty();
        }

        List<InternalImageHandle> getAllImageHandles() {
            return this.zoomLevelToImageHandle.values().stream().collect(Collectors.toList());
        }

        Set<Integer> getAllZooms() {
            return this.zoomLevelToImageHandle.keySet();
        }

        void destroyHandles(Predicate<Integer> filter) {
            Iterator<Map.Entry<Integer, DestroyableImageHandle>> it = this.zoomLevelToImageHandle.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, DestroyableImageHandle> zoomToHandle = it.next();
                if (!filter.test(zoomToHandle.getKey())) continue;
                DestroyableImageHandle imageHandle = zoomToHandle.getValue();
                it.remove();
                this.zoomLevelToImageHandle.remove(imageHandle.zoom(), imageHandle);
                imageHandle.destroy();
            }
        }

        public String toString() {
            return this.zoomLevelToImageHandle.toString();
        }
    }

    private abstract class InternalImageHandle
    extends ImageHandle {
        InternalImageHandle(long handle, int zoom, int transparentPixel) {
            super(handle, zoom, transparentPixel);
            if (Image.this.backgroundColor != null) {
                this.setBackground(Image.this.backgroundColor);
            }
        }

        void setBackground(RGB color) {
            if (this.transparentPixel() == -1) {
                return;
            }
            long hDC = Image.this.device.internal_new_GC(null);
            BITMAP bm = new BITMAP();
            OS.GetObject(this.handle(), BITMAP.sizeof, bm);
            long hdcMem = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcMem, this.handle());
            int maxColors = 1 << bm.bmBitsPixel;
            byte[] colors = new byte[maxColors * 4];
            int numColors = OS.GetDIBColorTable(hdcMem, 0, maxColors, colors);
            int offset = this.transparentPixel() * 4;
            colors[offset] = (byte)color.blue;
            colors[offset + 1] = (byte)color.green;
            colors[offset + 2] = (byte)color.red;
            OS.SetDIBColorTable(hdcMem, 0, numColors, colors);
            OS.DeleteDC(hdcMem);
            Image.this.device.internal_dispose_GC(hDC, null);
        }

        ImageData getImageData() {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            switch (Image.this.type) {
                case 1: {
                    ICONINFO info = new ICONINFO();
                    OS.GetIconInfo(this.handle(), info);
                    long hBitmap = info.hbmColor;
                    if (hBitmap == 0L) {
                        hBitmap = info.hbmMask;
                    }
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                    int depth = bm.bmPlanes * bm.bmBitsPixel;
                    int width = bm.bmWidth;
                    if (hBitmap == info.hbmMask) {
                        bm.bmHeight /= 2;
                    }
                    int height = bm.bmHeight;
                    int numColors = 0;
                    if (depth <= 8) {
                        numColors = 1 << depth;
                    }
                    BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = (short)depth;
                    bmiHeader.biCompression = 0;
                    byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    long hDC = Image.this.device.internal_new_GC(null);
                    long hBitmapDC = OS.CreateCompatibleDC(hDC);
                    long hOldBitmap = OS.SelectObject(hBitmapDC, hBitmap);
                    OS.GetDIBits(hBitmapDC, hBitmap, 0, height, null, bmi, 0);
                    OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                    int imageSize = bmiHeader.biSizeImage;
                    byte[] data = new byte[imageSize];
                    OS.GetDIBits(hBitmapDC, hBitmap, 0, height, data, bmi, 0);
                    PaletteData palette = null;
                    if (depth <= 8) {
                        RGB[] rgbs = new RGB[numColors];
                        int srcIndex = 40;
                        int i = 0;
                        while (i < numColors) {
                            rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                            srcIndex += 4;
                            ++i;
                        }
                        palette = new PaletteData(rgbs);
                    } else if (depth == 16) {
                        palette = new PaletteData(31744, 992, 31);
                    } else if (depth == 24) {
                        palette = new PaletteData(255, 65280, 0xFF0000);
                    } else if (depth == 32) {
                        palette = new PaletteData(65280, 0xFF0000, -16777216);
                    } else {
                        SWT.error(38);
                    }
                    byte[] maskData = null;
                    byte[] alphaData = null;
                    if (info.hbmColor == 0L) {
                        maskData = new byte[imageSize];
                        OS.GetDIBits(hBitmapDC, hBitmap, height, height, maskData, bmi, 0);
                    } else {
                        bmiHeader = new BITMAPINFOHEADER();
                        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                        bmiHeader.biWidth = width;
                        bmiHeader.biHeight = -height;
                        bmiHeader.biPlanes = 1;
                        bmiHeader.biBitCount = 1;
                        bmiHeader.biCompression = 0;
                        bmi = new byte[BITMAPINFOHEADER.sizeof + 8];
                        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                        int offset = BITMAPINFOHEADER.sizeof;
                        bmi[offset + 6] = -1;
                        bmi[offset + 5] = -1;
                        bmi[offset + 4] = -1;
                        bmi[offset + 7] = 0;
                        OS.SelectObject(hBitmapDC, info.hbmMask);
                        OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, null, bmi, 0);
                        OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                        imageSize = bmiHeader.biSizeImage;
                        maskData = new byte[imageSize];
                        OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, maskData, bmi, 0);
                        boolean hasMaskData = false;
                        int i = 0;
                        while (i < maskData.length) {
                            hasMaskData |= maskData[i] != 0;
                            int n = i++;
                            maskData[n] = ~maskData[n];
                        }
                        int bpl = imageSize / height;
                        int maskPad = 1;
                        while (maskPad < 128) {
                            int calcBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                            if (calcBpl == bpl) break;
                            ++maskPad;
                        }
                        maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, 2);
                        if (!hasMaskData && depth == 32) {
                            alphaData = new byte[width * height];
                            boolean hasAlphaData = false;
                            int pixelIndex = 0;
                            while (pixelIndex < alphaData.length) {
                                alphaData[pixelIndex] = data[pixelIndex * 4 + 3];
                                hasAlphaData |= alphaData[pixelIndex] != -1;
                                ++pixelIndex;
                            }
                            if (hasAlphaData) {
                                maskData = null;
                            } else {
                                alphaData = null;
                            }
                        }
                    }
                    OS.SelectObject(hBitmapDC, hOldBitmap);
                    OS.DeleteDC(hBitmapDC);
                    Image.this.device.internal_dispose_GC(hDC, null);
                    if (info.hbmColor != 0L) {
                        OS.DeleteObject(info.hbmColor);
                    }
                    if (info.hbmMask != 0L) {
                        OS.DeleteObject(info.hbmMask);
                    }
                    ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                    imageData.alphaData = alphaData;
                    imageData.maskData = maskData;
                    imageData.maskPad = 2;
                    return imageData;
                }
                case 0: {
                    int imageSize;
                    BITMAP bm = new BITMAP();
                    OS.GetObject(this.handle(), BITMAP.sizeof, bm);
                    int depth = bm.bmPlanes * bm.bmBitsPixel;
                    int width = bm.bmWidth;
                    int height = bm.bmHeight;
                    boolean isDib = bm.bmBits != 0L;
                    long hDC = Image.this.device.internal_new_GC(null);
                    DIBSECTION dib = null;
                    if (isDib) {
                        dib = new DIBSECTION();
                        OS.GetObject(this.handle(), DIBSECTION.sizeof, dib);
                    }
                    int numColors = 0;
                    if (depth <= 8) {
                        numColors = isDib ? dib.biClrUsed : 1 << depth;
                    }
                    byte[] bmi = null;
                    BITMAPINFOHEADER bmiHeader = null;
                    if (!isDib) {
                        bmiHeader = new BITMAPINFOHEADER();
                        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                        bmiHeader.biWidth = width;
                        bmiHeader.biHeight = -height;
                        bmiHeader.biPlanes = 1;
                        bmiHeader.biBitCount = (short)depth;
                        bmiHeader.biCompression = 0;
                        bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    }
                    long hBitmapDC = OS.CreateCompatibleDC(hDC);
                    long hOldBitmap = OS.SelectObject(hBitmapDC, this.handle());
                    if (isDib) {
                        imageSize = dib.biSizeImage;
                    } else {
                        OS.GetDIBits(hBitmapDC, this.handle(), 0, height, null, bmi, 0);
                        OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                        imageSize = bmiHeader.biSizeImage;
                    }
                    byte[] data = new byte[imageSize];
                    if (isDib) {
                        OS.MoveMemory(data, bm.bmBits, imageSize);
                    } else {
                        OS.GetDIBits(hBitmapDC, this.handle(), 0, height, data, bmi, 0);
                    }
                    PaletteData palette = null;
                    if (depth <= 8) {
                        RGB[] rgbs = new RGB[numColors];
                        if (isDib) {
                            byte[] colors = new byte[numColors * 4];
                            OS.GetDIBColorTable(hBitmapDC, 0, numColors, colors);
                            int colorIndex = 0;
                            int i = 0;
                            while (i < rgbs.length) {
                                rgbs[i] = new RGB(colors[colorIndex + 2] & 0xFF, colors[colorIndex + 1] & 0xFF, colors[colorIndex] & 0xFF);
                                colorIndex += 4;
                                ++i;
                            }
                        } else {
                            int srcIndex = BITMAPINFOHEADER.sizeof;
                            int i = 0;
                            while (i < numColors) {
                                rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                                srcIndex += 4;
                                ++i;
                            }
                        }
                        palette = new PaletteData(rgbs);
                    } else if (depth == 16) {
                        palette = new PaletteData(31744, 992, 31);
                    } else if (depth == 24) {
                        palette = new PaletteData(255, 65280, 0xFF0000);
                    } else if (depth == 32) {
                        palette = new PaletteData(65280, 0xFF0000, -16777216);
                    } else {
                        SWT.error(38);
                    }
                    OS.SelectObject(hBitmapDC, hOldBitmap);
                    OS.DeleteDC(hBitmapDC);
                    Image.this.device.internal_dispose_GC(hDC, null);
                    ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                    imageData.transparentPixel = this.transparentPixel();
                    if (depth == 32) {
                        byte[] straightData = new byte[imageSize];
                        byte[] alphaData = new byte[width * height];
                        boolean validAlpha = isDib;
                        int ap = 0;
                        int dp = 0;
                        while (validAlpha && ap < alphaData.length) {
                            int b = data[dp] & 0xFF;
                            int g = data[dp + 1] & 0xFF;
                            int r = data[dp + 2] & 0xFF;
                            int a = data[dp + 3] & 0xFF;
                            alphaData[ap] = (byte)a;
                            boolean bl = validAlpha = validAlpha && b <= a && g <= a && r <= a;
                            if (a != 0) {
                                straightData[dp] = (byte)((b * 255 + a / 2) / a);
                                straightData[dp + 1] = (byte)((g * 255 + a / 2) / a);
                                straightData[dp + 2] = (byte)((r * 255 + a / 2) / a);
                            }
                            ++ap;
                            dp += 4;
                        }
                        if (validAlpha) {
                            imageData.data = straightData;
                            imageData.alphaData = alphaData;
                        } else {
                            int dp2 = 3;
                            while (dp2 < imageSize) {
                                data[dp2] = -1;
                                dp2 += 4;
                            }
                        }
                    }
                    return imageData;
                }
            }
            SWT.error(40);
            return null;
        }
    }

    private class MaskedImageDataProviderWrapper
    extends ImageFromImageDataProviderWrapper {
        private final ImageData srcAt100;
        private final ImageData maskAt100;

        MaskedImageDataProviderWrapper(ImageData srcAt100, ImageData maskAt100) {
            this.srcAt100 = (ImageData)srcAt100.clone();
            this.maskAt100 = (ImageData)maskAt100.clone();
            this.initImage();
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.srcAt100.width, this.srcAt100.height);
            return Win32DPIUtils.pointToPixel(rectangle, zoom);
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            ImageData scaledSource = DPIUtil.scaleImageData(Image.this.device, this.srcAt100, zoom, 100);
            ImageData scaledMask = DPIUtil.scaleImageData(Image.this.device, this.maskAt100, zoom, 100);
            scaledMask = ImageData.convertMask(scaledMask);
            ImageData mergedData = Image.applyMask(scaledSource, scaledMask);
            return new DPIUtil.ElementAtZoom<ImageData>(mergedData, zoom);
        }

        @Override
        AbstractImageProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new MaskedImageDataProviderWrapper(this.srcAt100, this.maskAt100);
        }
    }

    private class PlainImageDataProviderWrapper
    extends ImageFromImageDataProviderWrapper {
        private ImageData imageDataAtBaseZoom;
        private int baseZoom;

        PlainImageDataProviderWrapper(ImageData imageData) {
            this(imageData, 100);
        }

        private PlainImageDataProviderWrapper(ImageData imageData, int zoom) {
            this.imageDataAtBaseZoom = (ImageData)imageData.clone();
            this.baseZoom = zoom;
            this.initImage();
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.imageDataAtBaseZoom.width, this.imageDataAtBaseZoom.height);
            rectangle = Win32DPIUtils.pixelToPoint(rectangle, this.baseZoom);
            return Win32DPIUtils.pointToPixel(rectangle, zoom);
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return new DPIUtil.ElementAtZoom<ImageData>(this.imageDataAtBaseZoom, this.baseZoom);
        }

        @Override
        AbstractImageProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new PlainImageDataProviderWrapper(this.imageDataAtBaseZoom);
        }
    }

    private class PlainImageProviderWrapper
    extends AbstractImageProviderWrapper {
        private final int width;
        private final int height;
        private int baseZoom;

        PlainImageProviderWrapper(int width, int height) {
            if (width <= 0 || height <= 0) {
                SWT.error(5);
            }
            this.width = width;
            this.height = height;
            Image.this.type = 0;
        }

        @Override
        protected ZoomContext getFittingZoomContext(int targetZoom, int nativeZoom) {
            if (Image.this.memGC != null) {
                return new ZoomContext(targetZoom, nativeZoom);
            }
            return super.getFittingZoomContext(targetZoom, nativeZoom);
        }

        @Override
        public Collection<Integer> getPreservedZoomLevels() {
            return Collections.singleton(this.baseZoom);
        }

        @Override
        protected long configureGCData(GCData data) {
            return Image.this.configureGC(data, new ZoomContext(DPIUtil.getDeviceZoom(), DPIUtil.getNativeDeviceZoom()));
        }

        @Override
        protected Rectangle getBounds(int zoom) {
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return Win32DPIUtils.pointToPixel(rectangle, zoom);
        }

        @Override
        ImageData newImageData(int zoom) {
            if (Image.this.imageHandleManager.isEmpty()) {
                return Image.this.imageHandleManager.getOrCreate(zoom, () -> this.createBaseHandle(zoom)).getImageData();
            }
            if (Image.this.memGC != null) {
                return Image.this.imageHandleManager.getOrCreate(zoom, () -> this.newImageHandle(new ZoomContext(zoom))).getImageData();
            }
            return this.getScaledImageData(zoom);
        }

        @Override
        protected DPIUtil.ElementAtZoom<ImageData> loadImageData(int zoom) {
            return this.getClosestAvailableImageData(zoom);
        }

        @Override
        protected DestroyableImageHandle newImageHandle(ZoomContext zoomContext) {
            int targetZoom = zoomContext.targetZoom();
            if (Image.this.imageHandleManager.isEmpty()) {
                return this.createBaseHandle(targetZoom);
            }
            if (Image.this.memGC != null) {
                GC currentGC = Image.this.memGC;
                Image.this.memGC = null;
                DestroyableImageHandle imageHandle = this.createHandle(targetZoom);
                currentGC.refreshFor(new DrawableWrapper(Image.this, zoomContext), imageHandle);
                return imageHandle;
            }
            return super.newImageHandle(zoomContext);
        }

        private DestroyableImageHandle createBaseHandle(int zoom) {
            this.baseZoom = zoom;
            return this.createHandle(zoom);
        }

        private DestroyableImageHandle createHandle(int zoom) {
            long handle = this.initHandle(zoom);
            DestroyableImageHandle imageHandle = new DestroyableImageHandle(handle, zoom, -1);
            return imageHandle;
        }

        private long initHandle(int zoom) {
            if (Image.this.isDisposed()) {
                SWT.error(44);
            }
            int scaledWidth = DPIUtil.pointToPixel(this.width, zoom);
            int scaledHeight = DPIUtil.pointToPixel(this.height, zoom);
            long hDC = Image.this.device.internal_new_GC(null);
            long newHandle = OS.CreateCompatibleBitmap(hDC, scaledWidth, scaledHeight);
            if (newHandle == 0L) {
                int planes;
                int bits = OS.GetDeviceCaps(hDC, 12);
                int depth = bits * (planes = OS.GetDeviceCaps(hDC, 14));
                if (depth < 16) {
                    depth = 16;
                }
                if (depth > 24) {
                    depth = 24;
                }
                newHandle = Image.createDIB(scaledWidth, scaledHeight, depth);
            }
            if (newHandle != 0L) {
                long memDC = OS.CreateCompatibleDC(hDC);
                long hOldBitmap = OS.SelectObject(memDC, newHandle);
                OS.PatBlt(memDC, 0, 0, scaledWidth, scaledHeight, 15728673);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
            }
            Image.this.device.internal_dispose_GC(hDC, null);
            if (newHandle == 0L) {
                SWT.error(2, null, Image.this.device.getLastError());
            }
            return newHandle;
        }

        @Override
        AbstractImageProviderWrapper createCopy(Image image) {
            Image image2 = image;
            image2.getClass();
            return image2.new PlainImageProviderWrapper(this.width, this.height);
        }
    }

    private record ZoomContext(int targetZoom, int nativeZoom) {
        private ZoomContext(int targetZoom) {
            this(targetZoom, targetZoom);
        }
    }
}

