/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Solver;

final class MemoryBasedConflictTimer
extends ConflictTimerAdapter {
    private static final long NO_BOUND_COMPUTED_YET = -1L;
    private static final long serialVersionUID = 1L;
    private long memorybound = -1L;

    MemoryBasedConflictTimer(Solver<? extends DataStructureFactory> solver, int bound) {
        super(solver, bound);
    }

    private long getMemoryBound() {
        if (this.memorybound == -1L) {
            this.memorybound = Runtime.getRuntime().freeMemory() / 10L;
        }
        return this.memorybound;
    }

    @Override
    public void run() {
        long freemem = Runtime.getRuntime().freeMemory();
        if (freemem < this.getMemoryBound()) {
            this.getSolver().setNeedToReduceDB(true);
        }
    }

    public String toString() {
        return "check every " + this.bound() + " if the memory bound " + this.memorybound + " is reached";
    }
}

