/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;

public class PDFDocument
implements Drawable {
    Device device;
    long handle;
    boolean isGCCreated = false;
    boolean disposed = false;
    boolean jobStarted = false;
    boolean pageStarted = false;
    String filename;
    double width;
    double height;
    double widthInPoints;
    double heightInPoints;
    private static final String PDF_PRINTER_NAME = "Microsoft Print to PDF";

    private static PaperSize findBestPaperSize(double widthInInches, double heightInInches) {
        int[][] standardSizes = new int[][]{{1, 850, 1100}, {5, 850, 1400}, {9, 827, 1169}, {3, 1100, 1700}, {8, 1169, 1654}, {7, 725, 1050}, {11, 583, 827}};
        PaperSize bestMatch = null;
        double minWaste = Double.MAX_VALUE;
        int[][] nArrayArray = standardSizes;
        int n = standardSizes.length;
        int n2 = 0;
        while (n2 < n) {
            double waste;
            int[] size = nArrayArray[n2];
            double paperWidth = (double)size[1] / 100.0;
            double paperHeight = (double)size[2] / 100.0;
            if (widthInInches <= paperWidth && heightInInches <= paperHeight && (waste = paperWidth * paperHeight - widthInInches * heightInInches) < minWaste) {
                minWaste = waste;
                bestMatch = new PaperSize(size[0], 1, paperWidth, paperHeight);
            }
            if (widthInInches <= paperHeight && heightInInches <= paperWidth && (waste = paperHeight * paperWidth - widthInInches * heightInInches) < minWaste) {
                minWaste = waste;
                bestMatch = new PaperSize(size[0], 2, paperHeight, paperWidth);
            }
            ++n2;
        }
        if (bestMatch == null) {
            bestMatch = new PaperSize(1, 1, 8.5, 11.0);
        }
        return bestMatch;
    }

    public PDFDocument(String filename, double width, double height) {
        this(null, filename, width, height);
    }

    public PDFDocument(Device device, String filename, double width, double height) {
        if (filename == null) {
            SWT.error(4);
        }
        if (width <= 0.0 || height <= 0.0) {
            SWT.error(5);
        }
        this.filename = filename;
        this.width = width;
        this.height = height;
        if (device == null) {
            try {
                this.device = Display.getDefault();
            }
            catch (SWTException e) {
                this.device = null;
            }
        } else {
            this.device = device;
        }
        int screenDpiX = 96;
        int screenDpiY = 96;
        if (this.device != null) {
            Point dpi = this.device.getDPI();
            screenDpiX = dpi.x;
            screenDpiY = dpi.y;
        }
        double widthInInches = width / (double)screenDpiX;
        double heightInInches = height / (double)screenDpiY;
        PaperSize bestMatch = PDFDocument.findBestPaperSize(widthInInches, heightInInches);
        this.widthInPoints = bestMatch.widthInInches * 72.0;
        this.heightInPoints = bestMatch.heightInInches * 72.0;
        TCHAR driver = new TCHAR(0, "WINSPOOL", true);
        TCHAR deviceName = new TCHAR(0, PDF_PRINTER_NAME, true);
        long[] hPrinter = new long[1];
        if (OS.OpenPrinter(deviceName, hPrinter, 0L)) {
            long hHeap;
            long lpInitData;
            int dwNeeded = OS.DocumentProperties(0L, hPrinter[0], deviceName, 0L, 0L, 0);
            if (dwNeeded >= 0 && (lpInitData = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, dwNeeded)) != 0L) {
                int rc = OS.DocumentProperties(0L, hPrinter[0], deviceName, lpInitData, 0L, 2);
                if (rc == 1) {
                    DEVMODE devmode = new DEVMODE();
                    OS.MoveMemory(devmode, lpInitData, DEVMODE.sizeof);
                    devmode.dmPaperSize = (short)bestMatch.paperSizeConstant;
                    devmode.dmOrientation = (short)bestMatch.orientation;
                    devmode.dmFields = 3;
                    OS.MoveMemory(lpInitData, devmode, DEVMODE.sizeof);
                    this.handle = OS.CreateDC(driver, deviceName, 0L, lpInitData);
                }
                OS.HeapFree(hHeap, 0, lpInitData);
            }
            OS.ClosePrinter(hPrinter[0]);
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
    }

    private void ensureJobStarted() {
        if (!this.jobStarted) {
            DOCINFO di = new DOCINFO();
            di.cbSize = DOCINFO.sizeof;
            long hHeap = OS.GetProcessHeap();
            TCHAR buffer = new TCHAR(0, this.filename, true);
            int byteCount = buffer.length() * 2;
            long lpszOutput = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszOutput, buffer, byteCount);
            di.lpszOutput = lpszOutput;
            TCHAR docName = new TCHAR(0, "SWT PDF Document", true);
            int docByteCount = docName.length() * 2;
            long lpszDocName = OS.HeapAlloc(hHeap, 8, docByteCount);
            OS.MoveMemory(lpszDocName, docName, docByteCount);
            di.lpszDocName = lpszDocName;
            int rc = OS.StartDoc(this.handle, di);
            OS.HeapFree(hHeap, 0, lpszOutput);
            OS.HeapFree(hHeap, 0, lpszDocName);
            if (rc <= 0) {
                SWT.error(2);
            }
            this.jobStarted = true;
        }
    }

    private void ensurePageStarted() {
        this.ensureJobStarted();
        if (!this.pageStarted) {
            OS.StartPage(this.handle);
            this.pageStarted = true;
        }
    }

    public void newPage() {
        if (this.disposed) {
            SWT.error(24);
        }
        if (this.pageStarted) {
            OS.EndPage(this.handle);
            this.pageStarted = false;
        }
        this.ensurePageStarted();
    }

    public void newPage(double widthInPoints, double heightInPoints) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
        this.newPage();
    }

    public double getWidth() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.widthInPoints;
    }

    public double getHeight() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.heightInPoints;
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (this.isGCCreated) {
            SWT.error(5);
        }
        this.ensurePageStarted();
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.nativeZoom = 100;
            if (this.device != null) {
                data.font = this.device.getSystemFont();
            }
        }
        int screenDpiX = 96;
        int screenDpiY = 96;
        if (this.device != null) {
            Point dpi = this.device.getDPI();
            screenDpiX = dpi.x;
            screenDpiY = dpi.y;
        }
        int pdfDpiX = OS.GetDeviceCaps(this.handle, 88);
        int pdfDpiY = OS.GetDeviceCaps(this.handle, 90);
        double contentWidthInInches = this.width / (double)screenDpiX;
        double contentHeightInInches = this.height / (double)screenDpiY;
        double pageWidthInInches = this.widthInPoints / 72.0;
        double pageHeightInInches = this.heightInPoints / 72.0;
        double scaleToFitWidth = pageWidthInInches / contentWidthInInches;
        double scaleToFitHeight = pageHeightInInches / contentHeightInInches;
        double scaleToFit = Math.min(scaleToFitWidth, scaleToFitHeight);
        float scaleX = (float)(scaleToFit * (double)pdfDpiX / (double)screenDpiX);
        float scaleY = (float)(scaleToFit * (double)pdfDpiY / (double)screenDpiY);
        OS.SetGraphicsMode(this.handle, 2);
        float[] transform = new float[]{scaleX, 0.0f, 0.0f, scaleY, 0.0f, 0.0f};
        OS.SetWorldTransform(this.handle, transform);
        this.isGCCreated = true;
        return this.handle;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.handle != 0L) {
            if (this.pageStarted) {
                OS.EndPage(this.handle);
            }
            if (this.jobStarted) {
                OS.EndDoc(this.handle);
            }
            OS.DeleteDC(this.handle);
            this.handle = 0L;
        }
    }

    private static class PaperSize {
        int paperSizeConstant;
        int orientation;
        double widthInInches;
        double heightInInches;

        PaperSize(int paperSize, int orientation, double width, double height) {
            this.paperSizeConstant = paperSize;
            this.orientation = orientation;
            this.widthInInches = width;
            this.heightInInches = height;
        }
    }
}

