/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.function.Supplier;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.version.OsVersion;

public class Win32DPIUtils {
    public static boolean setDPIAwareness(int desiredDpiAwareness) {
        boolean perMonitorV2Available;
        if ((long)desiredDpiAwareness == OS.GetThreadDpiAwarenessContext()) {
            return true;
        }
        if (desiredDpiAwareness == 34 && !(perMonitorV2Available = OsVersion.IS_WIN10_1809)) {
            System.err.println("***WARNING: the OS version does not support DPI awareness mode PerMonitorV2.");
            return false;
        }
        long setDpiAwarenessResult = OS.SetThreadDpiAwarenessContext(desiredDpiAwareness);
        if (setDpiAwarenessResult == 0L) {
            System.err.println("***WARNING: setting DPI awareness failed.");
            return false;
        }
        return true;
    }

    public static <T> T runWithProperDPIAwareness(Supplier<T> operation) {
        long previousDPIAwareness = OS.GetThreadDpiAwarenessContext();
        try {
            if (!Win32DPIUtils.setDPIAwareness(34)) {
                previousDPIAwareness = 0L;
            }
            T t = operation.get();
            return t;
        }
        finally {
            if (previousDPIAwareness > 0L) {
                OS.SetThreadDpiAwarenessContext(previousDPIAwareness);
            }
        }
    }
}

