/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

class ContentDescriptorContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private INavigatorContentService contentService;
    private CheckboxTableViewer talbleViewer;

    ContentDescriptorContentProvider() {
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        if (aNewInput != null) {
            if (aNewInput instanceof INavigatorContentService) {
                this.contentService = (INavigatorContentService)aNewInput;
            }
            if (aViewer instanceof CheckboxTableViewer) {
                this.talbleViewer = (CheckboxTableViewer)aViewer;
            }
            this.updateCheckState();
        } else {
            this.contentService = null;
            this.talbleViewer = null;
        }
    }

    public Object[] getChildren(Object aParentElement) {
        return NO_CHILDREN;
    }

    public Object getParent(Object anElement) {
        return null;
    }

    public boolean hasChildren(Object anElement) {
        return this.getChildren(anElement).length != 0;
    }

    public Object[] getElements(Object anInputElement) {
        return this.contentService != null ? this.contentService.getVisibleExtensions() : NO_CHILDREN;
    }

    public void dispose() {
    }

    private void updateCheckState() {
        TableItem[] descriptorTableItems;
        if (this.talbleViewer == null || this.contentService == null) {
            return;
        }
        TableItem[] tableItemArray = descriptorTableItems = this.talbleViewer.getTable().getItems();
        int n = descriptorTableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem descriptorTableItem = tableItemArray[n2];
            if (descriptorTableItem.getData() instanceof INavigatorContentDescriptor) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorTableItem.getData();
                boolean enabled = this.contentService.getActivationService().isNavigatorExtensionActive(descriptor.getId());
                this.talbleViewer.setChecked((Object)descriptor, enabled);
            }
            ++n2;
        }
    }
}

