/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.Workbench;
import org.osgi.framework.Bundle;

class WorkbenchContributionFactory
implements IContributionFactory {
    private static final String BUNDLE_CLASS_PREFIX = "bundleclass://";
    private final IContributionFactory delegate;
    private final IEclipseContext context;
    private IWorkbenchActivitySupport activitySupport;

    WorkbenchContributionFactory(Workbench workbench) {
        this.context = workbench.getApplication().getContext();
        this.delegate = (IContributionFactory)this.context.get(IContributionFactory.class);
    }

    public Object create(String uriString, IEclipseContext context) {
        return this.delegate.create(uriString, context);
    }

    public Object create(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        return this.delegate.create(uriString, context, staticContext);
    }

    public Bundle getBundle(String uriString) {
        return this.delegate.getBundle(uriString);
    }

    public boolean isEnabled(String uriString) {
        if (uriString != null) {
            IIdentifier identifier;
            String identifierId = uriString;
            if (uriString.startsWith(BUNDLE_CLASS_PREFIX)) {
                identifierId = uriString.substring(BUNDLE_CLASS_PREFIX.length());
            }
            if (this.activitySupport == null) {
                this.activitySupport = (IWorkbenchActivitySupport)this.context.get(IWorkbenchActivitySupport.class);
            }
            if (!(identifier = this.activitySupport.getActivityManager().getIdentifier(identifierId)).isEnabled()) {
                return false;
            }
        }
        return this.delegate.isEnabled(uriString);
    }
}

